/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "time.h"
#include "unistd.h"
#include "crash.h"

PRIVATE addr_t date_cmd();
const commandtable_t command_date =
	{"date", date_cmd, "[hextime]", "convert time by strftime(3)"};

PRIVATE addr_t
date_cmd()
{
	int c;
	time_t ti;
	char buf[64];
	const char *fmt = "%c";

	while ((c = getopt(argcnt, args, "f:")) != EOF) {
		switch (c) {
		case 'f':
			fmt = optarg;
			break;
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		ti = time(NULL);
		strftime(buf, sizeof(buf), fmt, localtime(&ti));
		mprintf("%08lx  %s\n", ti, buf);
	} else {
		while (args[optind]) {
			ti = (time_t)getaddr(args[optind]);
			strftime(buf, sizeof(buf), fmt, localtime(&ti));
			mprintf("%08lx:  %s\n", ti, buf);
			optind++;
		}
	}
	return 0;
}
