/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/tty.h>

#include "printdev.h"

void
prhead_tty_struct()
{
	mprintf(SPTR" "SPTR"  PGRP  SESS   DEV   FLG CNT SHFPLW "SPTR"\n",
		"ADDR", "TERMIOS", "LINK");
}

addr_t
print_tty_struct(addr, full)
	addr_t addr;
	int full;
{
	struct tty_struct tty;

	memread(addr, sizeof(tty), &tty, "tty_struct");
	mprintf(FPTR " ", addr);
	if (tty.magic != TTY_MAGIC) {
		mprintf(" TTY_MAGIC %x\n", tty.magic);
		return 0;
	}

	mprintf(FPTR " %5d %5d ", tty.termios, tty.pgrp, tty.session);
	mprint_kdev_t(tty.device);
	mprintf(" %3lx %3x ", tty.flags, tty.count);
	mprintf("%c%c%c%c%c%c ",
		tty.stopped     ? 's': '-',
		tty.hw_stopped  ? 'h': '-',
		tty.flow_stopped? 'f': '-',
		tty.packet      ? 'p': '-',
		tty.low_latency ? 'l': '-',
		tty.warned      ? 'w': '-');
	mprintf(FPTR "\n", tty.link);
	return 0;
}
