/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/vmalloc.h>

#include "flags_vmalloc.h"

void
prhead_vm_struct()
{
	mprintf(SPTR" "SPTR"   SIZE "SPTR" FLAGS\n", "ADDR", "ADDR", "NEXT");
}

addr_t
print_vm_struct(addr)
addr_t addr;
{
	struct vm_struct vm;

	memread(addr, sizeof(struct vm_struct), &vm, "vm_struct");
	mprintf(FPTR " " FPTR " %6lx " FPTR, addr, vm.addr, vm.size, vm.next);
	mprintbit(vsflags, vm.flags);
	mprintf("\n");
	return (addr_t)vm.next;
}

addr_t
search_from_vm(addr, search)
addr_t addr, search;
{
	struct vm_struct vm;

	memread(addr, sizeof(addr_t), &addr, "vmlist");
	while (addr) {
		memread(addr, sizeof(struct vm_struct), &vm, "vm_struct");
		if ((addr_t)vm.addr <= search && (addr_t)vm.addr + vm.size > search)
			return addr;
		addr = (addr_t)vm.next;
	}
	return 0;
}
