/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/bio.h>

void
prhead_bio_vec()
{
	mprintf(SPTR" "SPTR"    LEN OFFSET\n", "ADDR", "PAGE");
}

addr_t
print_bio_vec(addr, full)
	addr_t addr;
	int full;
{
	struct bio_vec bvec;

	memread(addr, sizeof(bvec), &bvec, "bio_vec");
	mprintf(FPTR " " FPTR " %6x %6x\n", addr, bvec.bv_page, bvec.bv_len, bvec.bv_offset);
	return 0;
}

void
prhead_bio()
{
	mprintf(SPTR"     SECTOR "SPTR"  RW  SIZE "SPTR" "SPTR" CNT "SPTR" FLAGS\n",
		"ADDR", "BDEV", "IO_VEC", "END_IO", "PRIVATE");
}

addr_t
print_bio(addr, full)
	addr_t addr;
	int full;
{
	struct bio bio;
	static const struct bitname bname[] = {
		{ 1<<BIO_UPTODATE,	"uptodate" },
		{ 1<<BIO_RW_BLOCK,	"rw_block" },
		{ 1<<BIO_EOF,		"eof" },
		{ 1<<BIO_SEG_VALID,	"seg_valid" },
		{ 1<<BIO_CLONED,	"cloned" },
		{ 1<<BIO_BOUNCED,	"bounced" },
#ifdef BIO_USER_MAPPED
		{ 1<<BIO_USER_MAPPED,	"user_mapped" },
#endif
#ifdef BIO_EOPNOTSUPP
		{ 1<<BIO_EOPNOTSUPP,	"enpnosupp" },
#endif
		{ 0,			NULL }
	};

	memread(addr, sizeof(bio), &bio, "bio");
	mprintf(FPTR " ", addr);
	mprintf("%10llx ", (long long)bio.bi_sector);
	mprintf(FPTR " ", bio.bi_bdev);
	mprintf("%c%c%c ",
		(bio.bi_rw & BIO_RW_BARRIER)? 'B': '-',
		(bio.bi_rw & BIO_RW_AHEAD)? 'A': '-',
		(bio.bi_rw & BIO_RW)? 'W': 'R');
	mprintf("%5x ", bio.bi_size);
	mprintf(FPTR " " FPTR " %3x ", bio.bi_io_vec, bio.bi_end_io,
		ATOMIC_READ(bio.bi_cnt));
	mprintf(FPTR, bio.bi_private);
	mprintbit(bname, bio.bi_flags);
	mprintf("\n");
	return (addr_t)bio.bi_next;
}
