/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mm.h>
#include <linux/mmzone.h>

#include "flags_mmzone.h"

extern addr_t print_page();

void
prhead_zone()
{
#ifndef _zone_has_zone_mem_map
#ifndef _zone_has_free_pages
	mprintf(SPTR" SCANAC "SPTR" STARTPFN PAGES NAME\n",
		"ADDR", "PGDAT");
#else
	mprintf(SPTR" FREEPG "SPTR" STARTPFN PAGES NAME\n",
		"ADDR", "PGDAT");
#endif
#else
	mprintf(SPTR" FREEPG "SPTR" "SPTR" STARTPFN PAGES NAME\n",
		"ADDR", "PGDAT", "MEM_MAP");
#endif
}

addr_t
print_zone(addr, full)
	addr_t addr;
	int full;
{
	struct zone zone;
	char buf[64];
	int i;

	memread(addr, sizeof(zone), &zone, "zone");
	if (!full) {
		mprintf(FPTR, addr);
#ifndef _zone_has_free_pages
		mprintf(" %6lx ", zone.nr_scan_active);
#else
		mprintf(" %6lx ", zone.free_pages);
#endif
		mprintf(FPTR " ", zone.zone_pgdat);
#ifdef _zone_has_zone_mem_map
		mprintf(FPTR " ", zone.zone_mem_map);
#endif
		mprintf("%8lx %5lx ",
			zone.zone_start_pfn, zone.present_pages);
		memread((addr_t)zone.name, sizeof(buf), &buf, "name");
		mprintstr(buf, sizeof(buf));
		mprintf("\n");
		return 0;
	}

	mprintf("addr               " FPTR "  (%x)\n", addr, sizeof(zone));
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}

#ifdef _zone_has_free_pages
	mprintf("free_pages         %lx\n", zone.free_pages);
#endif
	mprintf("pages_min/low/high %lx/%lx/%lx\n",
		zone.pages_min, zone.pages_low, zone.pages_high);
#ifdef _zone_has_nr_scan_active
#ifndef _zone_has_nr_active
	mprintf("nr_scan_active     %lx\n", zone.nr_scan_active);
	mprintf("nr_scan_inactive   %lx\n", zone.nr_scan_inactive);
#else
	mprintf("nr_active (scan)   %lx  (%lx)\n", zone.nr_active, zone.nr_scan_active);
	mprintf("nr_inactive (scan) %lx  (%lx)\n", zone.nr_inactive, zone.nr_scan_inactive);
#endif
#else
	mprintf("nr_active          %lx\n", zone.nr_active);
	mprintf("nr_inactive        %lx\n", zone.nr_inactive);
#endif
	mprintf("all_unreclaimable  %x\n", zone.all_unreclaimable);
	mprintf("pages_scanned      %lx\n", zone.pages_scanned);
	mprintf("FREE " SPTR " " SPTR "  " SPTR "\n", "NEXT", "PREV", "MAP");
	for (i = 0; i < MAX_ORDER; i++) {
		struct free_area *fp = &zone.free_area[i];
		mprintf("%3x  ", i);
		if ((addr_t)fp->free_list.next == addr + OFFSET(struct zone, free_area[i].free_list)) {
			mprintf(SPTR " ", "-");
		} else {
			mprintf(FPTR " ", fp->free_list.next);
		}
		if ((addr_t)fp->free_list.prev == addr + OFFSET(struct zone, free_area[i].free_list)) {
			mprintf(SPTR " ", "-");
		} else {
			mprintf(FPTR " ", fp->free_list.prev);
		}
#ifdef _free_area_has_map
		mprintf(" " FPTR, fp->map);
#endif
#ifdef _free_area_has_nr_free
		mprintf("  %lx", fp->nr_free);
#endif
		mprintf("\n");
	}
	mprintf("wait_table         " FPTR "\n", zone.wait_table);
#ifdef _zone_has_wait_table_hash_nr_entries
	mprintf("wait_table_size    %lx  (2^%lx)\n",
		zone.wait_table_hash_nr_entries, zone.wait_table_bits);
#else
	mprintf("wait_table_size    %lx  (2^%lx)\n",
		zone.wait_table_size, zone.wait_table_bits);
#endif
	mprintf("zone_pgdat         " FPTR "\n", zone.zone_pgdat);
#ifdef _zone_has_zone_mem_map
	mprintf("zone_mem_map       " FPTR "\n", zone.zone_mem_map);
#endif
	mprintf("zone_start_pfn     %lx\n", zone.zone_start_pfn);

	mprintf("name               \"");
	memread((addr_t)zone.name, sizeof(buf), &buf, "name");
	mprintstr(buf, sizeof(buf));
	mprintf("\"\n");
	mprintf("spanned_pages      %lx\n", zone.spanned_pages);
	mprintf("present_pages      %lx\n", zone.present_pages);
	return 0;
}

addr_t
get_zone_from_pglist_data(addr, n)
	addr_t addr;
	int n;
{
	struct pglist_data pg;

	memread(addr, sizeof(pg), &pg, "pglist_data");
	if (n < LENGTHOF(pg.node_zones) && n < pg.nr_zones) {
		return addr + OFFSET(struct pglist_data, node_zones[n]);
	}
	return 0;
}

addr_t
print_pglist_data(addr)
	addr_t addr;
{
	struct pglist_data pg;
	char buf[256];
	int i, j;

	mprintf("addr               " FPTR "  (%x)\n", addr, sizeof(pg));
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}
	memread(addr, sizeof(pg), &pg, "pglist_data");

	mprintf("node_zones        ");
	for (i = 0; i < LENGTHOF(pg.node_zones) && i < pg.nr_zones ; i++) {
		mprintf(" " FPTR "(", addr + OFFSET(struct pglist_data, node_zones[i]));
		if (pg.node_zones[i].name) {
			memread((addr_t)pg.node_zones[i].name, sizeof(buf), &buf, "name");
			mprintstr(buf, sizeof(buf));
		}
		mprintf(")");
	}
	mprintf("\n");
	for (i = 0; i < LENGTHOF(pg.node_zonelists); i++) {
		struct zonelist *zl = &pg.node_zonelists[i];
		mprintf("%3x ", i);
		for (j = 0; j < LENGTHOF(zl->zones); j++) {
			if (zl->zones[j] == 0) {
				break;
			}
			mprintf(" " FPTR, zl->zones[j]);
		}
		mprintf("\n");
	}
	mprintf("nr_zones           %x\n", pg.nr_zones);
#if SUBLEVEL<=12 || defined(CONFIG_FLAT_NODE_MEM_MAP)
	mprintf("node_mem_map       " FPTR "\n", pg.node_mem_map);
#endif
	mprintf("bdata              " FPTR "\n", pg.bdata);
	mprintf("node_start_pfn     %lx\n", pg.node_start_pfn);
	mprintf("node_present_pages %lx / %lx\n",
		pg.node_present_pages, pg.node_spanned_pages);
	mprintf("node_id            %x\n", pg.node_id);
#ifdef _pglist_data_has_pgdat_next
	mprintf("pgdat_next         " FPTR "\n", pg.pgdat_next);
#endif
#ifdef _pglist_data_has_kswapd
	mprintf("kswapd             " FPTR "\n", pg.kswapd);
#endif
#ifdef _pglist_data_has_kswapd_max_order
	mprintf("kswapd_max_order   %x\n", pg.kswapd_max_order);
#endif
#ifndef _pglist_data_has_pgdat_next
	return 0; /*XXX*/
#else
	return (addr_t)pg.pgdat_next;
#endif
}

addr_t
get_pglist_data_next(addr)
	addr_t addr;
{
	struct pglist_data pg;
	memread(addr, sizeof(pg), &pg, "pglist_data");
#ifndef _pglist_data_has_pgdat_next
	return 0; /*XXX*/
#else
	return (addr_t)pg.pgdat_next;
#endif
}

void
print_zone_active_list(zaddr)
	addr_t zaddr;
{
	addr_t start, addr;

#ifdef PRINT_ZONE_NAME
	char buf[64];
	memread(zaddr + OFFSET(struct zone, name), sizeof(addr), &addr, "zone");
	memread(addr, sizeof(buf), &buf, "zone.name");
	mprintf(" --- ");
	mprintstr(buf, sizeof(buf));
	mprintf(" zone ---\n");
#endif /*PRINT_ZONE_NAME*/

	start = zaddr + OFFSET(struct zone, active_list);
	memread(start, sizeof(addr), &addr, "zone.active_list");
	while (addr && addr != start) {
		addr = print_page(addr, 1);
	}
}
