/*
 * Copyright (C) 2000-2007 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/sched.h>
#if SUBLEVEL<=19
#include <linux/namespace.h>
#endif
#include <linux/mount.h>

#include "flags_sched.h"

void
prhead_namespace()
{
	mprintf(SPTR" CNT "SPTR " "SPTR"\n", "ADDR", "ROOT", "MNT_LIST");
}

addr_t
print_namespace(addr)
	addr_t addr;
{
#ifdef _namespace_has_list
	struct namespace ns;

	if (addr == 0) {
		struct task_struct ts;

		memread(init_task_addr, sizeof(struct task_struct), &ts, "task_struct");
#if defined(_task_struct_has_noproxy)
		struct nsproxy nsproxy;
		memread((addr_t)ts.namespace, sizeof(nsproxy), &nsproxy, "nsproxy");
		addr = (addr_t)nsproxy.namespace;
#else
#if defined(_task_struct_has_namespace)
		addr = (addr_t)ts.namespace;
#endif
#endif
	}

	memread(addr, sizeof(struct namespace), &ns, "namespace");
	mprintf(FPTR " %3x " FPTR " ", addr, ATOMIC_READ(ns.count), ns.root);
	if (ns.list.next && (addr_t)ns.list.next != addr + OFFSET(struct namespace, list)) {
		mprintf(FPTR, (addr_t)ns.list.next - OFFSET(struct vfsmount, mnt_list));
	} else {
		mprintf(SPTR, "-");
	}
	mprintf("\n");
	return (addr_t)ns.list.next;

#else
	return 0;
#endif /*front_merge_fn*/
}
