/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t ext2_inode_info();
const commandtable_t command_ext2_inode_info =
	{"ext2_inode_info", ext2_inode_info, "{address | -i inode-address}", "print ext2_inode_info table"};

extern addr_t print_ext2_inode_info();

PRIVATE addr_t
ext2_inode_info()
{
	int c;
	int iflag = 0;

	while ((c = getopt(argcnt, args, "i")) != EOF) {
		switch (c) {
		case 'i':
			iflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		print_ext2_inode_info(getvalue(args[optind]), iflag);
		optind++;
	}
	return 0;
}
