/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t superblock();
const commandtable_t command_super_block =
	{"super_block", superblock, "[-f] [address]", "print super_block table\n  -f   print detail\n  -ff  print file[s] associated the super_block"};

addr_t super_blocks_addr;

extern addr_t print_superblock();

PRIVATE addr_t
superblock()
{
	int i, c, full = 0;
	addr_t addr = 0;
	extern void prhead_superblock();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full += 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (!full) prhead_superblock();

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			if (full) prhead_superblock();
			addr = print_superblock(getvalue(args[i]), full);
		}
	} else {
		struct list_head super_blocks;
		GETADDR(super_blocks);
		memread(super_blocks_addr, sizeof(super_blocks), &super_blocks,
			"super_blocks");
		for (addr = (addr_t)super_blocks.next; addr && addr != super_blocks_addr;) {
			if (full) prhead_superblock();
			addr = print_superblock(addr, full);
		}
	}
	return addr;
}
