/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_alloc_arg(), xfs_bmalloca();
const commandtable_t command_xfs_alloc_arg =
	{"xfs_alloc_arg", xfs_alloc_arg, "address", "[XFS] print xfs_alloc_arg table"};
const commandtable_t command_xfs_bmalloca =
	{"xfs_bmalloca", xfs_bmalloca, "address", "[XFS] print xfs_bmalloca table"};
extern void prhead_xfs_alloc_arg();
extern addr_t print_xfs_alloc_arg();
extern addr_t print_xfs_bmalloca();

PRIVATE addr_t
xfs_alloc_arg()
{
	int i, c;
	addr_t addr;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			do {
				addr = print_xfs_alloc_arg(addr);
			} while (addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
xfs_bmalloca()
{
	int i, c;
	addr_t addr;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			do {
				addr = print_xfs_bmalloca(addr);
			} while (addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
