/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t page(), vm_area_struct(), zone(), pglist_data();
const commandtable_t command_page =
	{"page", page, "[-a] address | -n #", "print page (or mem_map_t) table\n  -n  specify page number"};
const commandtable_t command_vm_area_struct =
	{"vm_area_struct", vm_area_struct, "address", "print vm_area_struct table"};
const commandtable_t command_zone =
	{"zone", zone, "address", "print zone_t (or zone_struct) table"};
const commandtable_t command_pglist_data =
	{"pglist_data", pglist_data, "[address]", "print pglist_data (or pg_data_t) table"};

extern void prhead_page();
extern addr_t print_page();
extern addr_t print_vm_area_struct();
extern addr_t print_zone();
extern addr_t print_pglist_data();
extern int sizeof_page();
addr_t active_list_addr;
addr_t mem_map_addr, mem_map;
addr_t pgdat_list_addr;

PRIVATE addr_t
page()
{
	addr_t addr, start;
	int i, c;
	int aflag = 0, nflag = 0;

	while ((c = getopt(argcnt, args, "an")) != EOF) {
		switch (c) {
		case 'a':	/* return free list */
			aflag = 1;
			break;
		case 'n':
			nflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	GETADDR(mem_map);
	if (mem_map == 0) {
		memread(mem_map_addr, sizeof(mem_map), &mem_map, "mem_map");
	}

	if (nflag) {
		int size = sizeof_page();
		if (argcnt == optind)
			THROW(usage);
		prhead_page();
		for (i = optind; i < argcnt; i++) {
			addr = print_page(mem_map + size * getaddr(args[i]), 0);
		}
		return addr;
	}

	if (argcnt > optind) {
		prhead_page();
		for (i = optind; i < argcnt; i++) {
			addr = start = getaddr(args[i]);
			do {
				addr = print_page(addr, 0);
			} while (aflag && addr && addr != start);
		}
	} else {
		struct list_head active_list;

		if (aflag)
			THROW(usage);
		GETADDR(active_list);

		prhead_page();
		memread(active_list_addr, sizeof(active_list), &active_list, "active_list");
		addr = active_list.next;
		while (addr && addr != active_list_addr) {
			addr = print_page(addr, 1);
		}
		prhead_page();
	}
	return addr;
}

PRIVATE addr_t
vm_area_struct()
{
	int c;
	addr_t addr = 0;
	const int full = 1;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}
	while (args[optind]) {
		addr = print_vm_area_struct(getaddr(args[optind]), full);
		optind++;
	}
	return addr;
}

PRIVATE addr_t
zone()
{
	int c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}
	while (args[optind]) {
		addr = print_zone(getaddr(args[optind]));
		optind++;
	}
	return addr;
}

PRIVATE addr_t
pglist_data()
{
	int c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		GETADDR(pgdat_list);
		memread(pgdat_list_addr, sizeof(addr), &addr, "pgdat_list");
		addr = print_pglist_data(addr);
	}
	while (args[optind]) {
		addr = print_pglist_data(getaddr(args[optind]));
		optind++;
	}
	return addr;
}
