/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

#include "flags_sched.h"

PRIVATE addr_t user_struct();
const commandtable_t command_user_struct =
	{"user_struct", user_struct, "[address]", "print user_struct table"};
extern addr_t print_user_struct();
extern void prhead_user_struct();

/* BEGIN kernel/user.c */
#define UIDHASH_BITS		8
#define UIDHASH_SZ		(1 << UIDHASH_BITS)
#define UIDHASH_MASK		(UIDHASH_SZ - 1)
/* END kernel/user.c*/

addr_t uidhash_table_addr;

PRIVATE addr_t
user_struct()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		int i;
		GETADDR(uidhash_table);
		prhead_user_struct();
		for (i = 0; i < UIDHASH_SZ; i++) {
#ifdef _user_struct_has_uidhash_list
			print_user_struct(uidhash_table_addr + sizeof(struct list_head) * i, 1);
#else
			print_user_struct(uidhash_table_addr + sizeof(void *) * i, 1);
#endif /*_user_struct_has_uidhash_list*/
		}
	} else {
		prhead_user_struct();
		while (args[optind]) {
			addr = print_user_struct(getvalue(args[optind]), 0);
			optind++;
		}
	}
	return addr;
}
