/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t wait_queue_head();
const commandtable_t command_wait_queue_head =
	{"wait_queue_head", wait_queue_head, "address", "print wait_queue_head_t"};
extern addr_t print_wait_queue_head();
extern void prhead_wait_queue_head();

PRIVATE addr_t
wait_queue_head()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	prhead_wait_queue_head();
	while (args[optind]) {
		addr = print_wait_queue_head(getvalue(args[optind]));
		optind++;
	}
	return addr;
}
