/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t pagebuf();
const commandtable_t command_pagebuf =
	{"page_buf", pagebuf, "[-a] [-f] [address]", "[XFS] print page_buf_t table\n  -a  follow next\n  -f  more detail"};

extern void prhead_pagebuf();
extern addr_t print_pagebuf();
extern void print_all_pagebuf();

addr_t pbhash_addr;

PRIVATE addr_t
pagebuf()
{
	int i, c;
	addr_t start, addr = 0;
	int aflag = 0, fflag = 0;

	while ((c = getopt(argcnt, args, "af")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		case 'f':
			fflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_pagebuf();
		for (i = optind; i < argcnt; i++) {
			start = addr = getvalue(args[i]);
			do {
				addr = print_pagebuf(addr, fflag);
			} while (aflag && addr && start != addr);
		}
	} else {
		GETADDR(pbhash);
		print_all_pagebuf(pbhash_addr, fflag);
	}
	return addr;
}
