<?php

/***********************************************************
 * ƥѥᥤ
 *
 * $Id: calendar.php 4717 2012-12-25 04:45:10Z kawamura $
 * $Revision: 4717 $
 * $Date:: 2012-12-25 13:45:10 +0900#$
 **********************************************************/
use Sabre\CalDAV;
use Sabre\DAV;
use Sabre\DAV\Auth;
use Sabre\DAVACL;

/* ѥɥե̾ */
define("AUTHUSERFILE", "passwd");

/* ॾ */
date_default_timezone_set('Asia/Tokyo');

/* 饤֥Ȥ߹ */
require_once 'lib/Sabre/autoload.php';
require_once 'Dg_Common.php';
require_once 'Dg_LDAP.php';
require_once '../lib/libcalendar.php';
require_once '../lib/libclass.php';

/* Хѿν */
$dg_ldapid = FALSE;
$calendar_conf = array();
$dg_resource = "";
$dg_collection = "";
$dg_authority = FALSE;
$access_type = LIGHTNING;
$realm = "MEDACA";

/* եɤ߹ */
$ret = read_calendar_conf($calendar_conf);
if ($ret === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 500 Internal Server Error");
    exit(1);
}

/* ѥɥեå */
$passfile = BASEDIR . ETCDIR . AUTHUSERFILE;
if (DgCommon_is_readable_file($passfile) === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 500 Internal Server Error");
    exit(1);
}

/* ǧڥå */
$ret = check_auth_digest();
if ($ret === FALSE) {
    result_log($dg_log_msg);
    header('HTTP/1.1 401 Unauthorized');
    header('WWW-Authenticate: Digest realm="' . $realm .
           '",qop="auth",nonce="' . uniqid() . '",opaque="' . md5($realm) . '"');
    exit(1);
}

/* 桼̾Ǽ */
$dg_user = get_username();
if ($dg_user === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 403 Forbidden");
    exit(1);
}

/* URLǧ */
$ret = check_url($dg_resource, $dg_collection);
if ($ret === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 404 Not Found");
    exit(1);

/* check_urlｪλĥ쥯̤̾ξϡ
   iPhoneΥȤư */
} else if ($ret === TRUE && $dg_collection == "") {
    $access_type = IPHONE;
}

/* ꥽ηå */
$ret = check_resource_name($dg_resource);
if ($ret === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 404 Not Found");
    exit(1);
}

/* OPTIONS,iPhoneλϡ쥯ξǤʤ */
if ($_SERVER["REQUEST_METHOD"] != "OPTIONS" && $access_type != IPHONE) {
    /* 쥯ηå */
    $ret = check_collection_name($dg_collection);
    if ($ret === FALSE) {
        result_log($dg_log_msg);
        header("HTTP/1.1 404 Not Found");
        exit(1);
    }
}

/* LDAP³ */
$ret = ldap_connect_server($dg_ldapid);
if ($ret === FALSE) {
    result_log($dg_log_msg);
    header("HTTP/1.1 500 Internal Server Error");
    exit(1);
}

/* OPTIONSλϡLDAPγǧϤʤƤ褤 */
if ($_SERVER["REQUEST_METHOD"] != "OPTIONS") {
    /* ꥽γǧ */
    /* LDAP꥽μ */
    $ret = get_resource($dg_ldapid, $dg_resource, $resourcedata);
    if ($ret == FUNC_SYSERR) {
        /* LDAP۾ */
        result_log($dg_log_msg);
        ldap_unbind($dg_ldapid);
        header("HTTP/1.1 500 Internal Server Error");
        exit(1);
    } elseif ($ret == FUNC_FALSE) {
        /* ꥽Ĥʤä -> ưե饰ǧ
           AUTOCREATE_ON -> ư , AUTOCREATE_OFF -> Τޤ */
        if ($calendar_conf["autoresourcecreate"] == AUTOCREATE_ON) {
        
            /* 桼̾ȥ꥽̾פƤ뤫 */
            if (strcmp($dg_user, $dg_resource) != 0) {
                $dg_log_msg = "Cannot found resource.(resource:$dg_resource)";
                result_log($dg_log_msg);
                ldap_unbind($dg_ldapid);
                header("HTTP/1.1 404 Not Found");
                exit(1);
            } 

            /* iPhoneǤʤȤ쥯̾ǧ */
            if ($access_type != IPHONE && strcmp($dg_collection, 
                $calendar_conf["autocreatecollectionname"]) != 0) {
                $dg_log_msg = "Cannot found resource.(resource:$dg_resource)";
                result_log($dg_log_msg);
                ldap_unbind($dg_ldapid);
                header("HTTP/1.1 404 Not Found");
                exit(1);
            }

            /* ꥽ȥ쥯 */
            $ret = create_resource_collection($dg_resource, $dg_user);
            if ($ret !== TRUE) {
                result_log($dg_log_msg);
                ldap_unbind($dg_ldapid);
                header("HTTP/1.1 500 Internal Server Error");
                exit(1);
            }

            /* Ȥϰʲξ */
            $dg_authority = AUTHREADWRITE;
        }

    } elseif ($ret == FUNC_TRUE && $access_type != IPHONE) {
        /* ꥽¸ߤƤ & iPhone³ǤϤʤ*/

        /* °̾(Ƥ°) */
        $attrs = array();

        /* 쥯 */
        $ret = get_collection($dg_resource, $dg_collection, $attrs,
                              $collectiondata);
        if ($ret == FUNC_FALSE) {
            /* 쥯¸ߤʤ */
            result_log($dg_log_msg);
            ldap_unbind($dg_ldapid);
            header("HTTP/1.1 404 Not Found");
            exit(1);
        } elseif ($ret == FUNC_SYSERR) {
            /* LDAP۾ */
            result_log($dg_log_msg);
            ldap_unbind($dg_ldapid);
            header("HTTP/1.1 500 Internal Server Error");
            exit(1);
        }

        /* ƥ֥ե饰ǧ */
        if ($collectiondata[0][CALACTIVE][0] != COLLECTION_ACTIVE) {
            $dg_log_msg = "Collection is not active.(resource:$dg_resource, " .
                          "collection:$dg_collection)";
            result_log($dg_log_msg);
            ldap_unbind($dg_ldapid);
            header("HTTP/1.1 403 Forbidden");
            exit(1);
        }

        /* 桼¤ν */
        $order = $collectiondata[0][CALAUTHORITYORDER][0];
        /* 桼¤ξ(Ϥ) */
        $article = $collectiondata[0][CALAUTHORITYARTICLE];
        /* ǥեȸ */
        $authdef = $collectiondata[0][CALAUTHORITYDEF][0];

        /* ³ǧ */
        $ret = check_authority_data($order, $article, $dg_user,
                                    $authdef, $dg_authority);
        if ($ret === FALSE) {
            /* ¾󤬤 */
            $dg_log_msg .= "(resource:$dg_resource, " .
                           "collection:$dg_collection)";
            result_log($dg_log_msg);
            ldap_unbind($dg_ldapid);
            header("HTTP/1.1 500 Internal Server Error");
            exit(1);
        }

        /* ¾ǧ */
        if ($dg_authority != AUTHREADONLY &&
            $dg_authority != AUTHREADWRITE) {
            /* ɤ߼ꡦɤ߽񤭤Ǥʤ */
            $dg_log_msg = "Not permission.(resource:$dg_resource, " .
                          "collection:$dg_collection)";
            result_log($dg_log_msg);
            ldap_unbind($dg_ldapid);
            header("HTTP/1.1 403 Forbidden");
            exit(1);
        }
    }
}

/* Хå */
/* openLDAPLDAPIDХåɥ֥ȥ饯ȤϿ */
$calendarBackend = new Sabre_CalDAV_Backend_DGLDAP($dg_ldapid);
$principalBackend = new Sabre_DAVACL_IPrincipalBackend_DGLDAP();

$tree = array(
    new CalDAV\Principal\Collection($principalBackend),
    new CalDAV\CalendarRootNode($principalBackend, $calendarBackend, ""),
);

/* ФȤƤεǽ */
$server = new DAV\Server($tree);

/* DIGESTǧڤΤΥץ饰Ͽ */
$authBackend = new Auth\Backend\File($passfile);
$authPlugin = new Auth\Plugin($authBackend, $realm);
$server->addPlugin($authPlugin);

/* ΤΥץ饰ϿʼºݤѤʤ */
$aclPlugin = new DAVACL\Plugin();
$aclPlugin->adminPrincipals[] = '{DAV:}all';
$server->addPlugin($aclPlugin);

/* Хץ饰 */
$caldavPlugin = new CalDAV\Plugin();
/* Хץ饰Ͽ */
$server->addPlugin($caldavPlugin);

// ֥饦ȤäƥǤ褦ˤ뤿Υץ饰Ͽ */
$browser = new DAV\Browser\Plugin();
$server->addPlugin($browser);

/* еǽ¹ */
$server->exec();
