<?php

/***********************************************************
 * ƥѥ饤֥
 *
 * $Id: libclass.php 4484 2012-11-21 06:08:49Z kawamura $
 * $Revision: 4484 $
 * $Date:: 2012-11-21 15:08:49 +0900#$
 **********************************************************/
use Sabre\DAV;
use Sabre\DAV\Exception;
use Sabre\CalDAV;
use Sabre\CalDAV\Backend;
use Sabre\CalDAV\Property;
use Sabre\DAVACL\PrincipalBackend;

/*********************************************************
 * Sabre_CalDAV_Backend_DGLDAP
 *
 * LDAPѤSabreDAVХåɥ֥ȥ饯
 * (Sabre\CalDAV\Backend\AbstractBackendѾƺ)
 *
 * []
 *       ʤ
 **********************************************************/
class Sabre_CalDAV_Backend_DGLDAP extends Backend\AbstractBackend {

    /* LDAPID:LDAPץͤǼ */
    protected $ldapid;

    /*********************************************************
     * getCalendarsForUser()
     *
     * 
     *
     * []
     *       $principalUri  URI(꥽̾)
     * [֤]
     *       ͤǼ줿           
     *                            ۾
     **********************************************************/
    public function getCalendarsForUser($principalUri)
    {
        global $dg_log_msg;
        global $dg_resource;
        global $dg_collection;
        global $access_type;
        global $ldap_collection_data;

        /* 饤ȥ ǧ */
        if ($access_type == LIGHTNING) {

            /* °̾(CTAGΤ) */
            $attrs = array(CALCTAG);

            /* LDAP饳쥯 */
            $ret = get_collection($dg_resource, $dg_collection, $attrs, $data);
            if ($ret != FUNC_TRUE) {
                result_log($dg_log_msg);
                return array();
            }

            /* CTagѿ˳Ǽ */
            $ctag = $data[0][CALCTAG][0];

            /*  */
            $components = array(CALDAV_VEVENT, CALDAV_VTODO);

            $ret = array();
            $ret[0] = array(
                CALDAV_ID           => CALDAV_CALENDARID_DEF,
                CALDAV_URI          => "$dg_collection",
                CALDAV_PRINCIPALURI => "$dg_resource",
                '{' . CalDAV\Plugin::NS_CALENDARSERVER . '}getctag' => "$ctag",
                '{' . CalDAV\Plugin::NS_CALDAV . '}supported-calendar-component-set' => new Property\SupportedCalendarComponentSet($components),
                           );
        /* iPhone  */
        } else if ($access_type == IPHONE) {

            /* ե륿 */
            $filter = "(&(" . OBJECTCLASS . "=" .  OBJNAME_CALCOLLECTION . ")(" .
                      CALACTIVE . "=" . COLLECTION_ACTIVE . "))";

             /* °̾ */
             $attrs = array(CALCOLLECTION, CALCTAG, COLLECTIONNUMBER,
                            COLLECTIONDESCRIPTION, CALAUTHORITYDEF, 
                            CALAUTHORITYORDER, CALAUTHORITYARTICLE);

            /* LDAP饳쥯 */
            $ret = get_collection_principals($dg_resource, $filter, $attrs, $data);
            /* 쥯󤬤ʤäȤ */
            if ($ret == FUNC_FALSE) {
                $dg_log_msg = "Cannot Find Active Collection.(resource:" .
                              $dg_resource . ")";
                result_log($dg_log_msg);
                return array();
            /* 쥯μ˼ԤȤ */
            } else if ($ret != FUNC_TRUE) {
                result_log($dg_log_msg);
                return array();
            }

            $ret = array();
            foreach($data as $one_data) {

                /* ѿ˳Ǽ */
                $collection_name = $one_data[CALCOLLECTION][0];
                $ctag            = $one_data[CALCTAG][0];
                $cnumber         = $one_data[COLLECTIONNUMBER][0];
                $cdescription    = $one_data[COLLECTIONDESCRIPTION][0];

                /*  */
                $components = array(CALDAV_VEVENT, CALDAV_VTODO);

                $ret[] = array(
                    CALDAV_ID           => "$cnumber",
                    CALDAV_URI          => "$collection_name",
                    CALDAV_PRINCIPALURI => "$dg_resource",
                    '{' . CalDAV\Plugin::NS_CALENDARSERVER . '}getctag' => "$ctag",
                    '{' . CalDAV\Plugin::NS_CALDAV . '}supported-calendar-component-set' => new Property\SupportedCalendarComponentSet($components),
                "{DAV:}displayname"     => $cdescription,
                "{urn:ietf:params:xml:ns:caldav}calendar-description"=> "",
                "{urn:ietf:params:xml:ns:caldav}calendar-timezone"=> NULL,
                "{http://apple.com/ns/ical/}calendar-order"=> NULL,
                "{http://apple.com/ns/ical/}calendar-color"=> NULL
                           );
            }
        }
        /* 쥯ǡǼ */
        $ldap_collection_data = $data;
        return $ret;
    }

    /*********************************************************
     * createCalendar()
     *
     * 
     *
     * []
     *       $principalUri  URI(꥽̾)
     *       $calendarUri   URI(쥯̾)
     *       $properties    ץѥƥ
     * [֤]
     *       TRUE           
     **********************************************************/
    public function createCalendar($principalUri,$calendarUri,array $properties)
    {
        return TRUE;
    }

    /*********************************************************
     * updateCalendar()
     *
     * ѹ
     *
     * []
     *       $calendarId    ID
     *       $properties    ץѥƥ
     * [֤]
     *       TRUE            
     **********************************************************/
    public function updateCalendar($calendarId, array $properties)
    {
        return TRUE;
    }

    /*********************************************************
     * deleteCalendar()
     *
     * κ
     *
     * []
     *       $calendarId    ID
     * [֤]
     *       TRUE           
     **********************************************************/
    public function deleteCalendar($calendarId)
    {
        return TRUE;
    }

    /*********************************************************
     * getCalendarObjects()
     *
     * α(ʣ)
     *
     * []
     *       $calendarId    ID
     * [֤]
     *       $objects       ֥Ȥ
     *       (ʤ)   ۾(Exceptionǽλ)
     **********************************************************/
    public function getCalendarObjects($calendarId)
    {
        global $dg_log_msg;
        global $calendar_conf;
        global $dg_resource;
        global $dg_collection;
        global $dg_ldapid;
        global $access_type;
        global $dg_user;
        global $ldap_collection_data;

        $ldapdata = array();
        $objects = array();
        $collection_name = $dg_collection;

        /* iPhoneΤȤϡػߥ쥯̵뤹 */
        if ($access_type == IPHONE) {

            /* 쥯󸢸¼ */
            $ret = check_collection_authority($calendarId, $colname, $dg_authority);
            if ($ret === FALSE) {
                result_log($dg_log_msg);
                throw new Exception("Cannot get collection authority." .
                                    "(resource:$dg_resource, " . 
                                    "collection:$colname)");
            }

            /* ³ǧ:ɽ or ɤ߹ߤΤߤäOK */
            if ($dg_authority != AUTHREADONLY && $dg_authority != AUTHREADWRITE) {
                result_log($dg_log_msg);
                throw new Exception("Not Permission." .
                                    "(resource:$dg_resource, " . 
                                    "collection:$colname)");
            }

            /* 쥯̾ */
            $collection_name = $colname;
        }

        /* LDAPΥ꥽쥯
           ƤΥ */
        $ret = search_all_calendar($dg_resource, $collection_name, $ldapdata);
        if ($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get calendar objects." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name)");
        }

        /* ¸ߤƤǧ */
        if (count($ldapdata) == 0) {
            /* 󤬰Ĥʤ */
            return array();
        }

        /* 뤿ηѴ */
        $objects = createReturnCalendarObject($ldapdata, RETTYPE_MANY);

        return $objects;
    }

    /*********************************************************
     * getCalendarObject()
     *
     * α(ñ)
     $*
     * []
     *       $calendarId    ID
     *       $objectUri     ֥ID
     * [֤]
     *       $objects       ֥Ȥ
     *       (ʤ)   ۾(Exceptionǽλ)
     **********************************************************/
    public function getCalendarObject($calendarId, $objectUri)
    {
        global $dg_log_msg;
        global $calendar_conf;
        global $dg_resource;
        global $dg_collection;
        global $dg_ldapid;
        global $access_type;
        global $dg_user;
        global $ldap_collection_data;

        $ldapdata = array();
        $object = array();
        $collection_name = $dg_collection;

        /* iPhoneΤȤϡػߥ쥯̵뤹 */
        if ($access_type == IPHONE) {

            /* 쥯󸢸¼ */
            $ret = check_collection_authority($calendarId, $colname, $dg_authority);
            if ($ret === FALSE) {
                result_log($dg_log_msg);
                throw new Exception("Cannot get collection authority." .
                                    "(resource:$dg_resource, " .
                                    "collection:$colname)");
            }

            /* ³ǧ */
            if ($dg_authority != AUTHREADONLY && $dg_authority != AUTHREADWRITE) {
                result_log($dg_log_msg);
                throw new Exception("Not Permission." .
                                    "(resource:$dg_resource, " .
                                    "collection:$colname)");
            }

            /* 쥯̾ */
            $collection_name = $colname;
        }

        /* LDAPΥ꥽쥯
            */
        $ret = search_calendar($objectUri, $dg_resource,
                               $collection_name, $ldapdata);
        /* ļ */
        if ($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get calendar object." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name)");
        }

        /* ¸ߤƤǧ */
        if (count($ldapdata) == 0) {
            /* 󤬤ʤ */
            return array();
        }

        /* ldapdataǤɲä */
        $ldapdata[0][CALOBJURI][0] = $objectUri;

        /* 뤿ηѴ */
        $object = createReturnCalendarObject($ldapdata, RETTYPE_ONE);

        return $object;
    }

    /*********************************************************
     * createCalendarObject()
     *
     * ɲ
     *
     * []
     *       $calendarId    ID
     *       $objectUri     ֥ID
     *       $calendarData  ǡ
     * [֤]
     *       TRUE           
     *       (ʤ)   ۾(Exceptionǽλ)
     **********************************************************/
    public function createCalendarObject($calendarId, $objectUri, $calendarData)
    {
        global $dg_log_msg;
        global $dg_authority;
        global $dg_resource;
        global $dg_collection;
        global $access_type;
        global $dg_user;
        global $ldap_collection_data;

        $authority = $dg_authority;
        $collection_name = $dg_collection;

        /* iPhoneΤȤϡػߥ쥯̵뤹 */
        if ($access_type == IPHONE) {

            /* 쥯󸢸¼ */
            $ret = check_collection_authority($calendarId, $colname, $tmp_authority);
            if ($ret === FALSE) {
                result_log($dg_log_msg);
                throw new Exception("Cannot get collection authority." .
                                    "(resource:$dg_resource, " .
                                    "collection:$colname)");
            }
            /* 쥯̾ */
            $collection_name = $colname;

            /* 쥯󸢸 */
 	    $authority = $tmp_authority;
        }

        /* ³ǧ:ɽ񤭤äOK */
        if ($authority != AUTHREADWRITE) {
            $dg_log_msg = "Not permission.(resource:$dg_resource, " .
                          "collection:$collection_name)";
            result_log($dg_log_msg);
            throw new Exception($dg_log_msg);
        }

        /* °̾(CTAGΤ) */
        $attrs = array(CALCTAG);

        /* 쥯 */
        $ret = get_collection($dg_resource, $collection_name, $attrs, $data);
        if ($ret != FUNC_TRUE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get collection." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name)");
        }

        /* Ctagͤݻ */
        $ctag = $data[0][CALCTAG][0];
        
        /* LDAPϿԤ */
        /* URI */
        $caldata[CALOBJURI] = $objectUri;
        /* ǡ */
        $caldata[CALOBJDATA] = $calendarData;
        /*  */
        $caldata[CALMODTIME] = time();
        /* ֥ȥ饹 */
        $caldata[OBJECTCLASS] = OBJNAME_CALDATA;

        /* LDAPͽꡦTODOɲ */
        $ret = ldap_calendar_add($dg_resource, $collection_name,
                                 $objectUri, $caldata);
        if($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot add calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name");
        }

        /* 򹹿CTag򥤥󥯥Ȥ */
        $ctag = $ctag + 1;

        /* 쥯CTag򹹿 */
        $ret = ldap_collection_ctag_update($dg_resource, $collection_name, $ctag);
        if ($ret === FALSE) {
            /* CTag󹹿ԥΰ¸ */
            $tmp_log_msg = $dg_log_msg;
            /*  */
            $dg_log_msg = "";

            /* Ctagι˼Ԥ硢ڤᤷԤ */
            /* Ͽǡ */
            $ret = ldap_calendar_del($dg_resource, $collection_name, $objectUri);
            if($ret === FALSE) {
                /* Ԥ礷ƽϤ */
                $dg_log_msg = $tmp_log_msg . ", " . $dg_log_msg;
            } else {
                /* CTag󹹿ԤΥϤ */
                $dg_log_msg = $tmp_log_msg;
            }

            result_log($dg_log_msg);

            throw new Exception("Cannot add calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name");
        }
    
        return TRUE;
    }

    /*********************************************************
     * updateCalendarObject()
     *
     * ֥ѹ
     *
     * []
     *       $calendarId    ID
     *       $objectUri     ֥ID
     *       $calendarData  ǡ
     * [֤]
     *       TRUE           
     *       (ʤ)   ۾(Exceptionǽλ)
     **********************************************************/
    public function updateCalendarObject($calendarId, $objectUri, $calendarData)
    {
        global $dg_log_msg;
        global $dg_authority;
        global $dg_resource;
        global $dg_collection;
        global $access_type;
        global $dg_user;
        global $ldap_collection_data;

        $authority = $dg_authority;
        $collection_name = $dg_collection;

        /* iPhoneΤȤϡػߥ쥯̵뤹 */
        if ($access_type == IPHONE) {

            /* 쥯󸢸¼ */
            $ret = check_collection_authority($calendarId, $colname, $tmp_authority);
            if ($ret === FALSE) {
                result_log($dg_log_msg);
                throw new Exception("Cannot get collection authority." .
                                    "(resource:$dg_resource, " .
                                    "collection:$colname)");
            }
            /* 쥯̾ */
            $collection_name = $colname;

            /* 쥯󸢸 */
            $authority = $tmp_authority;
        }

        /* ³ǧ:ɽ񤭤äOK */
        if ($dg_authority != AUTHREADWRITE) {
            $dg_log_msg = "Not permission.(resource:$dg_resource," .
                          "collection:$collection_name)";
            result_log($dg_log_msg);
            throw new Exception($dg_log_msg);
        }

        /* °̾(CTAGΤ) */
        $attrs = array(CALCTAG);

        /* 쥯 */
        $ret = get_collection($dg_resource, $collection_name, $attrs, $data);
        if ($ret != FUNC_TRUE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get collection." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name)");
        }

        /* Ctagͤݻ */
        $ctag = $data[0][CALCTAG][0];

        /* LDAP饫ǡξ */
        /* ڤᤷѤξ */
        $ret = search_calendar($objectUri,
                               $dg_resource, $collection_name, $ldapdata);
        if ($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                          "uri:$objectUri)");
        }

        /* ¸ߤƤǧ */
        if (count($ldapdata) == 0) {
            /* 󤬰Ĥʤ */
            result_log($dg_log_msg);
            throw new Exception("Cannot found calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                          "uri:$objectUri)");
        }
        
        /* LDAPιԤ */
        /* ǡ */
        $caldata[CALOBJDATA] = $calendarData;
        /*  */
        $caldata[CALMODTIME] = time();

        /* LDAPͽꡦTODOѹ */
        $ret = ldap_calendar_mod($dg_resource, $collection_name,
                                     $objectUri, $caldata);
        if($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot mod calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                          "uri:$objectUri)");
        }

        /* 򹹿CTag򥤥󥯥Ȥ */
        $ctag = $ctag + 1;

        /* 쥯CTag򹹿 */
        $ret = ldap_collection_ctag_update($dg_resource, $collection_name, $ctag);
        if ($ret === FALSE) {
            /* CTag󹹿ԥΰ¸ */
            $tmp_log_msg = $dg_log_msg;
            /*  */
            $dg_log_msg = "";

            /* Ctagι˼Ԥ硢ڤᤷԤ */
            $caldata = array();
            /* ѹξľ */
            $caldata[CALOBJDATA] = $ldapdata[0][CALOBJDATA][0];
            /*  */
            $caldata[CALMODTIME] = $ldapdata[0][CALMODTIME][0];

            /* LDAPΥ */
            $ret = ldap_calendar_mod($dg_resource, $collection_name,
                                     $objectUri, $caldata);
            if($ret === FALSE) {
                /* Ԥ礷ƽϤ */
                $dg_log_msg = $tmp_log_msg . ", " . $dg_log_msg;
            } else {
                /* CTag󹹿ԤΥϤ */
                $dg_log_msg = $tmp_log_msg;
            }
            result_log($dg_log_msg);

            throw new Exception("Cannot mod calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                "uri:$objectUri)");
        }

        return TRUE;
    }

    /*********************************************************
     * deleteCalendarObject()
     *
     * ֥Ⱥ
     *
     * []
     *       $calendarId    ID
     *       $objectUri     ֥ID
     * [֤]
     *       TRUE           
     *       FALSE          ۾
     **********************************************************/
    public function deleteCalendarObject($calendarId, $objectUri)
    {
        global $dg_log_msg;
        global $dg_authority;
        global $dg_resource;
        global $dg_collection;
        global $access_type;
        global $dg_user;
        global $ldap_collection_data;

        $authority = $dg_authority;
        $collection_name = $dg_collection;

        /* iPhoneΤȤϡػߥ쥯̵뤹 */
        if ($access_type == IPHONE) {

            /* 쥯󸢸¼ */
            $ret = check_collection_authority($calendarId, $colname, $tmp_authority);
            if ($ret === FALSE) {
                result_log($dg_log_msg);
                throw new Exception("Cannot get collection authority." .
                                    "(resource:$dg_resource, " .
                                    "collection:$colname)");
            }
            /* 쥯̾ */
            $collection_name = $colname;

            /* 쥯󸢸 */
            $authority = $tmp_authority;
        }

        /* ³ǧ:ɽ񤭤äOK */
        if ($dg_authority != AUTHREADWRITE) {
            $dg_log_msg = "Not permission.(resource:$dg_resource," .
                          "collection:$collection_name)";
            result_log($dg_log_msg);
            throw new Exception($dg_log_msg);
        }

        /* °̾(CTAGΤ) */
        $attrs = array(CALCTAG);

        /* 쥯 */
        $ret = get_collection($dg_resource, $collection_name, $attrs, $data);
        if ($ret != FUNC_TRUE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get collection." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name)");
        }

        /* Ctagͤݻ */
        $ctag = $data[0][CALCTAG][0];

        /* LDAP饫ǡξ */
        /* ڤᤷѤξ */
        $ret = search_calendar($objectUri,
                               $dg_resource, $collection_name, $ldapdata);
        if ($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot get calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                          "uri:$objectUri)");
        }

        /* ¸ߤƤǧ */
        if (count($ldapdata) == 0) {
            /* 󤬰Ĥʤ */
            $dg_log_msg = "Cannot found calendar data." .
                          "(resource:$dg_resource, " .
                          "collection:$collection_name, " .
                          "uri:$objectUri)";
            result_log($dg_log_msg);
            /* ѤߤʤΤǡʤ */
            return TRUE;
        }
        
        /* LDAPκԤ */
        $ret = ldap_calendar_del($dg_resource, $collection_name, $objectUri);
        if($ret === FALSE) {
            result_log($dg_log_msg);
            throw new Exception("Cannot del calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                          "uri:$objectUri)");
        }

        /* 򹹿CTag򥤥󥯥Ȥ */
        $ctag = $ctag + 1;

        /* 쥯Ctag򹹿 */
        $ret = ldap_collection_ctag_update($dg_resource, $collection_name, $ctag);
        if ($ret === FALSE) {
            /* CTag󹹿ԥΰ¸ */
            $tmp_log_msg = $dg_log_msg;
            /*  */
            $dg_log_msg = "";

            /* Ctagι˼Ԥ硢ڤᤷԤ */
            $caldata = array();
            /* ξϿ */
            /* URI */
            $caldata[CALOBJURI] = $objectUri;
            /* ǡ */
            $caldata[CALOBJDATA] = $ldapdata[0][CALOBJDATA][0];
            /*  */
            $caldata[CALMODTIME] = $ldapdata[0][CALMODTIME][0];
            /* ֥ȥ饹 */
            $caldata[OBJECTCLASS] = OBJNAME_CALDATA;

            /* LDAPɲ */
            $ret = ldap_calendar_add($dg_resource, $collection_name,
                                     $objectUri, $caldata);
            if($ret === FALSE) {
                /* Ԥ礷ƽϤ */
                $dg_log_msg = $tmp_log_msg . ", " . $dg_log_msg;
            } else {
                /* CTag󹹿ԤΥϤ */
                $dg_log_msg = $tmp_log_msg;
            }
            result_log($dg_log_msg);

            throw new Exception("Cannot del calendar data." .
                                "(resource:$dg_resource, " .
                                "collection:$collection_name, " .
                                "uri:$objectUri)");
        }

        return TRUE;
    }

    /*********************************************************
     * __construct()
     *
     * 󥹥ȥ饯
     *
     * []
     *       ʤ
     * [֤]
     *       ʤ
     **********************************************************/
    public function __construct($id) {
        $this->ldapid = $id;
    }

    /*********************************************************
     * __destruct()
     *
     * ǥȥ饯
     *
     * []
     *       ʤ
     * [֤]
     *       ʤ
     **********************************************************/
    public function __destruct() {
        ldap_unbind($this->ldapid);
    }
}

/*********************************************************
 * Sabre_DAVACL_IPrincipalBackend_DGLDAP
 *
 * LDAPѤΥץ󥷥ѥΥХå
 * (Sabre\DAVACL\PrincipalBackend\AbstractBackendѾƺ)
 *
 * []
 *       ʤ
 **********************************************************/
class Sabre_DAVACL_IPrincipalBackend_DGLDAP extends PrincipalBackend\AbstractBackend {

    /*********************************************************
     * getPrincipalsByPrefix()
     *
     * ץեå
     *
     * []
     *       $prefixPath  ץեå
     * [֤]
     *       ()   
     **********************************************************/
    function getPrincipalsByPrefix($prefixPath)
    {
        $tmp[] = array();
        return $tmp;
    }

    /*********************************************************
     * getPrincipalByPath()
     *
     * ץ󥷥ѥΥѥ
     *
     * []
     *       $path        ѥ
     * [֤]
     *       ()       
     **********************************************************/
    function getPrincipalByPath($path)
    {
        $tmp = array(CALDAV_ID  => CALDAV_CALENDARID_DEF,
                     CALDAV_URI => $path);
        return $tmp;
    }

    /*********************************************************
     * getGroupMembership()
     *
     * СΥ롼פ
     *
     * []
     *       $principal   ץ󥷥ѥ
     * [֤]
     *       ()       
     **********************************************************/
    function getGroupMembership($principal)
    {
        return array();
    }

    /*********************************************************
     * getGroupMemberSet()
     *
     * ץ󥷥ѥΥС롼פ
     *
     * []
     *       $principal   ץ󥷥ѥ
     * [֤]
     *       ʤ
     **********************************************************/
    function getGroupMemberSet($principal)
    {
    }

    /*********************************************************
     * setGroupMemberSet()
     *
     * ץ󥷥ѥΥС롼פ
     *
     * []
     *       $principal   ץ󥷥ѥ
     *       $members     С
     * [֤]
     *       ʤ
     **********************************************************/
    function setGroupMemberSet($principal, array $members)
    {
    }

    /*********************************************************
     * updatePrincipal()
     *
     * ץ󥷥ѥ򹹿
     *
     * []
     *       $principal   ץ󥷥ѥ
     *       $members     С
     * [֤]
     *       TRUE           
     **********************************************************/
    function updatePrincipal($path, $mutations)
    {
        return TRUE;
    }

    /*********************************************************
     * searchPrincipals()
     *
     * Ϥ줿ɽ̾orMailAddressˤǥץ󥷥ѥ򸡺
     *
     * []
     *       $principal   ץ󥷥ѥ
     *       $members     С
     * [֤]
     *       TRUE           
     **********************************************************/
     function searchPrincipals($prefixPath, array $searchProperties)
     {
        return TRUE;
     }
}

?>
