///////////////////////////////////////////////////////////////////////////////
//
// dll for Meltice eXtenDing "FROSTICE.MXD"
//
//   Meltice    : Meltice 2.x Copyright (C)2000-2001 ardry, Project Meltice.
//   Base Engine: Common Archiver Project DLL.
//
///////////////////////////////////////////////////////////////////////////////
// FC_INIST.CPP = Meltice Plug-ins / Flostice Config grp/ INI SeTtings.
///////////////////////////////////////////////////////////////////////////////
// $Id: FC_INIST.CPP,v 1.9 2001/06/30 11:55:10 ardry Exp $ 
///////////////////////////////////////////////////////////////////////////////

#include "mxd_fltc.h"

static const char cGlobalSection[8] = "Global";
static const char cUnPackSection[8] = "UnPack";
static const char cPackSection[8]   = "Pack";

//Generate user's ini filename.
void GetINIfilename(char *Path,const int PathLen)
{
	char INIfilename[MAX_PATH];
	GetExecDir(Path,PathLen);

	char buf[256]; unsigned long buflen=255;
	if(GetUserName(buf,&buflen)){
		BadNameCheckConv(buf, '_'); //cut probrem character by usrname.
		lstrcpyn(INIfilename,buf,MAX_PATH);
		strncat(INIfilename,".ini",MAX_PATH-strlen(INIfilename));
	}else{
		lstrcpyn(INIfilename,"MELTICE.INI",MAX_PATH);
	}


	strncat(Path,INIfilename,MAX_PATH-strlen(Path));
	return;
}

//Check folder write permission.
// return -> true = INI can write / false = INI cannot write.
static bool ChkIniPermission(void)
{
	char inipath[MAX_PATH];
	GetINIfilename(inipath,MAX_PATH);
	HANDLE hFp;

////ini file write test and check.
	hFp = CreateFile(inipath,
							GENERIC_READ|GENERIC_READ,
							FILE_SHARE_WRITE,
							NULL,
							OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							NULL);
	if(hFp == INVALID_HANDLE_VALUE )
		return false;		// No INI write permission.
	CloseHandle(hFp);

	lstrcat(inipath,".$$$");
////temp file write test.
	hFp = CreateFile(inipath,
							GENERIC_READ|GENERIC_READ,
							FILE_SHARE_WRITE,
							NULL,
							OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							NULL);
	if(hFp == INVALID_HANDLE_VALUE )
		return false;		// No INI write permission.
	CloseHandle(hFp);
	if(DeleteFile(inipath) == false) //tmp file delete failed!
		return false;

	return true;
}

// load settings from ini file.
void InicfgToMemcfg(void)
{
	//INI path setting...
	char *inipath = new char[MAX_PATH];

	char *buf = new char[MAX_PATH*4];
	GetINIfilename(inipath,MAX_PATH);

	DWORD dwIniAttr = GetFileAttributes(inipath);

	//for FAT and NTFS.
	if( dwIniAttr == 0xFFFFFFFF )
		set_cfg_readonly(false);	// Not Found
	else if( dwIniAttr & FILE_ATTRIBUTE_READONLY )
		set_cfg_readonly(true);		// Read Only (attribute)
	else
		set_cfg_readonly(false);	//Read/Write OK.
	//for NTFS and CD-ROM.
	if( ChkIniPermission() == false )
		set_cfg_readonly(true);	// Read Only (NTFS permission?)

	//DesktopDir...
	char *desktopdir = new char[MAX_PATH];
	GetWinSpecialFolderPath(desktopdir, CSIDL_DESKTOP);
	Path_Add_Backslash(desktopdir);

// [Global] Section.
	//AutoLang(Japanese or US-English switching.), default=true.
	GetPrivateProfileString(cGlobalSection,"AutoLang","1",buf,2,inipath);
	if(*buf=='0')	set_autolang( false);	// AutoLang=0 -> false
	else 			set_autolang(  true);	// AutoLang=1 -> true

	set_dialog_x(GetPrivateProfileInt(cGlobalSection,"Dialog_X",-9999,inipath));
	set_dialog_y(GetPrivateProfileInt(cGlobalSection,"Dialog_Y",-9999,inipath));

	//WriteLog(Processing Log, for debug.), default=false.
	GetPrivateProfileString(cGlobalSection,"WriteLog","0",buf,2,inipath);
	if(*buf=='0')	set_writelog( false);	// WriteLog=0 -> false
	else 			set_writelog(  true);	// WriteLog=1 -> true


// [Pack] Section.

	//smplgui (SimpleGUI), default=false.
	GetPrivateProfileString(cPackSection,"SmplGUI","0",buf,2,inipath);
	if(*buf=='0')	set_smplgui( false);	// SmplGUI=0 -> false
	else 			set_smplgui(  true);	// SmplGUI=1 -> true

	//destexp (archive to this format.)
	GetPrivateProfileString(cPackSection,"DestExp","lzh",buf,MAX_PATH,inipath);
	set_destexp(buf);

	//packlvl (Compress Level.)
	set_packlvl(GetPrivateProfileInt(cPackSection,"PackLvl",0,inipath));

	//packdir load...
	GetPrivateProfileString(cPackSection,"DestDir",desktopdir,buf,MAX_PATH,inipath);
	// --- vvv ---  '//hogehoge' shortcut convert (may be etcfunc...)
	if( *buf=='/' && *(buf+1)=='/' )
	{	// shortcut, ex... '//desktop' 
		if( *(buf+2) == 'd' )
		{ //desktop shortcut.
			set_destdir(desktopdir, MAX_PATH, 0);
		}else if( *(buf+2) == 'm' )
		{ // '//mydoc' = My Documents shortcut.
			set_destdir(
				GetWinSpecialFolderPath(buf, CSIDL_PERSONAL), 
				MAX_PATH, 0);
			//for Windows 95 without MS-Office 9x/2000
			if(*buf=='\0') set_destdir(desktopdir, MAX_PATH, 0);
		}else if( *(buf+2) == 't' )
		{ // '//temp' = temp shortcut.
			GetTempPath(MAX_PATH,buf);
			GetLongPathName95(buf,buf); //for LFN TempPath on Windows 2000 and XP.
			Path_Add_Backslash(buf);
			set_destdir(buf, MAX_PATH, 0);
		}else if( *(buf+2) == 'e' )
		{ // '//execdir' Meltice.exe path shortcut. 
			GetExecDir(buf,MAX_PATH);
			set_destdir(buf, MAX_PATH, 0);
		}else // etc shortcut = '//desktop'
		{ 
			// '//???' into memory when not reserved word.
			set_destdir(desktopdir, MAX_PATH, 0);
		}
	}else{ //load path setting
	// --- ^^^ ---  '//hogehoge' shortcut convert (may be etcfunc...)
		Path_Remove_Backslash(buf); // '\\ \\ \\ ...' Backslash heaven guard.
		Path_Add_Backslash(buf);
		set_destdir(buf, MAX_PATH, 0);
	}

	//opendir (Open Folder when flostice packed files.), default=false.
	GetPrivateProfileString(cPackSection,"OpenDir","0",buf,2,inipath);
	if(*buf=='0')	set_opendir( false, 0);	// Opendir=0 -> false
	else 			set_opendir(  true, 0);	// OpenDir=1 -> true

	//opdirex (customize for open folder when packed filees.)
	GetPrivateProfileString(cPackSection,"OpDirEx","Explorer",buf,MAX_PATH,inipath);
	set_opdirex(buf, MAX_PATH, 0);

	//samedir (frostice pack files to samedir.), default=false.
	GetPrivateProfileString(cPackSection,"SameDir","0",buf,2,inipath);
	if(*buf=='0')	set_samedir( false, 0);	// Samedir=0 -> false
	else 			set_samedir(  true, 0);	// SameDir=1 -> true

	//dosname (packed by 8.3 filename.), default=false.
	GetPrivateProfileString(cPackSection,"DosName","0",buf,2,inipath);
	if(*buf=='0')	set_dosname( false);	// DosName=0 -> false
	else 			set_dosname(  true);	// DosName=1 -> true

	//withsfx (make SFX), default=false.
	GetPrivateProfileString(cPackSection,"WithSFX","0",buf,2,inipath);
	if(*buf=='0')	set_withsfx( false);	// WithSFX=0 -> false
	else 			set_withsfx(  true);	// WithSFX=1 -> true

	//withjak (if over 1423KB, make JAK), default=true.
	GetPrivateProfileString(cPackSection,"WithJak","1",buf,2,inipath);
	if(*buf=='0')	set_withjak( false);	// WithSFX=0 -> false
	else 			set_withjak(  true);	// WithSFX=1 -> true

	//withpwd (make archive file with password), default=false.
	GetPrivateProfileString(cPackSection,"WithPwd","0",buf,2,inipath);
	if(*buf=='0')	set_withpwd( false);	// WithPwd=0 -> false
	else 			set_withpwd(  true);	// WithPwd=1 -> true

	//withmd5 (make archive file with md5 sigunature), default=false.
	GetPrivateProfileString(cPackSection,"WithMD5","0",buf,2,inipath);
	if(*buf=='0')	set_withmd5( false);	// WithMD5=0 -> false
	else 			set_withmd5(  true);	// WithMD5=1 -> true

	//MD5 form (true=long, false=short). default=false.
	GetPrivateProfileString(cPackSection,"MD5Form","0",buf,2,inipath);
	if(*buf=='0')	set_md5form( false);	// MD5Form=0 -> false
	else 			set_md5form(  true);	// MD5Form=1 -> true


	delete [] desktopdir;
	delete [] buf;
	delete [] inipath;
}

// save settings to ini file.
void MemcfgToInicfg(HWND hDlg)
{
	//INI path setting...
	char *inipath = new char[MAX_PATH]; // INI file
	char *pathbuf = new char[MAX_PATH]; // DestDir / DirOpEx Path.

	char *tmppath = new char[MAX_PATH]; // Temp Path
	char *dskpath = new char[MAX_PATH]; // Temp Path
	char *sp_path = new char[MAX_PATH]; // Temp Path

	GetTempPath(MAX_PATH,tmppath);
	GetLongPathName95(tmppath,tmppath); //for LFN TempPath on Windows 2000 and XP.
	Path_Add_Backslash(tmppath);
	GetWinSpecialFolderPath(dskpath, CSIDL_DESKTOP);
	Path_Add_Backslash(dskpath);


	GetINIfilename(inipath,MAX_PATH);


// [Global] Section.
	//AutoLanguage
	if( get_autolang() == true)
		WritePrivateProfileString(cGlobalSection, "AutoLang", "1", inipath);
	else 
		WritePrivateProfileString(cGlobalSection, "AutoLang", "0", inipath);

//    RECT rc;
//    GetWindowRect(hDlg, (LPRECT)&rc); //Get now window position.
//    wsprintf(pathbuf,"%d",rc.left); //pathbuf = not path, buffer :-P
//	WritePrivateProfileString(cGlobalSection, "Dialog_X", pathbuf, inipath);
//    wsprintf(pathbuf,"%d",rc.top);
//	WritePrivateProfileString(cGlobalSection, "Dialog_Y", pathbuf, inipath);

	//WriteLog
	if( get_writelog() == true)
		WritePrivateProfileString(cGlobalSection, "WriteLog", "1", inipath);
	else 
		WritePrivateProfileString(cGlobalSection, "WriteLog", "0", inipath);


// [Pack] Section.

	//PackMxd. (Frostice.mxd)
	WritePrivateProfileString(cPackSection,"PackMxd","Frostice.mxd",inipath);

	//SimpleGUI
	if( get_smplgui() == true)
		WritePrivateProfileString(cPackSection, "SmplGUI", "1", inipath);
	else 
		WritePrivateProfileString(cPackSection, "SmplGUI", "0", inipath);

	//destexp save...
	get_destexp(pathbuf,9);
	WritePrivateProfileString(cPackSection,"DestExp",pathbuf,inipath);

	//packlvl save...
	wsprintf(pathbuf,"%d",get_packlvl()); //pathbuf = not path, buffer :-P
	WritePrivateProfileString(cPackSection, "PackLvl", pathbuf, inipath);
	
	//packdir save...
	get_destdir(pathbuf, MAX_PATH, 0); //get meltdir.
	Path_Add_Backslash(pathbuf);

	if(lstrcmp(dskpath, pathbuf)==0)
	{
		WritePrivateProfileString(cPackSection,"DestDir","//desktop",inipath);
	}else if(lstrcmp(tmppath, pathbuf)==0)
	{ 
		WritePrivateProfileString(cPackSection,"DestDir","//temp",inipath);
	}else if(
		lstrcmp(GetWinSpecialFolderPath(sp_path, CSIDL_PERSONAL), pathbuf)==0)
	{ 
		WritePrivateProfileString(cPackSection,"DestDir","//mydoc",inipath);
	}else if(lstrcmp(GetExecDir(tmppath,MAX_PATH), pathbuf)==0)
	{ 
		WritePrivateProfileString(cPackSection,"DestDir","//execdir",inipath);
	}else
	{
		WritePrivateProfileString(cPackSection,"DestDir",pathbuf,inipath);
	}

	//opendir save...
	if( get_opendir(0) == true)
		WritePrivateProfileString(cPackSection,"OpenDir","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"OpenDir","0",inipath);


	//opdirex save...
	get_opdirex(pathbuf, MAX_PATH,0);
	WritePrivateProfileString(cPackSection,"OpDirEx",pathbuf,inipath);

	//samedir save...
	if( get_samedir(0) == true)
		WritePrivateProfileString(cPackSection,"SameDir","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"SameDir","0",inipath);

	//dosname save...
	if( get_dosname() == true)
		WritePrivateProfileString(cPackSection,"DosName","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"DosName","0",inipath);

	//withsfx save...
	if( get_withsfx() == true)
		WritePrivateProfileString(cPackSection,"WithSFX","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"WithSFX","0",inipath);

	//withjak save...
	if( get_withjak() == true)
		WritePrivateProfileString(cPackSection,"WithJak","1",inipath);
	else
		WritePrivateProfileString(cPackSection,"WithJak","0",inipath);

	//withpwd save...
	if( get_withpwd() == true)
		WritePrivateProfileString(cPackSection,"WithPwd","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"WithPwd","0",inipath);

	//md5config save...
	if( get_withmd5() == true)
		WritePrivateProfileString(cPackSection,"WithMD5","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"WithMD5","0",inipath);

	if( get_md5form() == true)
		WritePrivateProfileString(cPackSection,"MD5Form","1",inipath);
	else 
		WritePrivateProfileString(cPackSection,"MD5Form","0",inipath);

	delete [] tmppath;
	delete [] dskpath;
	delete [] sp_path;

	delete [] pathbuf;
	delete [] inipath;
	
}
