///////////////////////////////////////////////////////////////////////////////
//
// Frostice Core for Common Archiver Library v2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// FD_ARDLL.CPP = Frostice Doit group / for common ARchiver Library DLL func.
///////////////////////////////////////////////////////////////////////////////
// $Id: FD_ARDLL.CPP,v 1.13 2001/06/30 11:55:11 ardry Exp $
///////////////////////////////////////////////////////////////////////////////

#include "mxd_fltc.h"

//-----------------------------------------------------------------------------
// for Common Archiver Project DLL settings...

HINSTANCE  hInstDll[SUPPORT_DLL_NUM+1];


//dll chk...
static char dllname[SUPPORT_DLL_NUM+1][16] = 
{	"",
	"UNLHA32.DLL",
	"ZIP32J.DLL",
	"CAB32.DLL",
	"TAR32.DLL",
	"TAR32.DLL",
	"BGA32.DLL",
	"BGA32.DLL",
	"YZ1.DLL"
};

static char getver_api[SUPPORT_DLL_NUM+1][24] = 
{
	"",
	"UnlhaGetVersion",
	"ZipGetVersion",
	"CabGetVersion",
	"TarGetVersion",
	"TarGetVersion",
	"BgaGetVersion",
	"BgaGetVersion",
	"Yz1GetVersion"
};

// processing...
static char arcrun_api[SUPPORT_DLL_NUM+1][12] = 
{
	"",
	"Unlha",
	"Zip",
	"Cab",
	"Tar",
	"Tar",
	"Bga",
	"Bga",
	"Yz1"
};

//command for Compress to DOS8.3 name 
static char arcrun_dosname_cmd[SUPPORT_DLL_NUM+1][8] = {
	"",
	" -ji1 ",	//UNLHA32	: -ji0 = LFN, -ji1 = DOS name.
	" -k ",		//UNZIP32	: (no opt) = LFN, -k = DOS name.
	" -q ",		//CAB32	: (no opt) = LFN, -q = DOS name.
	"",			//tar.gz  not supported.
	"", 		//tar.bz2 not supported.
	"",			//BGA32 not supported.
	"",			//BGA32 not supported.
	""			//YZ1 not supported.
};

//DLL compress command.
static char arcrun_pack_cmd[SUPPORT_DLL_NUM+1][24] = {
	"",
	"a -x1 -r2 -a1",
	"-S -r",
	"-a -r",
	"-c -z", //TAR32  -z1 ... -z9 -> Pack Level (Default:6).
	"-c -B", //TAR32  -B1 ... -B9 -> Pack Level (Default:9).
	"a -m1 -a -r",
	"a -m2 -a -r",
	"c -y "
	
};

//DLL archive file to exe(SFX) command.
static char arcrun_sfx_cmd[SUPPORT_DLL_NUM+1][12] = {
	"",
	"s -gwe4 ",	//UNLHA32 : gw4 = NoDialog and toWinSFX32M. -gw[e|j] = en or jp.
	"--sfx ",	//this option have to need sfx32gui.dat for ZIP32J.DLL
	"-f -i ",	// -f = makeSFX, i=Silent mode.
	"",			// ---v--- TAR32.DLL can't support SFX.
	"",			// ---^--- TAR32.DLL can't support SFX.
	"s ",
	"s ",
	""			//YZ1 SFX have to need yzdec.exe, but Frostice can't support YZ1 SFX.
	
};

//DLL archive file with password command. (for zip,yz1)
static char arcrun_pwd_cmd[SUPPORT_DLL_NUM+1][4] = {
	"",
	"",		// lzh cannot support password.
	" -e",
	"",		// cab cannot support password.
	"",		// tar cannot support password.
	"",
	"",		// bga cannot support password.
	"",
	" -p"
	
};

//PackLevel.
static char arcrun_pack_with_level[SUPPORT_DLL_NUM+1][8] = {
	"",
	" -jm",	//UNLHA32	: (-jm0=lh0,) -jm1=lh1, -jm2=lh5 (Default), -jm3=lh6, -jm4=lh7, -jma=lhx-auto.
	" -",	//ZIP32J	: (-0 = Lvl0,) -1 = Level 1 ... -9 = Level 9.
	" -ml:" //CAB32		: (-ms = nocompress, -mz = mszip), -ml:15 = LZX/15 ... -ml:21 = LZX/21
	"",     //TAR32		: -z1 = Level 1 ... -z9 = Level 9.
	"",     //TAR32		: -B1 = Level 1 ... -B9 = Level 9.
	" -l",  //BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	" -l",  //BGA32		: -l1 = Level 1 ... -l9 = Level 9. (Level 9 Default.)
	""      //YZ1		: the YZ1 format has no level.
};

//Get DLL CompressLevel Command.
static void get_levelcmd(char *cmd, const int level, const int mode)
{
	char *cbuf = new char[32];
	
	switch(mode)
	{
		// (arcrun_pack_with_level) + (1...9 number.)
		case 2: //ZIP
		case 4: //TAR (gzip)
		case 5: //TAR (bzip2)
		case 6: //BGA (gzip)
		case 7: //BGA (bzip2)
			wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level);
			break;
		case 1: //LHa
			if(level >= 1 && level <= 4) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],2); // level 1,2,3,4 = lh5. (-jm2)
			else if (level >= 8) wsprintf(cmd,"%sa ",arcrun_pack_with_level[mode]); // level 8,9 = lhx (Auto).
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level-3); // level 5,6,7 = lh5,6,7. (lh1=no support.) (-jm2,3,4)
			break;
		case 3: //Cab
			if(level==1) lstrcpy(cmd, " -mz"); //mszip.
			else if(level>=2 && level<=8) wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],level+13); // level 2=LZX/15...level 8=LZX/21
			else wsprintf(cmd,"%s%d ",arcrun_pack_with_level[mode],21); // level 9=LZX/21
			break;
		//none. (etc...)
		case 8: //YZ1
		default:
			lstrcpy(cmd,"");
			break;
		
	}
}

// load Common Archiver's Project DLL
//   return true  -> DLL load success!
//   return false -> DLL load failed.
static bool load_dll(int mode)
{
	if(mode == 0) return false;
//	if(get_noardll(0) == true) return false;

	hInstDll[mode] =  LoadLibrary( dllname[mode] );
	if(hInstDll[mode] == NULL) return false;
	return true;
}

// make SFX file from archive file.
static void arc2sfx
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir,	//outputdir
		int mode)				//mode/
{
	if( !(	mode == 1 ||	//lzh
			mode == 2 ||	//zip
			mode == 3 ||	//cab
			mode == 6 ||	//gza
			mode == 7 		//bza
			) ) return; //Frostice can support lzh,zip,cabs' SFX.
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char cmdbuf[MAX_PATH * 4];
			wsprintf(cmdbuf,"%s %s %s",arcrun_sfx_cmd[mode], packedfile, outputdir);
			(*ArcRun)(hDlg,cmdbuf,NULL,0);
		}
	}
	return;
}

// make JACK file from archive file when archive file's filesize is 1423KB over
// and exist JACK32.DLL and Not create SFX File.
//(it is bonus function(as Japanese, "omake") :-)
static void arc2jak
	(	const HWND hDlg,
		const char *packedfile,	//packedfile. (packfullpath.)
		const char *outputdir)	//outputdir
{
	if( get_withsfx() == true ) return; // not supported SFX divide.
	
	HINSTANCE  hInstJakDll;
	typedef DWORD  (WINAPI *PJAKRUNFUNC)(LPCSTR,LPCSTR,int,LPCSTR);

	hInstJakDll =  LoadLibrary("JACK32.DLL");
	if(hInstJakDll == NULL) return;
	PJAKRUNFUNC JakRun = (PJAKRUNFUNC)GetProcAddress(hInstJakDll, "JackRipper");
	if(JakRun == NULL) return; // API function not ready...

	DWORD dwSize;
	HANDLE hPkFile = CreateFile(packedfile, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hPkFile == INVALID_HANDLE_VALUE )
		return ;
	//GetFileSize (0 bytes - 4GB only.)
	dwSize = GetFileSize(hPkFile,NULL);
	if (dwSize == 0xFFFFFFFF)
	{
		CloseHandle(hPkFile);
		return ; //4GB over or other error.
	}
	CloseHandle(hPkFile);
	
	if(dwSize > 1423*1024) //over 1.38MB 2HD Disksize.
	{
		int ret;
		if(get_autolang() == true && GetACP() == 932) //AutoLang == true and Japanese env.
			ret = MessageBox(hDlg,
						"Ƀt@C̃t@CTCY 1423KB ˔j܂B\n"
						"̏Ƀt@C̓tbs[fBXNɓȂ傫łB\n\n"
						"JACK32.DLL ɂ莩ȕ\ȕs܂H\n\n"
						"[͂ (Y)]@@\t: 1423KB Pʂ̎ȕ`ŕ܂B\n"
						"[ (N)]@\t: ͕܂B\n"
						"[LZ]@\t: ͕]܂(ȍ~_CAO})B",
						"Frostice  .jak s܂H",MB_ICONQUESTION|MB_YESNOCANCEL|MB_TOPMOST);
		else
			ret = MessageBox(hDlg,
						"Archive file is 1423KB over. Divide to .jak file?\n"
						"[Yes]\t: Divide to .jak file.\n"
						"[N o]\t: Not divide to .jak file now.\n"
						"[Cancel]\t: Not divide to .jak file now, and future.",
						"Do youn want to divide archive file by Frostice ?",MB_ICONQUESTION|MB_YESNOCANCEL|MB_TOPMOST);

		switch(ret)
		{
			case IDYES:
				(*JakRun)(packedfile,outputdir,1,"1423");
				break;
			case IDNO:
				break; // no divide and no setting change.
			default:
				InicfgToMemcfg();  //setting reset.
				set_withjak(false); //User don't want to Jak divide now, and future.
				MemcfgToInicfg(NULL); // withjak=false saving...
				break;
		}
	}
}

// pack and compress file from data file.
//  hDlg      <- hWnd.
//  newpkfile <- new archive file name.
//  filenames <- Filenames for Pack. (String ->["file1.txt" "file2.txt" ...] )
//  basedir   <- Base Dir.
//  outputdir <- destdir
//  mode      <- Pack mode. (lzh,zip,...)
int ardll_frost
	(	const HWND hDlg,
		const char *newpkfile,
		const char *filenames,
		const char *basedir,
		const char *outputdir,
		int mode)
{
	int ret;
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	
	if( load_dll(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
		if(ArcRun != NULL) // API function ready...
		{
			char cmdbuf[MAX_PATH * 4];
			char packfullpath[MAX_PATH];
			char packdirpath[MAX_PATH];


			lstrcpyn(packfullpath,outputdir,lstrlen(outputdir)-1);
			lstrcat(packfullpath,newpkfile);
			lstrcat(packfullpath,"\"");

			char *subcmd = new char[MAX_PATH]; char *cbuf = new char[MAX_PATH]; //Temp buffer create.
			lstrcpy(subcmd,"");
			
			//Pack Level Settings.
			if(get_packlvl() != 0)
			{
				get_levelcmd(cbuf, get_packlvl(), mode);
				lstrcat(subcmd,cbuf);
			}
			if(get_dosname() == true)
			{
				lstrcat(subcmd, arcrun_dosname_cmd[mode]);
			}
			if(get_withpwd() == true)
			{
				lstrcat(subcmd, arcrun_pwd_cmd[mode]);
			}
			
			wsprintf(cmdbuf,"%s%s %s %s %s",
				arcrun_pack_cmd[mode],subcmd,
				packfullpath, basedir, filenames);
			delete [] subcmd, cbuf;							//Temp buffer delete.

			ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];

				wsprintf(logbuf, "\r\n%s : [Base folder] %s",packfullpath, basedir);
				OutputLog("FROSTICE.LOG",logbuf);
				wsprintf(logbuf, "%s : [The files which you want to compress.] %s",packfullpath, filenames);
				OutputLog("FROSTICE.LOG",logbuf);


				wsprintf(logbuf, "%s : [%s cmd] <%s>",packfullpath, dllname[mode], cmdbuf);
				OutputLog("FROSTICE.LOG",logbuf);

				if(ret == 0)
					wsprintf(logbuf, "%s : [OK] Frostice succeeded in processing of this file.",packfullpath);
				else
					wsprintf(logbuf, "%s : [NG] Frostice failed in processing of this file. (0x%04x)",packfullpath,ret);
				OutputLog("FROSTICE.LOG",logbuf);
				delete [] logbuf;
			}

			if(ret==0){

				//make sfx files for lzh,zip,cab.
				if(get_withsfx() == true) arc2sfx(hDlg,packfullpath,outputdir,mode);
				
				//make MD5 sigunature. (archive file only), can't SFX's MD5 sig.
				if(get_withsfx() != true && get_withmd5()==true){
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					MD5SigByFile(packfullpath,get_md5form());
				}

				if(get_withsfx() != true &&  get_withjak() == true )
				{ 
					lstrcpyn(packdirpath ,outputdir+1,lstrlen(outputdir)-2);
					lstrcpyn(packfullpath,outputdir+1,lstrlen(outputdir)-2);
					lstrcat(packfullpath,newpkfile);
					arc2jak(hDlg,packfullpath,packdirpath);
				}
			}
			return ret;
		}
	}else{
		char msgbuf[100];
		wsprintf(msgbuf, "Frostice must need to %s for compress and archive.", dllname[mode]);
		MessageBox(hDlg,msgbuf,"Frostice can\'t use archiver dll engine.",MB_ICONSTOP | MB_TOPMOST );
	}
	return 1; //err.
}
