///////////////////////////////////////////////////////////////////////////////
//
// Frostice Core for Common Archiver Library v2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// FW_DIALG.CPP = Frostice Window group / DIALoG func.
///////////////////////////////////////////////////////////////////////////////
// $Id: FW_DIALG.CPP,v 1.15 2001/06/30 11:55:11 ardry Exp $
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <windowsx.h>

#include "mxd_fltc.h"
#include "resource.h"

//#include "u_util.h"

//ComboBox
LPCTSTR combostr[] = {".lzh",".zip", ".cab", ".tar.gz",".tar.bz2",".gza",".bza",".yz1"};

//CheckBox, Button, TextBox Object is enabled/disabled.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->enable / false->disable.
static void ControlEnable(HWND hDlg, int iCnt, bool sw)
{
	EnableWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg enable or disable from sw.
}

//CheckBox, Button, TextBox Object is visible/invisible.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->visible / false->invisible.
static void ControlVisible(HWND hDlg, int iCnt, bool sw)
{
	ShowWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg visible or invisible from sw.
}

//GUI util forPackLevel 
//mode = 1. lzh 2. zip 3. cab ... (expmode.)
static void Change_TrackBarForArchive(HWND hDlg,int mode)
{
	int iPackLevel = get_packlvl();
	char cPackInfo[20];

	SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_SETPOS,(WPARAM)TRUE,(LPARAM)iPackLevel);
	SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(iPackLevel!=0), 0L);
	
	//Level 0 or YZ1 mode.
	if(iPackLevel == 0 || mode == 8)
	{
		Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), " auto");
		ControlEnable(hDlg,IDC_LB_LVINFO,false);
		ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);

	}else{
		switch(mode)
		{
			case 1: //lzh
				if(iPackLevel <=4) wsprintf(cPackInfo," -lh5-");
				else if(iPackLevel >=8) wsprintf(cPackInfo," -lh? auto-");
				else wsprintf(cPackInfo," -lh%d-",iPackLevel);
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
				break;
			case 3: //cab
				if(iPackLevel ==1) wsprintf(cPackInfo," MSZIP");
				else if(iPackLevel >=2 && iPackLevel <= 8) wsprintf(cPackInfo," LZX/%d",iPackLevel+13);
				else wsprintf(cPackInfo," LZX/21");
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
				break;
			default:
				wsprintf(cPackInfo," Level %d",iPackLevel);
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
		}
	}
}

//All CheckBox Enable and Disable for Archive files.
//mode = 1. lzh 2. zip 3. cab ... (expmode.)
static void Change_ChkboxEnableForArchive(HWND hDlg,int mode)
{
	//dosname,SFX = lzh,zip,cab only.
	if(mode <= 3)
		ControlEnable(hDlg,IDC_CHK_DOSNAME,true);
	else
		ControlEnable(hDlg,IDC_CHK_DOSNAME,false);
	
	//SFX = lzh,zip,cab,gza,bza
	if(mode <= 3 || mode == 6 || mode == 7)
	{
		ControlEnable(hDlg,IDC_CHK_SFX,true);
		ControlEnable(hDlg,IDC_CHK_MD5SIG,!get_withsfx());
	}else{
		ControlEnable(hDlg,IDC_CHK_SFX,false);
		ControlEnable(hDlg,IDC_CHK_MD5SIG,true);
	}
	
	//Password = zip,yz1 only.
	if(mode == 2 || mode == 8)
		ControlEnable(hDlg,IDC_CHK_PASSWD,true);
	else
		ControlEnable(hDlg,IDC_CHK_PASSWD,false);
		
	//Pack Level.
	if(mode == 8)
	{
		ControlEnable(hDlg,IDC_CHK_LEVEL,false);
		ControlEnable(hDlg,IDC_LB_LVINFO,false);
		ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);
		set_packlvl(0);
		Change_TrackBarForArchive(hDlg,mode);
	}else{
		ControlEnable(hDlg,IDC_CHK_LEVEL,true);
		if(get_packlvl() != 0)
		{
			ControlEnable(hDlg,IDC_LB_LVINFO,true);
			ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
		}
		Change_TrackBarForArchive(hDlg,mode);
	}
}

//Dialog Procedure. //Config Dialog
LRESULT CALLBACK FTCCNFDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	//Dialog...
	UINT CodePage;
	if(get_autolang()==true)
		CodePage = GetACP();
	else CodePage = 9999; //dummy.

	int i;
	char dlgtitle[MAX_PATH*2+1]; //Dialog Title (ex. filename.zip - Frostice)
	char filename[MAX_PATH+1];
	static char filename_org[MAX_PATH+1]; //Original Settings.
	char dirname[MAX_PATH+1];
	static char dlgtitle_init[] = "%s%s - Frostice";
	int expmode;

  //// for DnD...
	HDROP hDrop;
	UINT uFileNo;
	char *szFileNames;
	char szFileName[MAX_PATH+1];
	char szBaseDir[MAX_PATH+1];
	char szFileNameBuf[MAX_PATH+1];

	switch (uMsg)
	{
		case WM_INITDIALOG:
		//////Load Dialog locate.
			RECT deskrc; //desktop rc.
			RECT rc;
			int x,y;

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = (deskrc.right - (rc.right-rc.left)) / 2;
			y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);

		//////Load Filename for Pack.
			SendMessage(GetDlgItem(hDlg, IDC_CHK_DOSNAME), BM_SETCHECK, (WPARAM)get_dosname(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_PASSWD), BM_SETCHECK, (WPARAM)get_withpwd(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_MD5SIG), BM_SETCHECK, (WPARAM)get_withmd5(), 0L);

			ControlEnable(hDlg,IDC_GRP_NEWFILE,true);
			get_destfile(filename,MAX_PATH);
			lstrcpy(filename_org,filename);
			
			if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)!=0) //for Pack Settings
			{
				Static_SetText(GetDlgItem(hDlg, IDC_ED_NEWFILE), filename);//filename -> TextBox Label.
				ControlEnable(hDlg,IDC_LB_NEWFILE,true);
				ControlEnable(hDlg,IDC_ED_NEWFILE,true);
			}else{ //Config Dialog
				Static_SetText(GetDlgItem(hDlg, IDC_ED_NEWFILE), "(Automatic naming)");//filename -> TextBox Label.
			}

			expmode = get_destexpcode();

			for (i = 0; i <= 7; i++ )
				SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_INSERTSTRING, (WPARAM)i, (LPARAM)combostr[i]);
			SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_SETCURSEL, (WPARAM)expmode-1, 0L);
			ControlEnable(hDlg,IDC_LB_EXP,true);
			ControlEnable(hDlg,IDC_COMBO_EXP,true);
			Change_ChkboxEnableForArchive(hDlg,expmode);

			//TrackBar SetRange (Min=0; Max=9)
			SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL), TBM_SETRANGE, (WPARAM)TRUE, (LPARAM)MAKELPARAM(0, 9));

			SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(get_packlvl()!=0), 0L);
			if(get_packlvl()!=0 && expmode != 8)
			{
				ControlEnable(hDlg,IDC_LB_LVINFO,true);
				ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
				Change_TrackBarForArchive(hDlg,expmode);
			}

		//////Load DestDir for Pack.
			SendMessage(GetDlgItem(hDlg, IDC_CHK_OPENDIR), BM_SETCHECK, (WPARAM)get_opendir(0), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SAMEDIR), BM_SETCHECK, (WPARAM)get_samedir(0), 0L);

			ControlEnable(hDlg,IDC_GRP_DESTDIR,true);
			ControlEnable(hDlg,IDC_CHK_OPENDIR,true);
			ControlEnable(hDlg,IDC_CHK_SAMEDIR,true);
			//SameDir?
			if( get_samedir(0) == false)
			{
				ControlEnable(hDlg,IDC_LB_DESTDIR,true);
				ControlEnable(hDlg,IDC_ED_DESTDIR,true);
				ControlEnable(hDlg,IDC_BTN_BROWSE,true);
				ControlEnable(hDlg,IDC_BTN_OPEN,true);
			}
			get_destdir(dirname,MAX_PATH,0);
			Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//filename -> TextBox Label.

		//////Info. and Apply.
			ControlEnable(hDlg,IDC_BTN_INFO,true);
			ControlEnable(hDlg,IDC_BTN_APPLY,true);

		//////SimpleGUI... (Silent mode.)
			ControlEnable(hDlg,IDC_CHK_SILENT,true);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SILENT), BM_SETCHECK, (WPARAM)get_smplgui(), 0L);

		//////Read only? (if readonly then OK/Apply is disabled.)
			if( get_cfg_readonly() == true )
			{
				if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)==0)
					ControlEnable(hDlg, IDOK, false);    //OK Button is disabled when settings dialog.
				ControlEnable(hDlg, IDC_BTN_APPLY, false); //Apply Button is disabled.
			}

		//////Drag and Drop for Dialog.
			if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)==0) //for Config Dialog
			{
				DragAcceptFiles(hDlg, TRUE);
			}
			SetActiveWindow(hDlg);
			SetForegroundWindow(hDlg);

			return true;

		case WM_DROPFILES:
			hDrop = (HDROP)wParam;
			uFileNo = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);
			szFileNames = new char[MAX_PATH*(uFileNo+4)];
			*szFileNames = '\0';
			for(i = 0; i < (int)uFileNo; i++) {
				DragQueryFile(hDrop, i, szFileName, sizeof(szFileName));
				if(i==0)
				{
					lstrcpy(szFileNameBuf,szFileName);
					lstrcpy(szBaseDir, "\""); lstrcat(szBaseDir, getDirName(szFileNameBuf)); lstrcat(szBaseDir, "\" ");
				}
				lstrcpy(szFileNameBuf,szFileName);
				lstrcat(szFileNames, "\""); lstrcat(szFileNames, getFileName(szFileNameBuf)); 
				if(GetFileAttributes(szFileNameBuf)& FILE_ATTRIBUTE_DIRECTORY)
					lstrcat(szFileNames,"\\*.*");
				lstrcat(szFileNames, "\" ");
			}
		////// Lock Config Window and show archiving dialog...
			ShowWindow(hDlg,SW_HIDE); EnableWindow(hDlg,false); //Config Dialog hide.
			PackArchive(szFileNames,szBaseDir);
			EnableWindow(hDlg,true); ShowWindow(hDlg,SW_SHOW);//Config Dialog show.
		////// for Properties Dialog Initialization...
			set_destfile(DUMMYMSG_FOR_CONFIG,MAX_PATH);
			lstrcpy(filename_org,DUMMYMSG_FOR_CONFIG);

			SendMessage(GetDlgItem(hDlg, IDC_CHK_DOSNAME), BM_SETCHECK, (WPARAM)get_dosname(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_PASSWD), BM_SETCHECK, (WPARAM)get_withpwd(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_MD5SIG), BM_SETCHECK, (WPARAM)get_withmd5(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SILENT), BM_SETCHECK, (WPARAM)get_smplgui(), 0L);
			expmode = get_destexpcode();
			Change_ChkboxEnableForArchive(hDlg,expmode);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(get_packlvl()!=0), 0L);
			if(get_packlvl()!=0 && expmode != 8)
			{
				ControlEnable(hDlg,IDC_LB_LVINFO,true);
				ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
				Change_TrackBarForArchive(hDlg,expmode);
			}
			SendMessage(GetDlgItem(hDlg, IDC_CHK_OPENDIR), BM_SETCHECK, (WPARAM)get_opendir(0), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SAMEDIR), BM_SETCHECK, (WPARAM)get_samedir(0), 0L);
			if( get_samedir(0) == false)
			{
				ControlEnable(hDlg,IDC_LB_DESTDIR,true);
				ControlEnable(hDlg,IDC_ED_DESTDIR,true);
				ControlEnable(hDlg,IDC_BTN_BROWSE,true);
				ControlEnable(hDlg,IDC_BTN_OPEN,true);
			}
			SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_SETCURSEL, (WPARAM)expmode-1, 0L);
			get_destdir(dirname,MAX_PATH,0);
			Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//filename -> TextBox Label.

			return false;
		case WM_HSCROLL:
			expmode = get_destexpcode();
			set_packlvl((int)SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_GETPOS,(WPARAM)0L,(LPARAM)0L));
			if(get_packlvl()==0) SetFocus(GetDlgItem(hDlg, IDC_CHK_LEVEL));

			Change_TrackBarForArchive(hDlg,expmode);
			break;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			////// button
				case IDOK:
					if(get_smplgui()==true)
						MemcfgToInicfg(NULL);
					else if(lstrcmp(filename_org,DUMMYMSG_FOR_CONFIG)==0) //for Config Dialog
						MemcfgToInicfg(NULL);
					EndDialog(hDlg, IDOK); //end.
					break;
				case IDCANCEL:
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDC_BTN_APPLY:
					MemcfgToInicfg(NULL);
					break;
				case IDC_BTN_INFO:
					VerInfoDialog(hDlg);
					break;
				case IDC_COMBO_EXP:
					set_destexpcode((int)(DWORD)SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_GETCURSEL, 0L, 0L)+1);
					expmode = get_destexpcode();
					set_packlvl((int)SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_GETPOS,(WPARAM)0L,(LPARAM)0L));
					Change_ChkboxEnableForArchive(hDlg,expmode);
					Change_TrackBarForArchive(hDlg,expmode);
					//IDC_ED_NEWFILE must be run after IDC_COMBO_EXP...
				case IDC_ED_NEWFILE:
					if(lstrcmp(filename_org,DUMMYMSG_FOR_CONFIG)!=0) //for Pack Settings
					{
						GetDlgItemText(hDlg, IDC_ED_NEWFILE, (LPTSTR)filename, sizeof(filename));
						set_destfile(filename, MAX_PATH);
						wsprintf(dlgtitle,dlgtitle_init,filename,combostr[get_destexpcode()-1]);
						SetWindowText(hDlg,dlgtitle);
					}
					break;
				case IDC_ED_DESTDIR:
					GetDlgItemText(hDlg, IDC_ED_DESTDIR, (LPTSTR)dirname, sizeof(filename));
					if( get_samedir(0) == false)
						set_destdir(dirname, MAX_PATH,0);
					break;
				case IDC_BTN_OPEN:
					get_destdir(dirname,MAX_PATH,0);
					DWORD fa;
					fa = GetFileAttributes(dirname);
					if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
						char *buf = new char[MAX_PATH*4+1];
						char *opdirpath = new char[MAX_PATH+1]; // Open Folder Path.
						get_opdirex(opdirpath, MAX_PATH, 0);
						wsprintf(buf,"%s \"%s\"", opdirpath, dirname);
						WinExec(buf, SW_SHOW);
						delete [] opdirpath;
						delete [] buf;
					}
					break;
				case IDC_BTN_BROWSE:
					get_destdir(dirname, MAX_PATH, 0);
					{
						char *strbuf = new char[MAX_PATH];

						if(CodePage==932)
							lstrcpyn(strbuf, "ktH_IĉB", MAX_PATH); //Japanese Message...
						else
							lstrcpyn(strbuf, "Data file archive to...", MAX_PATH);

						i = BrowseFolder(hDlg, dirname, strbuf);
						delete [] strbuf;
					}
					set_destdir(dirname, MAX_PATH, 0);
					get_destdir(dirname, MAX_PATH, 0);
					if(i != 0 ){ //not cancel
						Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//New Dir overwrite TextBox
					}
					break;
				case IDC_CHK_SAMEDIR:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SAMEDIR) == BST_CHECKED) {
						set_samedir(true,0);
					}else{
						set_samedir(false,0);
					}
					ControlEnable(hDlg,IDC_LB_DESTDIR,!get_samedir(0));
					ControlEnable(hDlg,IDC_ED_DESTDIR,!get_samedir(0));
					ControlEnable(hDlg,IDC_BTN_BROWSE,!get_samedir(0));
					ControlEnable(hDlg,IDC_BTN_OPEN,!get_samedir(0));
					break;
				case IDC_CHK_OPENDIR:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_OPENDIR) == BST_CHECKED) {
						set_opendir(true,0);
					}else{
						set_opendir(false,0);
					}
					break;
				case IDC_CHK_DOSNAME:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_DOSNAME) == BST_CHECKED) {
						set_dosname(true);
					}else{
						set_dosname(false);
					}
					break;
				case IDC_CHK_SFX:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SFX) == BST_CHECKED) {
						set_withsfx(true);
					}else{
						set_withsfx(false);
					}
					Change_ChkboxEnableForArchive(hDlg,get_destexpcode());
					break;
				case IDC_CHK_PASSWD:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_PASSWD) == BST_CHECKED) {
						set_withpwd(true);
					}else{
						set_withpwd(false);
					}
					break;
				case IDC_CHK_MD5SIG:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_MD5SIG) == BST_CHECKED) {
						set_withmd5(true);
					}else{
						set_withmd5(false);
					}
					break;
				case IDC_CHK_LEVEL:
					expmode = get_destexpcode();
					if(IsDlgButtonChecked(hDlg, IDC_CHK_LEVEL) == BST_CHECKED) {
						ControlEnable(hDlg,IDC_LB_LVINFO,true);
						ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
						switch(expmode)
						{
							case 1: //lzh
								set_packlvl(5);
								break;
							case 2: //zip
								set_packlvl(6);
								break;
							case 3: //cab
								set_packlvl(1);
								break;
							case 5: //tar.bz2
							case 7: //bza
								set_packlvl(9);
								break;
							case 4: //tar.gz
							case 6: //gza
								set_packlvl(6);
								break;
						}
						Change_TrackBarForArchive(hDlg,expmode);
					}else{
						ControlEnable(hDlg,IDC_LB_LVINFO,false);
						ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);
						set_packlvl(0);
						Change_TrackBarForArchive(hDlg,expmode);
					}
					break;
				case IDC_CHK_SILENT:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SILENT) == BST_CHECKED) {
						set_smplgui(true);
					}else{
						set_smplgui(false);
					}
					break;
				default:
					break;
			}
		default:
			return FALSE;
	}
	return FALSE;
}

