#include <libmemcached/memcached.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <md5.h>
#include <omp.h>

int main(int argc, char *argv[])
{
  srand(time(NULL));
  int i, ctx;
  int suc = 0;
    memcached_st *memc;
    memcached_return rc;
    memcached_server_st *servers;
    memc= memcached_create(NULL);
    servers= memcached_servers_parse(argv[1]);
    memcached_server_push(memc, servers);
    memcached_server_list_free(servers);
    rc = memcached_behavior_set(memc, MEMCACHED_BEHAVIOR_NO_BLOCK, 1);
#pragma omp parallel for
  for(i=0;i<10000;++i)
  {
    MD5_CTX con;
    char key[33], val[11];
    int randkey;
    randkey = rand_r(&ctx);
    sprintf(key,"%010d",randkey);
    sprintf(val,"%010d",randkey);
    MD5Init(&con);
    MD5Update(&con, key, strlen(key));
    MD5End(&con, key);
    /* printf("%s:%s\n",key,val); */
    rc= memcached_set(memc,key, strlen(key),
           val, strlen(val), 0, 0);
    if (rc != MEMCACHED_SUCCESS)
    {
      fprintf(stderr, "memset: %s: memcache error %s",
            key, memcached_strerror(memc, rc));
      if (memc->cached_errno)
      fprintf(stderr, " system error %s", strerror(memc->cached_errno));
      fprintf(stderr, "\n");
    }else
    {
      ++suc;
    }
  }
    memcached_free(memc);
  printf("try=%d success=%d ratio=%f\n",i,suc,(double)suc/i*100.0);
  return(0);
}
