/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.internal.INavigatable;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.DecoratingColorLabelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementLabelProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelManager;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineContributionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public abstract class StructuredViewerAdvisor
implements IAdaptable {
    private StructuredViewer viewer;
    private ISynchronizePageConfiguration configuration;
    private StatusLineContributionGroup statusLine;
    private SynchronizeModelManager modelManager;
    private INavigatable nav;
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.team.ui.view_syncinfo_in_label") && StructuredViewerAdvisor.this.viewer != null && !StructuredViewerAdvisor.this.viewer.getControl().isDisposed()) {
                StructuredViewerAdvisor.this.viewer.refresh(true);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public StructuredViewerAdvisor(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        configuration.setProperty("org.eclipse.team.ui.P_ADVISOR", this);
        this.modelManager = (SynchronizeModelManager)((Object)configuration.getProperty("org.eclipse.team.ui.P_MODEL_MANAGER"));
        if (this.modelManager == null) {
            this.modelManager = this.createModelManager(configuration);
        }
        Assert.isNotNull((Object)((Object)this.modelManager), (String)"model manager must be set");
        this.modelManager.setViewerAdvisor(this);
    }

    protected abstract SynchronizeModelManager createModelManager(ISynchronizePageConfiguration var1);

    public final void initializeViewer(StructuredViewer viewer) {
        Assert.isTrue((this.viewer == null ? 1 : 0) != 0, (String)"Can only be initialized once.");
        Assert.isTrue((boolean)this.validateViewer(viewer));
        this.viewer = viewer;
        this.initializeListeners(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.hookContextMenu(viewer);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.internal.INavigatable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.nav == null) {
                this.nav = new INavigatable(){

                    public boolean gotoDifference(boolean next) {
                        return StructuredViewerAdvisor.this.navigate(next);
                    }
                };
            }
            return this.nav;
        }
        return null;
    }

    private void initializeStatusLine() {
        this.statusLine = new StatusLineContributionGroup(this.configuration.getSite().getShell(), this.configuration);
    }

    public void dispose() {
        if (this.statusLine != null) {
            this.statusLine.dispose();
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        TeamUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(this.propertyListener);
    }

    public abstract boolean navigate(boolean var1);

    public void setSelection(ISelection selection, boolean reveal) {
        if (!selection.isEmpty()) {
            this.viewer.setSelection(selection, reveal);
        }
    }

    protected void initializeListeners(final StructuredViewer viewer) {
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StructuredViewerAdvisor.this.dispose();
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StructuredViewerAdvisor.this.handleOpen();
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredViewerAdvisor.this.handleDoubleClick(viewer, event);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredViewerAdvisor.this.updateActionBars((IStructuredSelection)viewer.getSelection());
            }
        });
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.propertyListener);
    }

    protected boolean handleDoubleClick(StructuredViewer viewer, DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        DiffNode node = (DiffNode)selection.getFirstElement();
        if (node != null && node instanceof SyncInfoModelElement) {
            SyncInfoModelElement syncNode = (SyncInfoModelElement)node;
            IResource resource = syncNode.getResource();
            if (syncNode != null && resource != null && resource.getType() == 1) {
                this.handleOpen();
                return true;
            }
        }
        return false;
    }

    private void handleOpen() {
        Object o = this.getConfiguration().getProperty("org.eclipse.team.ui.P_OPEN_ACTION");
        if (o instanceof IAction) {
            IAction action = (IAction)o;
            action.run();
        }
    }

    protected abstract boolean validateViewer(StructuredViewer var1);

    protected IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider();
    }

    protected ILabelProvider getLabelProvider() {
        SynchronizeModelElementLabelProvider provider = new SynchronizeModelElementLabelProvider();
        ILabelDecorator[] decorators = (ILabelDecorator[])this.getConfiguration().getProperty("org.eclipse.team.ui.P_LABEL_DECORATORS");
        if (decorators == null) {
            return provider;
        }
        return new DecoratingColorLabelProvider((ILabelProvider)provider, decorators);
    }

    public final StructuredViewer getViewer() {
        return this.viewer;
    }

    public final void setInput(ISynchronizeModelProvider modelProvider) {
        final ISynchronizeModelElement modelRoot = modelProvider.getModelRoot();
        this.getActionGroup().modelChanged(modelRoot);
        modelRoot.addCompareInputChangeListener(new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                StructuredViewerAdvisor.this.getActionGroup().modelChanged(modelRoot);
            }
        });
        if (this.viewer != null) {
            modelProvider.setViewer(this.viewer);
            this.viewer.setSorter(modelProvider.getViewerSorter());
            this.viewer.setInput((Object)modelRoot);
        }
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public final void setActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            IStatusLineManager statusLineMgr;
            IToolBarManager manager = actionBars.getToolBarManager();
            Object o = this.configuration.getProperty("org.eclipse.team.ui.P_TOOLBAR_MENU");
            if (!(o instanceof String[])) {
                o = ISynchronizePageConfiguration.DEFAULT_TOOLBAR_MENU;
            }
            String[] groups = o;
            int i = 0;
            while (i < groups.length) {
                String group = groups[i];
                manager.add((IContributionItem)new Separator(this.getGroupId(group)));
                ++i;
            }
            IMenuManager menu = actionBars.getMenuManager();
            if (menu != null) {
                o = this.configuration.getProperty("org.eclipse.team.ui.P_VIEW_MENU");
                if (!(o instanceof String[])) {
                    o = ISynchronizePageConfiguration.DEFAULT_VIEW_MENU;
                }
                groups = o;
                this.initializeStatusLine();
                int i2 = 0;
                while (i2 < groups.length) {
                    String group = groups[i2];
                    menu.add((IContributionItem)new Separator(this.getGroupId(group)));
                    ++i2;
                }
            }
            if ((statusLineMgr = actionBars.getStatusLineManager()) != null && this.statusLine != null) {
                this.statusLine.fillActionBars(actionBars);
            }
            this.getActionGroup().fillActionBars(actionBars);
            this.updateActionBars((IStructuredSelection)this.getViewer().getSelection());
            Object input = this.viewer.getInput();
            if (input instanceof ISynchronizeModelElement) {
                this.getActionGroup().modelChanged((ISynchronizeModelElement)input);
            }
        }
    }

    private void hookContextMenu(final StructuredViewer viewer) {
        final MenuManager menuMgr = new MenuManager(null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuredViewerAdvisor.this.fillContextMenu(viewer, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                IContributionItem[] items = menuMgr.getItems();
                int i = 0;
                while (i < items.length) {
                    IAction actionItem;
                    IContributionItem item = items[i];
                    if (item instanceof ActionContributionItem && (actionItem = ((ActionContributionItem)item).getAction()) instanceof SynchronizeModelAction) {
                        ((SynchronizeModelAction)actionItem).selectionChanged(viewer.getSelection());
                    }
                    ++i;
                }
            }
        });
        viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(StructuredViewer viewer, IMenuManager manager) {
        String[] o = this.configuration.getProperty("org.eclipse.team.ui.P_CONTEXT_MENU");
        if (!(o instanceof String[])) {
            o = ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU;
        }
        String[] groups = o;
        int i = 0;
        while (i < groups.length) {
            String group = groups[i];
            manager.add((IContributionItem)new Separator(group));
            ++i;
        }
        this.getActionGroup().setContext(new ActionContext(viewer.getSelection()));
        this.getActionGroup().fillContextMenu(manager);
    }

    private void updateActionBars(IStructuredSelection selection) {
        SynchronizePageActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    private SynchronizePageActionGroup getActionGroup() {
        return (SynchronizePageActionGroup)((Object)this.configuration);
    }

    private String getGroupId(String group) {
        return ((SynchronizePageConfiguration)this.configuration).getGroupId(group);
    }

    public SynchronizeModelManager getModelManager() {
        return this.modelManager;
    }
}

