/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.StructuredViewerAdvisor;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;

public abstract class SynchronizeModelManager
extends SynchronizePageActionGroup {
    private static final String P_LAST_PROVIDER = "org.eclipse.team.ui.P_LAST_MODELPROVIDER";
    private ISynchronizeModelProvider modelProvider;
    private List toggleModelProviderActions;
    private ISynchronizePageConfiguration configuration;
    private StructuredViewerAdvisor advisor;

    public SynchronizeModelManager(ISynchronizePageConfiguration configuration) {
        Assert.isNotNull((Object)configuration, (String)"configuration cannot be null");
        this.configuration = configuration;
        configuration.addActionContribution(this);
    }

    public void setViewerAdvisor(StructuredViewerAdvisor advisor) {
        this.advisor = advisor;
    }

    protected abstract ISynchronizeModelProviderDescriptor[] getSupportedModelProviders();

    protected abstract ISynchronizeModelProvider createModelProvider(String var1);

    protected ISynchronizeModelProvider getActiveModelProvider() {
        return this.modelProvider;
    }

    protected Object internalPrepareInput(String id, IProgressMonitor monitor) {
        if (this.modelProvider != null) {
            this.modelProvider.dispose();
        }
        this.modelProvider = this.createModelProvider(id);
        IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(P_LAST_PROVIDER, this.modelProvider.getDescriptor().getId());
        }
        return this.modelProvider.prepareInput(monitor);
    }

    public ISelection getSelection(Object[] objects) {
        if (this.modelProvider != null) {
            Object[] viewerObjects = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                viewerObjects[i] = this.modelProvider.getMapping(objects[i]);
                ++i;
            }
            return new StructuredSelection(viewerObjects);
        }
        return StructuredSelection.EMPTY;
    }

    protected void setSelection(Object[] objects, boolean reveal) {
        ISelection selection = this.getSelection(objects);
        if (!selection.isEmpty()) {
            this.advisor.setSelection(selection, reveal);
        }
    }

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ISynchronizeModelProviderDescriptor[] providers = this.getSupportedModelProviders();
        if (providers.length > 1) {
            this.toggleModelProviderActions = new ArrayList();
            int i = 0;
            while (i < providers.length) {
                ISynchronizeModelProviderDescriptor provider = providers[i];
                this.toggleModelProviderActions.add(new ToggleModelProviderAction(provider));
                ++i;
            }
        }
        if (this.modelProvider == null) {
            String defaultProviderId = null;
            IDialogSettings pageSettings = configuration.getSite().getPageSettings();
            if (pageSettings != null) {
                defaultProviderId = pageSettings.get(P_LAST_PROVIDER);
            }
            this.internalPrepareInput(defaultProviderId, null);
        }
        this.setInput();
    }

    protected void setInput() {
        this.configuration.setProperty("org.eclipse.team.ui.P_MODEL", this.modelProvider.getModelRoot());
        if (this.advisor != null) {
            this.advisor.setInput(this.modelProvider);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.toggleModelProviderActions == null) {
            return;
        }
        IToolBarManager toolbar = actionBars.getToolBarManager();
        IMenuManager menu = actionBars.getMenuManager();
        IContributionItem group = this.findGroup((IContributionManager)menu, "layout");
        if (menu != null && group != null) {
            MenuManager layout = new MenuManager(Policy.bind("action.layout.label"));
            menu.appendToGroup(group.getId(), (IContributionItem)layout);
            this.appendToMenu(null, (IContributionManager)layout);
        } else if (toolbar != null && (group = this.findGroup((IContributionManager)toolbar, "layout")) != null) {
            this.appendToMenu(group.getId(), (IContributionManager)toolbar);
        }
    }

    private void appendToMenu(String groupId, IContributionManager menu) {
        Iterator iter = this.toggleModelProviderActions.iterator();
        while (iter.hasNext()) {
            if (groupId == null) {
                menu.add((IAction)((Action)iter.next()));
                continue;
            }
            menu.appendToGroup(groupId, (IAction)((Action)iter.next()));
        }
    }

    public void dispose() {
        if (this.modelProvider != null) {
            this.modelProvider.dispose();
        }
        super.dispose();
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    private class ToggleModelProviderAction
    extends Action
    implements IPropertyChangeListener {
        private ISynchronizeModelProviderDescriptor descriptor;

        protected ToggleModelProviderAction(ISynchronizeModelProviderDescriptor descriptor) {
            super(descriptor.getName(), 8);
            this.setImageDescriptor(descriptor.getImageDescriptor());
            this.setToolTipText(descriptor.getName());
            this.descriptor = descriptor;
            this.update();
            SynchronizeModelManager.this.configuration.addPropertyChangeListener(this);
        }

        public void run() {
            ISynchronizeModelProvider mp = SynchronizeModelManager.this.getActiveModelProvider();
            if (!mp.getDescriptor().getId().equals(this.descriptor.getId())) {
                mp.saveState();
                SynchronizeModelManager.this.internalPrepareInput(this.descriptor.getId(), null);
                SynchronizeModelManager.this.setInput();
            }
        }

        public void update() {
            ISynchronizeModelProvider mp = SynchronizeModelManager.this.getActiveModelProvider();
            if (mp != null) {
                this.setChecked(mp.getDescriptor().getId().equals(this.descriptor.getId()));
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.team.ui.P_MODEL")) {
                this.update();
            }
        }
    }
}

