/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletLaunchConfigurationUtils;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class AppletSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaProject fProject;
    private static final IType[] EMPTY_TYPE_ARRAY = new IType[0];

    public AppletSelectionDialog(Shell shell, IRunnableContext context, IJavaProject project) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        Assert.isNotNull((Object)context);
        this.fRunnableContext = context;
        this.fProject = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public int open() {
        Object[] types = this.getAppletTypes();
        if (types == null) {
            return 1;
        }
        this.setElements(types);
        return super.open();
    }

    private IType[] getAppletTypes() {
        IJavaProject[] javaProjects;
        if (this.fProject == null) {
            try {
                javaProjects = this.getJavaModel().getJavaProjects();
            }
            catch (JavaModelException javaModelException) {
                return EMPTY_TYPE_ARRAY;
            }
        } else {
            javaProjects = new IJavaProject[]{this.fProject};
        }
        final int projectCount = javaProjects.length;
        final HashSet results = new HashSet(projectCount);
        boolean canceled = false;
        try {
            this.fRunnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(LauncherMessages.getString("AppletSelectionDialog.Searching..._1"), projectCount);
                    int i = 0;
                    while (i < projectCount) {
                        IJavaProject javaProject = javaProjects[i];
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                        results.addAll(AppletLaunchConfigurationUtils.collectAppletTypesInProject((IProgressMonitor)subMonitor, javaProject));
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            canceled = true;
        }
        if (canceled) {
            return null;
        }
        IType[] types = null;
        types = results.toArray(new IType[results.size()]);
        return types;
    }

    public Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage((Object)((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText((Object)((IType)element).getPackageFragment());
        }
    }
}

