/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.monitors.DeadLocksViewContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorManager;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorMessages;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorModelPresentation;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorsDebugEventHandler;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorsViewContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadsViewContentProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class MonitorsView
extends AbstractDebugEventHandlerView
implements ISelectionListener {
    public static final int VIEW_ID_THREAD = 1;
    public static final int VIEW_ID_MONITOR = 2;
    public static final int VIEW_ID_DEADLOCK = 3;
    private int fViewId = 2;
    private Viewer fDeadLocksViewer;
    private Viewer fMonitorsViewer;
    private boolean fMonitorInformationAvailable = true;
    private boolean fValidSelection = false;
    private IJavaDebugTarget fLastSelectedTarget;
    static /* synthetic */ Class class$0;

    public MonitorsView() {
        this.setEventHandler(new MonitorsDebugEventHandler(this));
    }

    public void setViewId(int viewerIndex) {
        this.fViewId = viewerIndex;
        this.refreshCurrentViewer(this.fMonitorInformationAvailable, true);
    }

    public int getViewId() {
        return this.fViewId;
    }

    protected Viewer createViewer(Composite parent) {
        TreeViewer threadViewer = new TreeViewer(parent, 2);
        threadViewer.setContentProvider((IContentProvider)new ThreadsViewContentProvider());
        threadViewer.setLabelProvider((IBaseLabelProvider)new MonitorModelPresentation());
        threadViewer.setInput((Object)MonitorManager.getDefault());
        return threadViewer;
    }

    protected Viewer createMonitorsViewer(Composite parent) {
        TreeViewer monitorsViewer = new TreeViewer(parent, 2);
        monitorsViewer.setContentProvider((IContentProvider)new MonitorsViewContentProvider());
        monitorsViewer.setLabelProvider((IBaseLabelProvider)new MonitorModelPresentation());
        monitorsViewer.setInput((Object)MonitorManager.getDefault());
        return monitorsViewer;
    }

    protected Viewer createDeadLocksViewer(Composite parent) {
        TreeViewer deadLocksViewer = new TreeViewer(parent, 2){

            public void refresh() {
                this.getControl().setRedraw(false);
                super.refresh();
                Item[] children = this.getChildren((Widget)this.getControl());
                if (children != null) {
                    Color c = DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.changedVariableColor");
                    int i = 0;
                    while (i < children.length) {
                        this.updateColor((TreeItem)children[i], c, 0);
                        ++i;
                    }
                }
                this.getControl().setRedraw(true);
            }

            public void updateColor(TreeItem item, Color c, int count) {
                Object data = item.getData();
                if (data instanceof DeadLocksViewContentProvider.ContentThreadWrapper && ((DeadLocksViewContentProvider.ContentThreadWrapper)data).caughtInADeadLock) {
                    item.setForeground(c);
                }
                TreeItem[] children = item.getItems();
                int i = 0;
                while (i < children.length) {
                    this.updateColor(children[i], c, count + 1);
                    ++i;
                }
            }
        };
        deadLocksViewer.setContentProvider((IContentProvider)new DeadLocksViewContentProvider());
        deadLocksViewer.setLabelProvider((IBaseLabelProvider)new MonitorModelPresentation());
        deadLocksViewer.setInput((Object)MonitorManager.getDefault());
        return deadLocksViewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        DeadLocksViewerPage deadLocksPage = new DeadLocksViewerPage();
        deadLocksPage.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)deadLocksPage);
        MonitorsViewerPage monitorsViewerPage = new MonitorsViewerPage();
        monitorsViewerPage.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)monitorsViewerPage);
        this.createContextMenu(this.getDeadLocksViewer().getControl());
        this.createContextMenu(this.getMonitorsViewer().getControl());
        this.setViewId(2);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return IJavaDebugHelpContextIds.MONITORS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("vmGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("vmGroup"));
        this.updateObjects();
    }

    public Viewer getDeadLocksViewer() {
        return this.fDeadLocksViewer;
    }

    public Viewer getMonitorsViewer() {
        return this.fMonitorsViewer;
    }

    public void setDeadLocksViewer(Viewer deadLocksViewer) {
        this.fDeadLocksViewer = deadLocksViewer;
    }

    public void setMonitorsViewer(Viewer monitorsViewer) {
        this.fMonitorsViewer = monitorsViewer;
    }

    protected void refreshCurrentViewer(boolean monitorInformationAvailable, boolean showPage) {
        if (this.getPageBook().isDisposed()) {
            return;
        }
        if (!this.fValidSelection) {
            this.showMessage(MonitorMessages.getString("MonitorsView.2"));
            this.updateObjects();
            return;
        }
        boolean changeFromShowMessagePage = monitorInformationAvailable && !this.fMonitorInformationAvailable;
        this.fMonitorInformationAvailable = monitorInformationAvailable;
        if (!monitorInformationAvailable) {
            this.showMessage(MonitorMessages.getString("MonitorsView.1"));
            this.updateObjects();
            return;
        }
        Control page = null;
        switch (this.fViewId) {
            case 1: {
                page = this.getViewer().getControl();
                page.setRedraw(false);
                this.getViewer().refresh();
                ((TreeViewer)this.getViewer()).expandAll();
                page.setRedraw(true);
                break;
            }
            case 3: {
                if (MonitorManager.getDefault().getNumberOfDeadlocks() == 0 && MonitorManager.getDefault().getThreads().length > 0) {
                    this.showMessage(MonitorMessages.getString("MonitorsView.3"));
                    showPage = false;
                    break;
                }
                changeFromShowMessagePage = true;
                page = this.getDeadLocksViewer().getControl();
                page.setRedraw(false);
                this.getDeadLocksViewer().refresh();
                ((TreeViewer)this.getDeadLocksViewer()).expandAll();
                page.setRedraw(true);
                break;
            }
            case 2: {
                page = this.getMonitorsViewer().getControl();
                page.setRedraw(false);
                this.getMonitorsViewer().refresh();
                ((TreeViewer)this.getMonitorsViewer()).expandAll();
                page.setRedraw(true);
            }
        }
        if (showPage | changeFromShowMessagePage && page != null) {
            this.getPageBook().showPage(page);
        }
        this.updateObjects();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            HashSet<IDebugTarget> targets = new HashSet<IDebugTarget>();
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof JDIDebugElement)) continue;
                targets.add(((JDIDebugElement)element).getDebugTarget());
            }
            if (targets.size() == 1) {
                final IJavaDebugTarget debugTarget = (IJavaDebugTarget)targets.toArray()[0];
                if (debugTarget != this.fLastSelectedTarget || !this.fValidSelection) {
                    Job job = new Job(MonitorMessages.getString("MonitorsView.4")){

                        protected IStatus run(IProgressMonitor monitor) {
                            boolean monitorInformationAvailable = debugTarget.supportsMonitorInformation();
                            if (monitorInformationAvailable) {
                                MonitorManager.getDefault().updatePartial(debugTarget);
                            }
                            MonitorsView.this.fValidSelection = true;
                            Display.getDefault().asyncExec(new Runnable(this, monitorInformationAvailable, debugTarget){
                                final /* synthetic */ 2 this$1;
                                private final /* synthetic */ boolean val$monitorInformationAvailable;
                                private final /* synthetic */ IJavaDebugTarget val$debugTarget;
                                {
                                    this.this$1 = var1_1;
                                    this.val$monitorInformationAvailable = bl;
                                    this.val$debugTarget = iJavaDebugTarget;
                                }

                                public void run() {
                                    2.access$0(this.this$1).refreshCurrentViewer(this.val$monitorInformationAvailable, true);
                                    MonitorsView.access$1(2.access$0(this.this$1), this.val$debugTarget);
                                }
                            });
                            return Status.OK_STATUS;
                        }

                        static /* synthetic */ MonitorsView access$0(2 var0) {
                            return var0.MonitorsView.this;
                        }
                    };
                    IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                    job.setSystem(true);
                    if (progressService == null) {
                        job.schedule();
                    } else {
                        progressService.schedule(job);
                    }
                }
                return;
            }
        }
        if (this.fValidSelection) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MonitorsView.this.fValidSelection = false;
                    MonitorsView.this.refreshCurrentViewer(false, true);
                }
            });
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        super.dispose();
    }

    static /* synthetic */ void access$1(MonitorsView monitorsView, IJavaDebugTarget iJavaDebugTarget) {
        monitorsView.fLastSelectedTarget = iJavaDebugTarget;
    }

    class MonitorsViewerPage
    extends Page {
        MonitorsViewerPage() {
        }

        public void createControl(Composite parent) {
            Viewer viewer = MonitorsView.this.createMonitorsViewer(parent);
            MonitorsView.this.setMonitorsViewer(viewer);
        }

        public Control getControl() {
            return MonitorsView.this.getMonitorsViewer().getControl();
        }

        public void setFocus() {
            Control c;
            Viewer viewer = MonitorsView.this.getMonitorsViewer();
            if (viewer != null && !(c = viewer.getControl()).isFocusControl()) {
                c.setFocus();
            }
        }
    }

    class DeadLocksViewerPage
    extends Page {
        DeadLocksViewerPage() {
        }

        public void createControl(Composite parent) {
            Viewer viewer = MonitorsView.this.createDeadLocksViewer(parent);
            MonitorsView.this.setDeadLocksViewer(viewer);
        }

        public Control getControl() {
            return MonitorsView.this.getDeadLocksViewer().getControl();
        }

        public void setFocus() {
            Control c;
            Viewer viewer = MonitorsView.this.getDeadLocksViewer();
            if (viewer != null && !(c = viewer.getControl()).isFocusControl()) {
                c.setFocus();
            }
        }
    }
}

