/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FolderLayout;
import org.eclipse.ui.internal.LayoutHelper;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PlaceholderFolderLayout;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayout;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.IViewDescriptor;

public class PageLayout
implements IPageLayout {
    private ArrayList actionSets = new ArrayList(3);
    private IPerspectiveDescriptor descriptor;
    private LayoutPart editorFolder;
    private boolean editorVisible = true;
    private boolean fixed;
    private ArrayList fastViews = new ArrayList(3);
    private Map mapIDtoFolder = new HashMap(10);
    private Map mapIDtoPart = new HashMap(10);
    private Map mapIDtoViewLayoutRec = new HashMap(10);
    private ArrayList newWizardActionIds = new ArrayList(3);
    private ArrayList perspectiveActionIds = new ArrayList(3);
    private ViewSashContainer rootLayoutContainer;
    private ArrayList showInPartIds = new ArrayList(3);
    private ArrayList showViewActionIds = new ArrayList(3);
    private ViewFactory viewFactory;

    public PageLayout() {
    }

    public PageLayout(ViewSashContainer container, ViewFactory viewFactory, LayoutPart editorFolder, IPerspectiveDescriptor descriptor) {
        this.viewFactory = viewFactory;
        this.rootLayoutContainer = container;
        this.editorFolder = editorFolder;
        this.descriptor = descriptor;
        this.prefill();
    }

    private void addEditorArea() {
        try {
            LayoutPart newPart = this.createView("org.eclipse.ui.editorss");
            if (newPart == null) {
                return;
            }
            this.setRefPart("org.eclipse.ui.editorss", newPart);
            this.rootLayoutContainer.add(newPart);
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(e.getMessage());
        }
    }

    public void addActionSet(String actionSetID) {
        if (!this.actionSets.contains(actionSetID)) {
            this.actionSets.add(actionSetID);
        }
    }

    public void addFastView(String id) {
        this.addFastView(id, -1.0f);
    }

    public void addFastView(String id, float ratio) {
        if (this.checkPartInLayout(id)) {
            return;
        }
        if (id != null) {
            try {
                IViewReference ref = this.viewFactory.createView(id);
                this.fastViews.add(ref);
                ViewLayoutRec rec = this.getViewLayoutRec(id, true);
                if (ratio >= 0.05f && ratio <= 0.95f) {
                    rec.fastViewWidthRatio = ratio;
                }
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log(e.getMessage());
            }
        }
    }

    private boolean isFastViewId(String partId) {
        int i = 0;
        while (i < this.fastViews.size()) {
            if (((IViewReference)this.fastViews.get(i)).getId().equals(partId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    ViewLayoutRec getViewLayoutRec(String id, boolean create) {
        Assert.isTrue((this.getRefPart(id) != null || this.isFastViewId(id) ? 1 : 0) != 0);
        ViewLayoutRec rec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(id);
        if (rec == null && create) {
            rec = new ViewLayoutRec();
            if (this.isFixed()) {
                rec.isCloseable = false;
                rec.isMoveable = false;
            }
            this.mapIDtoViewLayoutRec.put(id, rec);
        }
        return rec;
    }

    public void addNewWizardShortcut(String id) {
        if (!this.newWizardActionIds.contains(id)) {
            this.newWizardActionIds.add(id);
        }
    }

    private void addPart(LayoutPart newPart, String partId, int relationship, float ratio, String refId) {
        this.setRefPart(partId, newPart);
        LayoutPart refPart = this.getFolderPart(refId);
        if (refPart == null) {
            refPart = this.getRefPart(refId);
        }
        if (refPart != null) {
            ratio = this.normalizeRatio(ratio);
            this.rootLayoutContainer.add(newPart, this.getPartSashConst(relationship), ratio, refPart);
        } else {
            WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.missingRefPart", new Object[]{refId}));
            this.rootLayoutContainer.add(newPart);
        }
    }

    public void addPerspectiveShortcut(String id) {
        if (!this.perspectiveActionIds.contains(id)) {
            this.perspectiveActionIds.add(id);
        }
    }

    public void addPlaceholder(String viewId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        this.addPart(newPart, viewId, relationship, ratio, refId);
        this.getViewLayoutRec(viewId, true);
    }

    public void addShowInPart(String id) {
        if (!this.showInPartIds.contains(id)) {
            this.showInPartIds.add(id);
        }
    }

    public void addShowViewShortcut(String id) {
        if (!this.showViewActionIds.contains(id)) {
            this.showViewActionIds.add(id);
        }
    }

    public void addView(String viewId, int relationship, float ratio, String refId) {
        this.addView(viewId, relationship, ratio, refId, false, true);
    }

    private void addView(String viewId, int relationship, float ratio, String refId, boolean standalone, boolean showTitle) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        try {
            LayoutPart newPart = this.createView(viewId);
            if (newPart == null) {
                this.addPlaceholder(viewId, relationship, ratio, refId);
                LayoutHelper.addViewActivator(this, viewId);
            } else {
                int appearance = 2;
                if (standalone) {
                    appearance = showTitle ? 3 : 4;
                }
                ViewStack newFolder = new ViewStack(this.rootLayoutContainer.page, true, appearance);
                newFolder.add(newPart);
                this.setFolderPart(viewId, newFolder);
                this.addPart(newFolder, viewId, relationship, ratio, refId);
                this.getViewLayoutRec(viewId, true);
            }
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(e.getMessage());
        }
    }

    boolean checkPartInLayout(String partId) {
        if (this.getRefPart(partId) != null) {
            WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.duplicateRefPart", new Object[]{partId}));
            return true;
        }
        return this.isFastViewId(partId);
    }

    public IFolderLayout createFolder(String folderId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(folderId)) {
            return new FolderLayout(this, (ViewStack)this.getRefPart(folderId), this.viewFactory);
        }
        ViewStack folder = new ViewStack(this.rootLayoutContainer.page);
        folder.setID(folderId);
        this.addPart(folder, folderId, relationship, ratio, refId);
        return new FolderLayout(this, folder, this.viewFactory);
    }

    public IPlaceholderFolderLayout createPlaceholderFolder(String folderId, int relationship, float ratio, String refId) {
        if (this.checkPartInLayout(folderId)) {
            return new PlaceholderFolderLayout(this, (ContainerPlaceholder)this.getRefPart(folderId));
        }
        ContainerPlaceholder folder = new ContainerPlaceholder(null);
        folder.setContainer(this.rootLayoutContainer);
        folder.setRealContainer(new ViewStack(this.rootLayoutContainer.page));
        folder.setID(folderId);
        this.addPart(folder, folderId, relationship, ratio, refId);
        return new PlaceholderFolderLayout(this, folder);
    }

    private LayoutPart createView(String partID) throws PartInitException {
        if (partID.equals("org.eclipse.ui.editorss")) {
            return this.editorFolder;
        }
        IViewDescriptor viewDescriptor = this.viewFactory.getViewRegistry().find(partID);
        if (WorkbenchActivityHelper.filterItem(viewDescriptor)) {
            return null;
        }
        return LayoutHelper.createView(this.getViewFactory(), partID);
    }

    public ArrayList getActionSets() {
        return this.actionSets;
    }

    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    public int getEditorReuseThreshold() {
        return -1;
    }

    public ArrayList getFastViews() {
        return this.fastViews;
    }

    private ViewStack getFolderPart(String viewId) {
        return (ViewStack)this.mapIDtoFolder.get(viewId);
    }

    public ArrayList getNewWizardActionIds() {
        return this.newWizardActionIds;
    }

    private int getPartSashConst(int nRelationship) {
        return nRelationship;
    }

    public ArrayList getPerspectiveActionIds() {
        return this.perspectiveActionIds;
    }

    LayoutPart getRefPart(String partID) {
        return (LayoutPart)this.mapIDtoPart.get(partID);
    }

    public ViewSashContainer getRootLayoutContainer() {
        return this.rootLayoutContainer;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public ArrayList getShowViewActionIds() {
        return this.showViewActionIds;
    }

    ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public boolean isEditorAreaVisible() {
        return this.editorVisible;
    }

    private float normalizeRatio(float in) {
        if (in < 0.05f) {
            in = 0.05f;
        }
        if (in > 0.95f) {
            in = 0.95f;
        }
        return in;
    }

    private void prefill() {
        this.addEditorArea();
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] array = reg.getActionSets();
        int count = array.length;
        int nX = 0;
        while (nX < count) {
            IActionSetDescriptor desc = array[nX];
            if (desc.isInitiallyVisible()) {
                this.addActionSet(desc.getId());
            }
            ++nX;
        }
    }

    public void setEditorAreaVisible(boolean showEditorArea) {
        this.editorVisible = showEditorArea;
    }

    public void setEditorReuseThreshold(int openEditors) {
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    void setFolderPart(String viewId, ContainerPlaceholder container) {
        LayoutPart tabFolder = container.getRealContainer();
        this.mapIDtoFolder.put(viewId, tabFolder);
    }

    void setFolderPart(String viewId, ViewStack folder) {
        this.mapIDtoFolder.put(viewId, folder);
    }

    void setRefPart(String partID, LayoutPart part) {
        this.mapIDtoPart.put(partID, part);
    }

    private void stackPart(LayoutPart newPart, String viewId, String refId) {
        this.setRefPart(viewId, newPart);
        this.getViewLayoutRec(viewId, true);
        ViewStack folder = this.getFolderPart(refId);
        if (folder != null) {
            folder.add(newPart);
            this.setFolderPart(viewId, folder);
            return;
        }
        LayoutPart refPart = this.getRefPart(refId);
        if (refPart != null) {
            ViewStack newFolder = new ViewStack(this.rootLayoutContainer.page);
            this.rootLayoutContainer.replace(refPart, newFolder);
            newFolder.add(refPart);
            newFolder.add(newPart);
            this.setFolderPart(refId, newFolder);
            this.setFolderPart(viewId, newFolder);
            return;
        }
        WorkbenchPlugin.log(WorkbenchMessages.format("PageLayout.missingRefPart", new Object[]{refId}));
        this.rootLayoutContainer.add(newPart);
    }

    public void stackPlaceholder(String viewId, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        LayoutPart refPart = this.getRefPart(refId);
        if (refPart != null) {
            newPart.setContainer(refPart.getContainer());
        }
        this.stackPart(newPart, viewId, refId);
    }

    public void stackView(String viewId, String refId) {
        if (this.checkPartInLayout(viewId)) {
            return;
        }
        try {
            LayoutPart newPart = this.createView(viewId);
            if (newPart == null) {
                this.stackPlaceholder(viewId, refId);
                LayoutHelper.addViewActivator(this, viewId);
            } else {
                this.stackPart(newPart, viewId, refId);
            }
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(e.getMessage());
        }
    }

    public static int swtConstantToLayoutPosition(int swtConstant) {
        switch (swtConstant) {
            case 128: {
                return 3;
            }
            case 1024: {
                return 4;
            }
            case 131072: {
                return 2;
            }
            case 16384: {
                return 1;
            }
        }
        return -1;
    }

    public void addStandaloneView(String viewId, boolean showTitle, int relationship, float ratio, String refId) {
        this.addView(viewId, relationship, ratio, refId, true, showTitle);
        ViewLayoutRec rec = this.getViewLayoutRec(viewId, true);
        rec.isStandalone = true;
        rec.showTitle = showTitle;
    }

    public IViewLayout getViewLayout(String viewId) {
        ViewLayoutRec rec = this.getViewLayoutRec(viewId, true);
        if (rec == null) {
            return null;
        }
        return new ViewLayout(this, rec);
    }

    public Map getIDtoViewLayoutRecMap() {
        return this.mapIDtoViewLayoutRec;
    }
}

