/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.help.WorkbenchHelp;

public class UserValidationDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected Button allowCachingButton;
    protected String domain;
    protected String defaultUsername;
    protected String password = null;
    protected boolean allowCaching = false;
    protected Image keyLockImage;
    protected boolean isUsernameMutable = true;
    protected boolean showAllowCachingButton = true;
    protected String username = null;
    protected String message = null;

    public UserValidationDialog(Shell parentShell, String location, String defaultName, String message) {
        super(parentShell);
        this.defaultUsername = defaultName;
        this.domain = location;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Policy.bind("UserValidationDialog.required"));
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.team.cvs.ui.user_validation_dialog_context");
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.defaultUsername);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = TeamImages.getImageDescriptor((String)"wizban/keylock.gif").createImage();
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.domain != null) {
            Label d = new Label(main, 64);
            d.setText(Policy.bind("UserValidationDialog.5"));
            data = new GridData();
            d.setLayoutData((Object)data);
            Label label = new Label(main, 64);
            if (this.isUsernameMutable) {
                label.setText(Policy.bind("UserValidationDialog.labelUser", this.domain));
            } else {
                label.setText(Policy.bind("UserValidationDialog.labelPassword", new Object[]{this.defaultUsername, this.domain}));
            }
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 300;
            label.setLayoutData((Object)data);
        }
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        if (this.domain != null && this.showAllowCachingButton) {
            this.allowCachingButton = new Button(main, 32);
            this.allowCachingButton.setText(Policy.bind("UserValidationDialog.6"));
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.allowCachingButton.setLayoutData((Object)data);
            this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserValidationDialog.this.allowCaching = UserValidationDialog.this.allowCachingButton.getSelection();
                }
            });
            Composite warningComposite = new Composite(main, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginHeight = 0;
            warningComposite.setLayout((Layout)layout);
            data = new GridData(768);
            data.horizontalSpan = 3;
            warningComposite.setLayoutData((Object)data);
            Label warningLabel = new Label(warningComposite, 0);
            warningLabel.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            warningLabel.setLayoutData((Object)new GridData(34));
            Label warningText = new Label(warningComposite, 64);
            warningText.setText(Policy.bind("UserValidationDialog.7"));
            data = new GridData(768);
            data.widthHint = 300;
            warningText.setLayoutData((Object)data);
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createSpacer(Composite top, int columnSpan, int vertSpan) {
        Label l = new Label(top, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = columnSpan;
        data.verticalSpan = vertSpan;
        l.setLayoutData((Object)data);
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(Policy.bind("UserValidationDialog.password"));
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Policy.bind("UserValidationDialog.user"));
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }

    public void setShowAllowCachingButton(boolean value) {
        this.showAllowCachingButton = value;
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }
}

