/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class EncodingFieldEditor
extends FieldEditor {
    private Composite container;
    private Button defaultEncodingButton;
    private String defaultEnc;
    private Button otherEncodingButton;
    private Combo encodingCombo;
    private boolean isValid = true;
    private String oldSelectedEncoding;

    public EncodingFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.getContainer().getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.container = this.createEncodingGroup(parent, numColumns);
    }

    protected void doLoad() {
        if (this.encodingCombo != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            if (value.equals(this.defaultEnc)) {
                this.doLoadDefault();
            } else {
                this.encodingCombo.setText(value);
                this.oldSelectedEncoding = value;
                this.updateEncodingState(false);
            }
        }
    }

    protected void doLoadDefault() {
        this.updateEncodingState(true);
    }

    protected void doStore() {
        String encoding = this.getSelectedEncoding();
        if (encoding.equals(this.defaultEnc)) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), encoding);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.updateValidState();
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        this.defaultEnc = store.getDefaultString(this.getPreferenceName());
        this.updateDefaultEncoding();
    }

    private void updateDefaultEncoding() {
        this.defaultEncodingButton.setText(IDEWorkbenchMessages.format((String)"WorkbenchPreference.defaultEncoding", (Object[])new String[]{this.defaultEnc}));
    }

    private Composite getContainer() {
        return this.container;
    }

    private Group createEncodingGroup(Composite parent, int numColumns) {
        String enc;
        boolean isDefault;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = numColumns;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(this.getLabelText());
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingFieldEditor.this.updateEncodingState(EncodingFieldEditor.this.defaultEncodingButton.getSelection());
                EncodingFieldEditor.this.updateValidState();
            }
        };
        if (this.defaultEnc == null) {
            this.defaultEnc = System.getProperty("file.encoding", "UTF-8");
        }
        this.defaultEncodingButton = new Button((Composite)group, 16);
        this.updateDefaultEncoding();
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)data);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultEncodingButton.setFont(font);
        this.otherEncodingButton = new Button((Composite)group, 16);
        this.otherEncodingButton.setText(IDEWorkbenchMessages.getString((String)"WorkbenchPreference.otherEncoding"));
        this.otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherEncodingButton.setFont(font);
        this.encodingCombo = new Combo((Composite)group, 0);
        this.encodingCombo.setFont(font);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels((Control)this.encodingCombo, 15);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EncodingFieldEditor.this.updateValidState();
            }
        });
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingFieldEditor.this.updateValidState();
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(IDEWorkbenchMessages.getString((String)"WorkbenchPreference.numDefaultEncodings"));
        }
        catch (NumberFormatException numberFormatException) {}
        int i = 0;
        while (i < n) {
            String enc2 = IDEWorkbenchMessages.getString((String)("WorkbenchPreference.defaultEncoding" + (i + 1)), null);
            if (enc2 != null) {
                encodings.add(enc2);
            }
            ++i;
        }
        if (!encodings.contains(this.defaultEnc)) {
            encodings.add(this.defaultEnc);
        }
        boolean bl = isDefault = (enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        int i2 = 0;
        while (i2 < encodings.size()) {
            this.encodingCombo.add((String)encodings.get(i2));
            ++i2;
        }
        this.encodingCombo.setText(isDefault ? this.defaultEnc : enc);
        this.updateEncodingState(isDefault);
        return group;
    }

    private int convertWidthInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int result = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
        gc.dispose();
        return result;
    }

    private void updateEncodingState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        this.encodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    private void updateValidState() {
        boolean isValidNow = this.isEncodingValid();
        if (isValidNow != this.isValid) {
            this.isValid = isValidNow;
            if (this.isValid) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage(IDEWorkbenchMessages.getString((String)"WorkbenchPreference.unsupportedEncoding"));
            }
            this.fireStateChanged("field_editor_is_valid", !this.isValid, this.isValid);
            String newValue = this.getSelectedEncoding();
            if (this.isValid && !newValue.equals(this.oldSelectedEncoding)) {
                this.fireValueChanged("field_editor_value", this.oldSelectedEncoding, newValue);
                this.oldSelectedEncoding = newValue;
            }
        }
    }

    private String getSelectedEncoding() {
        if (this.defaultEncodingButton.getSelection()) {
            return this.defaultEnc;
        }
        return this.encodingCombo.getText();
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }
}

