/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.OverrideAndUpdateOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OverrideAndUpdateSubscriberOperation
extends CVSSubscriberOperation {
    protected OverrideAndUpdateSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public boolean shouldRun() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return this.promptForOverwrite(syncSet);
    }

    protected void run(SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        try {
            SyncInfo[] conflicts = set.getNodes(this.getConflictingAdditionFilter());
            ArrayList<IResource> conflictingResources = new ArrayList<IResource>();
            int i = 0;
            while (i < conflicts.length) {
                SyncInfo info = conflicts[i];
                conflictingResources.add(info.getLocal());
                ++i;
            }
            new OverrideAndUpdateOperation(this.getPart(), set.getResources(), conflictingResources.toArray(new IResource[conflictingResources.size()]), null, false).run(monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Policy.cancelOperation();
        }
    }

    private FastSyncInfoFilter getConflictingAdditionFilter() {
        return new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12}), new FastSyncInfoFilter.SyncInfoChangeTypeFilter(new int[]{1})});
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return Policy.bind("UpdateAction.jobName", new Integer(syncSet.size()).toString());
    }
}

