/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RefreshDirtyStateOperation
extends CVSSubscriberOperation {
    protected RefreshDirtyStateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected void run(SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        final SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
        final SyncInfo[] infos = set.getSyncInfos();
        if (infos.length == 0) {
            return;
        }
        IProject project = infos[0].getLocal().getProject();
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        folder.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor.beginTask(null, infos.length * 100);
                int i = 0;
                while (i < infos.length) {
                    SyncInfo info = infos[i];
                    IResource resource = info.getLocal();
                    if (resource.getType() == 1 && comparator.compareContents((IFile)resource, info.getBase(), Policy.subMonitorFor(monitor, 100))) {
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                        cvsFile.checkedIn(null);
                    }
                    ++i;
                }
                monitor.done();
            }
        }, monitor);
    }

    protected String getErrorTitle() {
        return Policy.bind("RefreshDirtyStateOperation.0");
    }

    protected String getJobName() {
        return Policy.bind("RefreshDirtyStateOperation.1");
    }
}

