/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaDocPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormOutlinePage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContext;
import org.eclipse.pde.internal.ui.editor.schema.SchemaInputContextManager;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSourcePage;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SchemaEditor
extends MultiSourceEditor {
    private ShowDescriptionAction previewAction;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        FileEditorInput in = new FileEditorInput(file);
        manager.putContext((IEditorInput)in, new SchemaInputContext(this, (IEditorInput)in, true));
        manager.monitorFile(file);
    }

    protected InputContextManager createInputContextManager() {
        SchemaInputContextManager contextManager = new SchemaInputContextManager(this);
        return contextManager;
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < transfers.length) {
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    public void monitoredFileAdded(IFile file) {
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new SchemaInputContext(this, (IEditorInput)input, true));
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        super.contextMenuAboutToShow(manager);
    }

    void previewReferenceDocument() {
        ISchema schema = (ISchema)this.getAggregateModel();
        if (this.previewAction == null) {
            this.previewAction = new ShowDescriptionAction(schema);
        } else {
            this.previewAction.setSchema(schema);
        }
        this.previewAction.run();
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new SchemaFormPage(this));
            this.addPage((IFormPage)new SchemaDocPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("schema-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            if (primary.getId().equals("schema-context")) {
                firstPageId = "form";
            }
            if (firstPageId == null) {
                firstPageId = "form";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new SchemaSourcePage(editor, title, name);
    }

    protected IContentOutlinePage createContentOutline() {
        return new SchemaFormOutlinePage(this);
    }
}

