/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.feature.BaseFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class FeatureSpecPage
extends BaseFeatureSpecPage {
    public static final String PAGE_TITLE = "NewFeatureWizard.SpecPage.title";
    public static final String PAGE_DESC = "NewFeatureWizard.SpecPage.desc";

    protected FeatureSpecPage(WizardNewProjectCreationPage mainPage) {
        super(mainPage, false);
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
    }

    protected void initialize() {
        if (this.isInitialized) {
            return;
        }
        String projectName = this.mainPage.getProjectName();
        if (this.initialId == null) {
            this.featureIdText.setText(this.computeInitialId(projectName));
        }
        if (this.initialName == null) {
            this.featureNameText.setText(projectName);
        }
        this.featureVersionText.setText("1.0.0");
        super.initialize();
    }

    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.featureIdText.getText();
        try {
            PluginVersionIdentifier pvi = new PluginVersionIdentifier(this.featureVersionText.getText());
            data.version = pvi.toString();
        }
        catch (NumberFormatException numberFormatException) {
            data.version = this.featureVersionText.getText();
        }
        data.provider = this.featureProviderText.getText();
        data.name = this.featureNameText.getText();
        data.library = this.getInstallHandlerLibrary();
        data.hasCustomHandler = this.customChoice.getSelection();
        return data;
    }

    protected void verifyComplete() {
        String message = this.verifyIdRules();
        if (message != null) {
            this.setPageComplete(false);
            this.setErrorMessage(message);
            return;
        }
        message = this.verifyVersion();
        if (message != null) {
            this.setPageComplete(false);
            this.setErrorMessage(message);
            return;
        }
        if (this.customChoice.getSelection() && this.libraryText.getText().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(PDEPlugin.getResourceString("NewFeatureWizard.SpecPage.error.library"));
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
            this.isInitialized = true;
            this.featureIdText.setFocus();
        }
    }
}

