/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public abstract class JDIReferenceType
extends JDIType
implements IJavaReferenceType {
    private String[] fDeclaredFields = null;
    private String[] fAllFields = null;

    public JDIReferenceType(JDIDebugTarget target, Type type) {
        super(target, type);
    }

    public String[] getAvailableStrata() {
        List<String> strata = this.getReferenceType().availableStrata();
        return strata.toArray(new String[strata.size()]);
    }

    protected ReferenceType getReferenceType() {
        return (ReferenceType)this.getUnderlyingType();
    }

    public String getDefaultStratum() {
        return this.getReferenceType().defaultStratum();
    }

    public IJavaFieldVariable getField(String name) throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            Field field = type.fieldByName(name);
            if (field != null) {
                return new JDIFieldVariable(this.getDebugTarget(), field, type);
            }
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_field"), e.toString(), name), e);
        }
        return null;
    }

    public IJavaClassObject getClassObject() throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            return (IJavaClassObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classObject()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_class_object"), e.toString()), e);
            return null;
        }
    }

    public String[] getAllFieldNames() throws DebugException {
        if (this.fAllFields == null) {
            try {
                List<Field> fields = ((ReferenceType)this.getUnderlyingType()).allFields();
                this.fAllFields = new String[fields.size()];
                Iterator<Field> iterator = fields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Field field = iterator.next();
                    this.fAllFields[i] = field.name();
                    ++i;
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(JDIDebugModelMessages.getString("JDIReferenceType.2"), e);
            }
        }
        return this.fAllFields;
    }

    public String[] getDeclaredFieldNames() throws DebugException {
        if (this.fDeclaredFields == null) {
            try {
                List<Field> fields = ((ReferenceType)this.getUnderlyingType()).fields();
                this.fDeclaredFields = new String[fields.size()];
                Iterator<Field> iterator = fields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Field field = iterator.next();
                    this.fDeclaredFields[i] = field.name();
                    ++i;
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(JDIDebugModelMessages.getString("JDIReferenceType.3"), e);
            }
        }
        return this.fDeclaredFields;
    }

    public String[] getSourcePaths(String stratum) {
        try {
            List<String> sourcePaths = this.getReferenceType().sourcePaths(stratum);
            return sourcePaths.toArray(new String[sourcePaths.size()]);
        }
        catch (AbsentInformationException absentInformationException) {
            return new String[0];
        }
    }
}

