/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.eval.ast.engine.BinaryBasedSourceGenerator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.SourceBasedSourceGenerator;

public class EvaluationSourceGenerator {
    private String fCodeSnippet;
    private String[] fLocalVariableTypeNames;
    private String[] fLocalVariableNames;
    private String fSource;
    private String fCompilationUnitName;
    private int fSnippetStartPosition;
    private int fRunMethodStartPosition;
    private int fRunMethodLength;
    static /* synthetic */ Class class$0;

    public EvaluationSourceGenerator(String[] localVariableTypesNames, String[] localVariableNames, String codeSnippet) {
        this.fLocalVariableTypeNames = localVariableTypesNames;
        this.fLocalVariableNames = localVariableNames;
        this.fCodeSnippet = this.getCompleteSnippet(codeSnippet);
    }

    public EvaluationSourceGenerator(String codeSnippet) {
        this(new String[0], new String[0], codeSnippet);
    }

    protected String getCompleteSnippet(String codeSnippet) {
        if (this.isExpression(codeSnippet)) {
            codeSnippet = "return " + codeSnippet + ';';
        }
        return codeSnippet;
    }

    protected boolean isExpression(String codeSnippet) {
        boolean inString = false;
        byte[] chars = codeSnippet.getBytes();
        int i = 0;
        int numChars = chars.length;
        while (i < numChars) {
            switch (chars[i]) {
                case 92: {
                    if (!inString) break;
                    ++i;
                    break;
                }
                case 34: 
                case 39: {
                    inString = !inString;
                    break;
                }
                case 59: {
                    if (inString) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public String getCompilationUnitName() {
        return this.fCompilationUnitName;
    }

    public int getSnippetStart() {
        return this.fSnippetStartPosition;
    }

    public int getRunMethodStart() {
        return this.fRunMethodStartPosition;
    }

    public int getRunMethodLength() {
        return this.fRunMethodLength;
    }

    protected void setSnippetStart(int position) {
        this.fSnippetStartPosition = position;
    }

    protected void setRunMethodStart(int position) {
        this.fRunMethodStartPosition = position;
    }

    protected void setRunMethodLength(int length) {
        this.fRunMethodLength = length;
    }

    public String getSnippet() {
        return this.fCodeSnippet;
    }

    private void createEvaluationSourceFromSource(String source, int position, boolean isLineNumber, boolean createInAStaticMethod) throws DebugException {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(source.toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        SourceBasedSourceGenerator visitor = new SourceBasedSourceGenerator(unit, position, isLineNumber, createInAStaticMethod, this.fLocalVariableTypeNames, this.fLocalVariableNames, this.fCodeSnippet);
        unit.accept((ASTVisitor)visitor);
        if (visitor.hasError()) {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, visitor.getError(), null));
        }
        String sourceRes = visitor.getSource();
        if (sourceRes == null) {
            return;
        }
        this.setSource(sourceRes);
        this.setCompilationUnitName(visitor.getCompilationUnitName());
        this.setSnippetStart(visitor.getSnippetStart());
        this.setRunMethodStart(visitor.getRunMethodStart());
        this.setRunMethodLength(visitor.getRunMethodLength());
    }

    private void createEvaluationSourceFromJDIObject(BinaryBasedSourceGenerator objectToEvaluationSourceMapper) {
        this.setCompilationUnitName(objectToEvaluationSourceMapper.getCompilationUnitName());
        this.setSnippetStart(objectToEvaluationSourceMapper.getSnippetStart());
        this.setRunMethodStart(objectToEvaluationSourceMapper.getRunMethodStart());
        this.setRunMethodLength(this.fCodeSnippet.length() + objectToEvaluationSourceMapper.getRunMethodLength());
        this.setSource(objectToEvaluationSourceMapper.getSource().insert(objectToEvaluationSourceMapper.getCodeSnippetPosition(), this.fCodeSnippet).toString());
    }

    private BinaryBasedSourceGenerator getInstanceSourceMapper(JDIObjectValue objectValue, boolean isInStaticMethod) {
        BinaryBasedSourceGenerator objectToEvaluationSourceMapper = new BinaryBasedSourceGenerator(this.fLocalVariableTypeNames, this.fLocalVariableNames, isInStaticMethod);
        objectToEvaluationSourceMapper.buildSource(objectValue);
        return objectToEvaluationSourceMapper;
    }

    private BinaryBasedSourceGenerator getStaticSourceMapper(JDIClassType classType, boolean isInStaticMethod) {
        BinaryBasedSourceGenerator objectToEvaluationSourceMapper = new BinaryBasedSourceGenerator(this.fLocalVariableTypeNames, this.fLocalVariableNames, isInStaticMethod);
        objectToEvaluationSourceMapper.buildSource(classType);
        return objectToEvaluationSourceMapper;
    }

    public String getSource(IJavaStackFrame frame) throws DebugException {
        if (this.fSource == null) {
            try {
                String baseSource = this.getSourceFromFrame(frame);
                int lineNumber = frame.getLineNumber();
                if (baseSource != null && lineNumber != -1) {
                    this.createEvaluationSourceFromSource(baseSource, frame.getLineNumber(), true, frame.isStatic());
                }
                if (this.fSource == null) {
                    JDIObjectValue object = (JDIObjectValue)frame.getThis();
                    BinaryBasedSourceGenerator mapper = object != null ? this.getInstanceSourceMapper(object, ((JDIStackFrame)frame).getUnderlyingMethod().isStatic()) : this.getStaticSourceMapper((JDIClassType)frame.getDeclaringType(), ((JDIStackFrame)frame).getUnderlyingMethod().isStatic());
                    this.createEvaluationSourceFromJDIObject(mapper);
                }
            }
            catch (JavaModelException e) {
                throw new DebugException(e.getStatus());
            }
        }
        return this.fSource;
    }

    public String getSource(IJavaObject thisObject, IJavaProject javaProject) throws DebugException {
        if (this.fSource == null) {
            String baseSource = this.getTypeSourceFromProject(thisObject.getJavaType().getName(), javaProject);
            int lineNumber = this.getLineNumber((JDIObjectValue)thisObject);
            if (baseSource != null && lineNumber != -1) {
                this.createEvaluationSourceFromSource(baseSource, lineNumber, true, false);
            }
            if (this.fSource == null) {
                BinaryBasedSourceGenerator mapper = this.getInstanceSourceMapper((JDIObjectValue)thisObject, false);
                this.createEvaluationSourceFromJDIObject(mapper);
            }
        }
        return this.fSource;
    }

    private int getLineNumber(JDIObjectValue objectValue) {
        ReferenceType referenceType = objectValue.getUnderlyingObject().referenceType();
        String referenceTypeName = referenceType.name();
        Hashtable<Integer, EvaluationSourceGenerator> lineNumbers = new Hashtable<Integer, EvaluationSourceGenerator>();
        try {
            Iterator<Location> iterator = referenceType.allLineLocations().iterator();
            while (iterator.hasNext()) {
                lineNumbers.put(new Integer(iterator.next().lineNumber()), this);
            }
            iterator = referenceType.allLineLocations().iterator();
            while (iterator.hasNext()) {
                Location location = iterator.next();
                if (location.declaringType().name().equals(referenceTypeName)) continue;
                lineNumbers.remove(new Integer(iterator.next().lineNumber()));
            }
            if (lineNumbers.size() > 0) {
                return (Integer)lineNumbers.keys().nextElement();
            }
            return -1;
        }
        catch (AbsentInformationException absentInformationException) {
            return -1;
        }
    }

    protected String getSourceFromFrame(IJavaStackFrame frame) throws JavaModelException {
        ILaunch launch = frame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)frame);
        if (sourceElement == null) {
            return null;
        }
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sourceElement = iAdaptable.getAdapter((Class)clazz);
        }
        if (sourceElement instanceof IType) {
            return ((IType)sourceElement).getCompilationUnit().getSource();
        }
        if (sourceElement instanceof ICompilationUnit) {
            return ((ICompilationUnit)sourceElement).getSource();
        }
        if (sourceElement instanceof IClassFile) {
            return ((IClassFile)sourceElement).getSource();
        }
        return null;
    }

    protected void setCompilationUnitName(String name) {
        this.fCompilationUnitName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    private String getTypeSourceFromProject(String typeName, IJavaProject javaProject) throws DebugException {
        String path = typeName;
        int pos = path.indexOf(36);
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        ++pos;
        path = path.replace('.', '/');
        path = String.valueOf(path) + ".java";
        Path sourcePath = new Path(path);
        String source = null;
        try {
            IJavaElement result = javaProject.findElement((IPath)sourcePath);
            if (result != null) {
                if (result instanceof IClassFile) {
                    source = ((IClassFile)result).getSource();
                } else if (result instanceof ICompilationUnit) {
                    source = ((ICompilationUnit)result).getSource();
                }
            }
        }
        catch (JavaModelException e) {
            throw new DebugException(e.getStatus());
        }
        return source;
    }
}

