/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class AdminKSubstListener
extends CommandOutputListener {
    private Command.KSubstOption ksubstMode;

    public AdminKSubstListener(Command.KSubstOption ksubstMode) {
        this.ksubstMode = ksubstMode;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (line.startsWith("RCS file:")) {
            String rcsFile = line.substring(10).trim();
            if (!rcsFile.endsWith(",v")) {
                return new CVSStatus(4, Policy.bind("AdminKSubstListener.expectedRCSFile", rcsFile));
            }
            String remoteRootLocation = null;
            try {
                FolderSyncInfo info = commandRoot.getFolderSyncInfo();
                remoteRootLocation = info.getRemoteLocation();
            }
            catch (CVSException e) {
                return e.getStatus();
            }
            if (remoteRootLocation == null) {
                return new CVSStatus(4, Policy.bind("AdminKSubstListener.commandRootNotManaged"));
            }
            Path remoteRootPath = new Path(remoteRootLocation);
            Path rcsFilePath = new Path(rcsFile.substring(0, rcsFile.length() - 2));
            if (!remoteRootPath.isPrefixOf((IPath)rcsFilePath)) {
                return new CVSStatus(4, Policy.bind("AdminKSubstListener.expectedChildOfCommandRoot", rcsFilePath.toString(), remoteRootPath.toString()));
            }
            rcsFilePath = rcsFilePath.removeFirstSegments(remoteRootPath.segmentCount());
            try {
                ICVSFile file = commandRoot.getFile(rcsFilePath.toString());
                byte[] syncBytes = file.getSyncBytes();
                if (syncBytes != null) {
                    file.setSyncBytes(ResourceSyncInfo.setKeywordMode(syncBytes, this.ksubstMode), 0);
                }
            }
            catch (CVSException e) {
                return new CVSStatus(4, Policy.bind("AdminKSubstListener.couldNotSetResourceSyncInfo", rcsFilePath.toString(), e.toString()));
            }
        }
        return ICommandOutputListener.OK;
    }
}

