/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;

public class CVSResourceVariantTree
extends ResourceVariantTree {
    private CVSTag tag;
    private boolean cacheFileContentsHint;
    private CVSSyncTreeSubscriber subscriber;

    public CVSResourceVariantTree(ResourceVariantByteStore cache, CVSTag tag, boolean cacheFileContentsHint) {
        super(cache);
        this.tag = tag;
        this.cacheFileContentsHint = cacheFileContentsHint;
    }

    public ResourceVariantByteStore getByteStore() {
        return super.getByteStore();
    }

    protected byte[] getBytes(IResource local, IResourceVariant remote) throws TeamException {
        if (remote != null) {
            return super.getBytes(local, remote);
        }
        if (local.getType() == 2) {
            return this.getBaseBytes((IContainer)local, this.getTag(local));
        }
        return null;
    }

    protected IResourceVariant[] fetchMembers(IResourceVariant remote, IProgressMonitor progress) throws TeamException {
        ICVSRemoteResource[] children = remote != null ? ((RemoteResource)remote).members(progress) : new ICVSRemoteResource[]{};
        IResourceVariant[] result = new IResourceVariant[children.length];
        int i = 0;
        while (i < children.length) {
            result[i] = (IResourceVariant)children[i];
            ++i;
        }
        return result;
    }

    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return (IResourceVariant)CVSWorkspaceRoot.getRemoteTree(resource, this.getTag(resource), this.cacheFileContentsHint, monitor);
    }

    public IResource[] collectChanges(IResource local, IResourceVariant remote, int depth, IProgressMonitor monitor) throws TeamException {
        return super.collectChanges(local, remote, depth, monitor);
    }

    public IResource[] roots() {
        return this.subscriber.roots();
    }

    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        byte[] remoteBytes = this.getByteStore().getBytes(resource);
        if (remoteBytes == null) {
            return null;
        }
        if (resource.getType() == 1) {
            byte[] parentBytes = this.getParentBytes(resource);
            if (parentBytes == null) {
                IProject project = resource.getProject();
                if (project.exists() && RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) != null) {
                    CVSProviderPlugin.log((CoreException)((Object)new CVSException(Policy.bind("ResourceSynchronizer.missingParentBytesOnGet", this.getSyncName(this.getByteStore()).toString(), resource.getFullPath().toString()))));
                }
                return null;
            }
            return RemoteFile.fromBytes(resource, remoteBytes, parentBytes);
        }
        return RemoteFolder.fromBytes(resource, remoteBytes);
    }

    private String getSyncName(ResourceVariantByteStore cache) {
        if (cache instanceof PersistantResourceVariantByteStore) {
            return ((PersistantResourceVariantByteStore)cache).getSyncName().toString();
        }
        return cache.getClass().getName();
    }

    private byte[] getParentBytes(IResource resource) throws TeamException {
        IContainer parent = resource.getParent();
        byte[] bytes = this.getByteStore().getBytes((IResource)parent);
        if (bytes == null) {
            bytes = this.getBaseBytes(parent, this.getTag(resource));
        }
        return bytes;
    }

    private byte[] getBaseBytes(IContainer parent, CVSTag tag) throws CVSException {
        byte[] bytes;
        ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor(parent);
        FolderSyncInfo info = local.getFolderSyncInfo();
        if (info == null) {
            bytes = null;
        } else {
            FolderSyncInfo newInfo = new FolderSyncInfo(info.getRepository(), info.getRoot(), tag, false);
            bytes = newInfo.getBytes();
        }
        return bytes;
    }

    private boolean hasLocalSyncInfo(IContainer folder) {
        ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor(folder);
        try {
            return local.getFolderSyncInfo() != null;
        }
        catch (CVSException cVSException) {
            return true;
        }
    }

    public CVSTag getTag(IResource resource) {
        return this.tag;
    }

    public void dispose() {
        this.getByteStore().dispose();
    }

    protected boolean setVariant(IResource local, IResourceVariant remote) throws TeamException {
        if (local.getType() == 2 && remote != null && !this.hasLocalSyncInfo((IContainer)((IFolder)local)) && this.hasLocalSyncInfo(local.getParent())) {
            CVSEntryLineTag tag = CVSWorkspaceRoot.getCVSFolderFor(local.getParent()).getFolderSyncInfo().getTag();
            FolderSyncInfo info = FolderSyncInfo.getFolderSyncInfo(remote.asBytes());
            FolderSyncInfo newInfo = new FolderSyncInfo(info.getRepository(), info.getRoot(), tag, info.getIsStatic());
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IFolder)local));
            cvsFolder.setFolderSyncInfo(newInfo);
        }
        boolean changed = super.setVariant(local, remote);
        if (local.getType() == 1 && this.getByteStore().getBytes(local) != null && !this.parentHasSyncBytes(local)) {
            CVSProviderPlugin.log((CoreException)((Object)new TeamException(Policy.bind("ResourceSynchronizer.missingParentBytesOnSet", this.getSyncName(this.getByteStore()), local.getFullPath().toString()))));
        }
        return changed;
    }

    private boolean parentHasSyncBytes(IResource resource) throws TeamException {
        if (resource.getType() == 4) {
            return true;
        }
        return this.getParentBytes(resource) != null;
    }

    protected IResource[] collectedMembers(IResource local, IResource[] members) throws TeamException {
        IResource[] resources = this.getStoredMembers(local);
        ArrayList<IResource> children = new ArrayList<IResource>();
        ArrayList<IResource> changedResources = new ArrayList<IResource>();
        children.addAll(Arrays.asList(members));
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!children.contains(resource)) {
                this.flushVariants(resource, 2);
                changedResources.add(resource);
            }
            ++i;
        }
        return changedResources.toArray(new IResource[changedResources.size()]);
    }

    private IResource[] getStoredMembers(IResource local) throws TeamException {
        try {
            if (local.getType() != 1 && (local.exists() || local.isPhantom())) {
                IResource[] allChildren = ((IContainer)local).members(true);
                ArrayList<IResource> childrenWithSyncBytes = new ArrayList<IResource>();
                int i = 0;
                while (i < allChildren.length) {
                    IResource resource = allChildren[i];
                    if (this.getByteStore().getBytes(resource) != null) {
                        childrenWithSyncBytes.add(resource);
                    }
                    ++i;
                }
                return childrenWithSyncBytes.toArray(new IResource[childrenWithSyncBytes.size()]);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        return new IResource[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IResource[] refresh(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] changedResources = null;
        monitor.beginTask(null, 100);
        int count = 0;
        while (count < 10 && (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_AUTO_BUILD) || this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_MANUAL_BUILD))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++count;
            Policy.checkCanceled(monitor);
        }
        ISchedulingRule rule = this.getSchedulingRule(resource);
        try {
            Platform.getJobManager().beginRule(rule, Policy.subMonitorFor(monitor, 1));
            if (!resource.getProject().isAccessible()) {
                IResource[] iResourceArray = new IResource[]{};
                Object var7_8 = null;
                Platform.getJobManager().endRule(rule);
                monitor.done();
                return iResourceArray;
            }
            changedResources = super.refresh(resource, depth, Policy.subMonitorFor(monitor, 99));
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Platform.getJobManager().endRule(rule);
            monitor.done();
            throw throwable;
        }
        Platform.getJobManager().endRule(rule);
        monitor.done();
        if (changedResources == null) {
            return new IResource[0];
        }
        return changedResources;
    }

    protected ISchedulingRule getSchedulingRule(IResource resource) {
        return resource.getProject();
    }

    private boolean isJobInFamilyRunning(Object family) {
        Job[] jobs = Platform.getJobManager().find(family);
        if (jobs != null && jobs.length > 0) {
            int i = 0;
            while (i < jobs.length) {
                Job job = jobs[i];
                if (job.getState() != 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

