/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.MemoryIndex;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.SimpleWordSet;
import org.eclipse.jdt.internal.core.util.Util;

public class DiskIndex {
    String fileName;
    private int headerInfoOffset;
    private int numberOfChunks;
    private int sizeOfLastChunk;
    private int[] chunkOffsets;
    private int documentReferenceSize;
    private HashtableOfIntValues categoryOffsets;
    private int cacheUserCount;
    private String[][] cachedChunks;
    private HashtableOfObject categoryTables;
    public static final String SIGNATURE = "INDEX VERSION 1.001";
    public static boolean DEBUG = false;
    private static final int RE_INDEXED = -1;
    private static final int DELETED = -2;
    private static final int CHUNK_SIZE = 100;

    DiskIndex(String fileName) {
        this.fileName = fileName;
        this.headerInfoOffset = -1;
        this.numberOfChunks = -1;
        this.sizeOfLastChunk = -1;
        this.chunkOffsets = null;
        this.documentReferenceSize = -1;
        this.cacheUserCount = -1;
        this.cachedChunks = null;
        this.categoryTables = null;
        this.categoryOffsets = null;
    }

    SimpleSet addDocumentNames(String substring, MemoryIndex memoryIndex) throws IOException {
        String[] docNames = this.readAllDocumentNames();
        SimpleSet results = new SimpleSet(docNames.length);
        if (substring == null) {
            if (memoryIndex == null) {
                int i = 0;
                int l = docNames.length;
                while (i < l) {
                    results.add(docNames[i]);
                    ++i;
                }
            } else {
                SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
                int i = 0;
                int l = docNames.length;
                while (i < l) {
                    String docName = docNames[i];
                    if (!docsToRefs.containsKey(docName)) {
                        results.add(docName);
                    }
                    ++i;
                }
            }
        } else if (memoryIndex == null) {
            int i = 0;
            int l = docNames.length;
            while (i < l) {
                if (docNames[i].startsWith(substring, 0)) {
                    results.add(docNames[i]);
                }
                ++i;
            }
        } else {
            SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
            int i = 0;
            int l = docNames.length;
            while (i < l) {
                String docName = docNames[i];
                if (docName.startsWith(substring, 0) && !docsToRefs.containsKey(docName)) {
                    results.add(docName);
                }
                ++i;
            }
        }
        return results;
    }

    private void addQueryResult(HashtableOfObject results, char[] word, HashtableOfObject wordsToDocNumbers, MemoryIndex memoryIndex) throws IOException {
        EntryResult result = (EntryResult)results.get(word);
        if (memoryIndex == null) {
            if (result == null) {
                results.put(word, new EntryResult(word, wordsToDocNumbers));
            } else {
                result.addDocumentTable(wordsToDocNumbers);
            }
        } else {
            SimpleLookupTable docsToRefs = memoryIndex.docsToReferences;
            if (result == null) {
                result = new EntryResult(word, null);
            }
            int[] docNumbers = this.readDocumentNumbers(wordsToDocNumbers.get(word));
            int i = 0;
            int l = docNumbers.length;
            while (i < l) {
                String docName = this.readDocumentName(docNumbers[i]);
                if (!docsToRefs.containsKey(docName)) {
                    result.addDocumentName(docName);
                }
                ++i;
            }
            if (!result.isEmpty()) {
                results.put(word, result);
            }
        }
    }

    HashtableOfObject addQueryResults(char[][] categories, char[] key, int matchRule, MemoryIndex memoryIndex) throws IOException {
        HashtableOfObject results = new HashtableOfObject(13);
        if (this.categoryOffsets == null) {
            return results;
        }
        if (matchRule == 8) {
            int i = 0;
            int l = categories.length;
            while (i < l) {
                HashtableOfObject wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                if (wordsToDocNumbers != null && wordsToDocNumbers.containsKey(key)) {
                    this.addQueryResult(results, key, wordsToDocNumbers, memoryIndex);
                }
                ++i;
            }
        } else {
            int i = 0;
            int l = categories.length;
            while (i < l) {
                HashtableOfObject wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                if (wordsToDocNumbers != null) {
                    char[][] words = wordsToDocNumbers.keyTable;
                    int j = 0;
                    int m = words.length;
                    while (j < m) {
                        char[] word = words[j];
                        if (word != null && Index.isMatch(key, word, matchRule)) {
                            this.addQueryResult(results, word, wordsToDocNumbers, memoryIndex);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return results;
    }

    private String[] computeDocumentNames(String[] onDiskNames, int[] positions, SimpleLookupTable indexedDocuments, MemoryIndex memoryIndex) {
        int count;
        int onDiskLength = onDiskNames.length;
        Object[] docNames = memoryIndex.docsToReferences.keyTable;
        Object[] referenceTables = memoryIndex.docsToReferences.valueTable;
        if (onDiskLength == 0) {
            int i = 0;
            int l = referenceTables.length;
            while (i < l) {
                if (referenceTables[i] != null) {
                    indexedDocuments.put(docNames[i], null);
                }
                ++i;
            }
            String[] newDocNames = new String[indexedDocuments.elementSize];
            int count2 = 0;
            Object[] added = indexedDocuments.keyTable;
            int i2 = 0;
            int l2 = added.length;
            while (i2 < l2) {
                if (added[i2] != null) {
                    newDocNames[count2++] = (String)added[i2];
                }
                ++i2;
            }
            Util.sort(newDocNames);
            i2 = 0;
            l2 = newDocNames.length;
            while (i2 < l2) {
                indexedDocuments.put(newDocNames[i2], new Integer(i2));
                ++i2;
            }
            return newDocNames;
        }
        int i = 0;
        while (i < onDiskLength) {
            positions[i] = i;
            ++i;
        }
        int numDeletedDocNames = 0;
        int numReindexedDocNames = 0;
        int i3 = 0;
        int l = docNames.length;
        while (i3 < l) {
            block26: {
                String docName = (String)docNames[i3];
                if (docName != null) {
                    int j = 0;
                    while (j < onDiskLength) {
                        if (docName.equals(onDiskNames[j])) {
                            if (referenceTables[i3] == null) {
                                positions[j] = -2;
                                ++numDeletedDocNames;
                            } else {
                                positions[j] = -1;
                                ++numReindexedDocNames;
                            }
                            break block26;
                        }
                        ++j;
                    }
                    if (referenceTables[i3] != null) {
                        indexedDocuments.put(docName, null);
                    }
                }
            }
            ++i3;
        }
        String[] newDocNames = onDiskNames;
        if (numDeletedDocNames > 0 || indexedDocuments.elementSize > 0) {
            newDocNames = new String[onDiskLength + indexedDocuments.elementSize - numDeletedDocNames];
            count = 0;
            int i4 = 0;
            while (i4 < onDiskLength) {
                if (positions[i4] >= -1) {
                    newDocNames[count++] = onDiskNames[i4];
                }
                ++i4;
            }
            Object[] added = indexedDocuments.keyTable;
            int i5 = 0;
            int l3 = added.length;
            while (i5 < l3) {
                if (added[i5] != null) {
                    newDocNames[count++] = (String)added[i5];
                }
                ++i5;
            }
            Util.sort(newDocNames);
            i5 = 0;
            l3 = newDocNames.length;
            while (i5 < l3) {
                if (indexedDocuments.containsKey(newDocNames[i5])) {
                    indexedDocuments.put(newDocNames[i5], new Integer(i5));
                }
                ++i5;
            }
        }
        count = -1;
        int i6 = 0;
        block13: while (i6 < onDiskLength) {
            switch (positions[i6]) {
                case -2: {
                    ++i6;
                    break;
                }
                case -1: {
                    String newName = newDocNames[++count];
                    if (!newName.equals(onDiskNames[i6])) continue block13;
                    indexedDocuments.put(newName, new Integer(count));
                    ++i6;
                    break;
                }
                default: {
                    if (!newDocNames[++count].equals(onDiskNames[i6])) continue block13;
                    positions[i6++] = count;
                }
            }
        }
        return newDocNames;
    }

    private void copyQueryResults(HashtableOfObject categoryToWords, int newPosition) throws IOException {
        char[][] categoryNames = categoryToWords.keyTable;
        Object[] wordSets = categoryToWords.valueTable;
        int i = 0;
        int l = categoryNames.length;
        while (i < l) {
            char[] categoryName = categoryNames[i];
            if (categoryName != null) {
                SimpleWordSet wordSet = (SimpleWordSet)wordSets[i];
                HashtableOfObject wordsToDocs = (HashtableOfObject)this.categoryTables.get(categoryName);
                if (wordsToDocs == null) {
                    wordsToDocs = new HashtableOfObject(wordSet.elementSize);
                    this.categoryTables.put(categoryName, wordsToDocs);
                }
                char[][] words = wordSet.words;
                int j = 0;
                int m = words.length;
                while (j < m) {
                    char[] word = words[j];
                    if (word != null) {
                        Object o = wordsToDocs.get(word);
                        if (o == null) {
                            wordsToDocs.put(word, new int[]{newPosition});
                        } else if (o instanceof IntList) {
                            ((IntList)o).add(newPosition);
                        } else {
                            IntList list = new IntList((int[])o);
                            list.add(newPosition);
                            wordsToDocs.put(word, list);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    File getIndexFile() {
        if (this.fileName == null) {
            return null;
        }
        return new File(this.fileName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize(boolean reuseExistingFile) throws IOException {
        File indexFile = this.getIndexFile();
        if (indexFile.exists()) {
            if (reuseExistingFile) {
                RandomAccessFile file = new RandomAccessFile(this.fileName, "r");
                try {
                    String signature = file.readUTF();
                    if (!signature.equals(SIGNATURE)) {
                        throw new IOException(Util.bind("exception.wrongFormat"));
                    }
                    this.headerInfoOffset = file.readInt();
                    if (this.headerInfoOffset > 0) {
                        this.readHeaderInfo(file);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    file.close();
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                    file.close();
                    return;
                }
            }
            if (!indexFile.delete()) {
                if (!DEBUG) throw new IOException("Failed to delete index " + this.fileName);
                System.out.println("initialize - Failed to delete index " + this.fileName);
                throw new IOException("Failed to delete index " + this.fileName);
            }
        }
        if (!indexFile.createNewFile()) {
            if (!DEBUG) throw new IOException("Failed to create new index " + this.fileName);
            System.out.println("initialize - Failed to create new index " + this.fileName);
            throw new IOException("Failed to create new index " + this.fileName);
        }
        RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
        try {
            file.writeUTF(SIGNATURE);
            file.writeInt(-1);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            file.close();
            throw throwable;
        }
        {
            Object var4_7 = null;
            file.close();
            return;
        }
    }

    private void initializeFrom(DiskIndex diskIndex, File newIndexFile) throws IOException {
        if (newIndexFile.exists() && !newIndexFile.delete()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to delete temp index " + this.fileName);
            }
        } else if (!newIndexFile.createNewFile()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to create temp index " + this.fileName);
            }
            throw new IOException("Failed to create temp index " + this.fileName);
        }
        int size = diskIndex.categoryOffsets == null ? 8 : diskIndex.categoryOffsets.elementSize;
        this.categoryOffsets = new HashtableOfIntValues(size);
        this.categoryTables = new HashtableOfObject(size);
    }

    private void mergeCategories(DiskIndex onDisk, int[] positions, DataOutputStream stream) throws IOException {
        char[][] oldNames = onDisk.categoryOffsets.keyTable;
        int i = 0;
        int l = oldNames.length;
        while (i < l) {
            char[] oldName = oldNames[i];
            if (oldName != null && !this.categoryTables.containsKey(oldName)) {
                this.categoryTables.put(oldName, null);
            }
            ++i;
        }
        char[][] categoryNames = this.categoryTables.keyTable;
        int i2 = 0;
        int l2 = categoryNames.length;
        while (i2 < l2) {
            if (categoryNames[i2] != null) {
                this.mergeCategory(categoryNames[i2], onDisk, positions, stream);
            }
            ++i2;
        }
        this.categoryTables = null;
    }

    private void mergeCategory(char[] categoryName, DiskIndex onDisk, int[] positions, DataOutputStream stream) throws IOException {
        HashtableOfObject wordsToDocs;
        block12: {
            HashtableOfObject oldWordsToDocs;
            wordsToDocs = (HashtableOfObject)this.categoryTables.get(categoryName);
            if (wordsToDocs == null) {
                wordsToDocs = new HashtableOfObject(3);
            }
            if ((oldWordsToDocs = onDisk.readCategoryTable(categoryName, true)) == null) break block12;
            char[][] oldWords = oldWordsToDocs.keyTable;
            Object[] oldArrayOffsets = oldWordsToDocs.valueTable;
            int i = 0;
            int l = oldWords.length;
            while (i < l) {
                block13: {
                    Object o;
                    int count;
                    int[] mappedNumbers;
                    char[] oldWord;
                    block14: {
                        oldWord = oldWords[i];
                        if (oldWord == null) break block13;
                        int[] oldDocNumbers = (int[])oldArrayOffsets[i];
                        int length = oldDocNumbers.length;
                        mappedNumbers = new int[length];
                        count = 0;
                        int j = 0;
                        while (j < length) {
                            int pos = positions[oldDocNumbers[j]];
                            if (pos > -1) {
                                mappedNumbers[count++] = pos;
                            }
                            ++j;
                        }
                        if (count >= length) break block14;
                        if (count == 0) break block13;
                        int[] nArray = mappedNumbers;
                        mappedNumbers = new int[count];
                        System.arraycopy(nArray, 0, mappedNumbers, 0, count);
                    }
                    if ((o = wordsToDocs.get(oldWord)) == null) {
                        wordsToDocs.put(oldWord, mappedNumbers);
                    } else {
                        IntList list = null;
                        if (o instanceof IntList) {
                            list = (IntList)o;
                        } else {
                            list = new IntList((int[])o);
                            wordsToDocs.put(oldWord, list);
                        }
                        int j = 0;
                        while (j < count) {
                            list.add(mappedNumbers[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            onDisk.categoryTables.put(categoryName, null);
        }
        this.writeCategoryTable(categoryName, wordsToDocs, stream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DiskIndex mergeWith(MemoryIndex memoryIndex) throws IOException {
        String[] docNames = this.readAllDocumentNames();
        int previousLength = docNames.length;
        int[] positions = new int[previousLength];
        SimpleLookupTable indexedDocuments = new SimpleLookupTable(3);
        if ((docNames = this.computeDocumentNames(docNames, positions, indexedDocuments, memoryIndex)).length == 0) {
            if (previousLength == 0) {
                return this;
            }
            DiskIndex newDiskIndex = new DiskIndex(this.fileName);
            newDiskIndex.initialize(false);
            return newDiskIndex;
        }
        DiskIndex newDiskIndex = new DiskIndex(String.valueOf(this.fileName) + ".tmp");
        File newIndexFile = newDiskIndex.getIndexFile();
        try {
            newDiskIndex.initializeFrom(this, newIndexFile);
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newIndexFile, false), 2048));
            int offsetToHeader = -1;
            try {
                newDiskIndex.writeAllDocumentNames(docNames, stream);
                docNames = null;
                if (indexedDocuments.elementSize > 0) {
                    Object[] names = indexedDocuments.keyTable;
                    Object[] integerPositions = indexedDocuments.valueTable;
                    int i = 0;
                    int l = names.length;
                    while (i < l) {
                        if (names[i] != null) {
                            newDiskIndex.copyQueryResults((HashtableOfObject)memoryIndex.docsToReferences.get(names[i]), (Integer)integerPositions[i]);
                        }
                        ++i;
                    }
                }
                indexedDocuments = null;
                if (previousLength == 0) {
                    newDiskIndex.writeCategories(stream);
                } else {
                    newDiskIndex.mergeCategories(this, positions, stream);
                }
                offsetToHeader = stream.size();
                newDiskIndex.writeHeaderInfo(stream);
                positions = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var14_18 = null;
            }
            stream.close();
            newDiskIndex.writeOffsetToHeader(offsetToHeader);
            File old = this.getIndexFile();
            if (!old.delete()) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to delete " + this.fileName);
                }
                throw new IOException("Failed to delete index file " + this.fileName);
            }
            if (!newIndexFile.renameTo(old)) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to rename " + this.fileName);
                }
                throw new IOException("Failed to rename index file " + this.fileName);
            }
        }
        catch (IOException e) {
            if (newIndexFile.exists() && !newIndexFile.delete() && DEBUG) {
                System.out.println("mergeWith - Failed to delete temp index " + newDiskIndex.fileName);
            }
            throw e;
        }
        newDiskIndex.fileName = this.fileName;
        return newDiskIndex;
    }

    private synchronized String[] readAllDocumentNames() throws IOException {
        String[] stringArray;
        if (this.numberOfChunks <= 0) {
            return new String[0];
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        try {
            stream.skip(this.chunkOffsets[0]);
            int lastIndex = this.numberOfChunks - 1;
            String[] docNames = new String[lastIndex * 100 + this.sizeOfLastChunk];
            int i = 0;
            while (i < this.numberOfChunks) {
                this.readChunk(docNames, stream, i * 100, i < lastIndex ? 100 : this.sizeOfLastChunk);
                ++i;
            }
            stringArray = docNames;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized HashtableOfObject readCategoryTable(char[] categoryName, boolean cacheDocNumbers) throws IOException {
        int offset = this.categoryOffsets.get(categoryName);
        if (offset == Integer.MIN_VALUE) {
            return null;
        }
        if (this.categoryTables == null) {
            this.categoryTables = new HashtableOfObject(this.categoryOffsets.elementSize);
        } else {
            HashtableOfObject cachedTable = (HashtableOfObject)this.categoryTables.get(categoryName);
            if (cachedTable != null) {
                return cachedTable;
            }
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        HashtableOfObject categoryTable = null;
        char[][] matchingWords = null;
        int count = 0;
        int firstOffset = -1;
        try {
            stream.skip(offset);
            int size = stream.readInt();
            categoryTable = new HashtableOfObject(size);
            if (cacheDocNumbers) {
                matchingWords = new char[size][];
            }
            int i = 0;
            while (true) {
                block17: {
                    if (i < size) break block17;
                    this.categoryTables.put(categoryName, categoryTable);
                    break;
                }
                char[] word = Util.readUTF(stream);
                int arrayOffset = stream.readInt();
                if (arrayOffset > 0) {
                    if (matchingWords != null) {
                        if (count == 0) {
                            firstOffset = arrayOffset;
                        }
                        matchingWords[count++] = word;
                    }
                    categoryTable.put(word, new Integer(arrayOffset));
                } else {
                    categoryTable.put(word, new int[]{-arrayOffset});
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var13_18 = null;
        }
        stream.close();
        if (count <= 0) return categoryTable;
        stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        try {
            stream.skip(firstOffset);
            int i = 0;
            while (i < count) {
                categoryTable.put(matchingWords[i], this.readDocumentArray(stream));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        stream.close();
        return categoryTable;
    }

    private void readChunk(String[] docNames, DataInputStream stream, int index, int size) throws IOException {
        String current = stream.readUTF();
        docNames[index++] = current;
        int i = 1;
        while (i < size) {
            int length;
            int start = stream.readUnsignedByte();
            int end = stream.readUnsignedByte();
            String next = stream.readUTF();
            if (start > 0) {
                if (end > 0) {
                    length = current.length();
                    next = String.valueOf(current.substring(0, start)) + next + current.substring(length - end, length);
                } else {
                    next = String.valueOf(current.substring(0, start)) + next;
                }
            } else if (end > 0) {
                length = current.length();
                next = String.valueOf(next) + current.substring(length - end, length);
            }
            docNames[index++] = next;
            current = next;
            ++i;
        }
    }

    private int[] readDocumentArray(DataInputStream stream) throws IOException {
        int arraySize = stream.readShort();
        if (arraySize == Short.MAX_VALUE) {
            arraySize = stream.readInt();
        }
        int[] result = new int[arraySize];
        int i = 0;
        while (i < arraySize) {
            switch (this.documentReferenceSize) {
                case 1: {
                    result[i] = stream.readUnsignedByte();
                    break;
                }
                case 2: {
                    result[i] = stream.readUnsignedShort();
                    break;
                }
                default: {
                    result[i] = stream.readInt();
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String readDocumentName(int docNumber) throws IOException {
        int chunkNumber;
        String[] chunk;
        if (this.cachedChunks == null) {
            this.cachedChunks = new String[this.numberOfChunks][];
        }
        if ((chunk = this.cachedChunks[chunkNumber = docNumber / 100]) == null) {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
            try {
                stream.skip(this.chunkOffsets[chunkNumber]);
                int size = chunkNumber == this.numberOfChunks - 1 ? this.sizeOfLastChunk : 100;
                chunk = new String[size];
                this.readChunk(chunk, stream, 0, size);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            stream.close();
            this.cachedChunks[chunkNumber] = chunk;
        }
        return chunk[docNumber - chunkNumber * 100];
    }

    synchronized int[] readDocumentNumbers(Object arrayOffset) throws IOException {
        int[] nArray;
        if (arrayOffset instanceof int[]) {
            return (int[])arrayOffset;
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.getIndexFile()), 2048));
        try {
            stream.skip(((Integer)arrayOffset).intValue());
            nArray = this.readDocumentArray(stream);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
        return nArray;
    }

    private void readHeaderInfo(RandomAccessFile file) throws IOException {
        file.seek(this.headerInfoOffset);
        this.numberOfChunks = file.readInt();
        this.sizeOfLastChunk = file.readUnsignedByte();
        this.documentReferenceSize = file.readUnsignedByte();
        this.chunkOffsets = new int[this.numberOfChunks];
        int i = 0;
        while (i < this.numberOfChunks) {
            this.chunkOffsets[i] = file.readInt();
            ++i;
        }
        int size = file.readInt();
        this.categoryOffsets = new HashtableOfIntValues(size);
        int i2 = 0;
        while (i2 < size) {
            this.categoryOffsets.put(Util.readUTF(file), file.readInt());
            ++i2;
        }
        this.categoryTables = new HashtableOfObject(size);
    }

    synchronized void startQuery() {
        ++this.cacheUserCount;
    }

    synchronized void stopQuery() {
        if (--this.cacheUserCount < 0) {
            this.cacheUserCount = -1;
            this.cachedChunks = null;
            this.categoryTables = null;
        }
    }

    private void writeAllDocumentNames(String[] sortedDocNames, DataOutputStream stream) throws IOException {
        if (sortedDocNames.length == 0) {
            throw new IllegalArgumentException();
        }
        stream.writeUTF(SIGNATURE);
        this.headerInfoOffset = stream.size();
        stream.writeInt(-1);
        int size = sortedDocNames.length;
        this.numberOfChunks = size / 100 + 1;
        this.sizeOfLastChunk = size % 100;
        if (this.sizeOfLastChunk == 0) {
            --this.numberOfChunks;
            this.sizeOfLastChunk = 100;
        }
        this.documentReferenceSize = size <= 127 ? 1 : (size <= Short.MAX_VALUE ? 2 : 4);
        this.chunkOffsets = new int[this.numberOfChunks];
        int lastIndex = this.numberOfChunks - 1;
        int i = 0;
        while (i < this.numberOfChunks) {
            this.chunkOffsets[i] = stream.size();
            int chunkSize = i == lastIndex ? this.sizeOfLastChunk : 100;
            int chunkIndex = i * 100;
            String current = sortedDocNames[chunkIndex];
            stream.writeUTF(current);
            int j = 1;
            while (j < chunkSize) {
                int len2;
                String next = sortedDocNames[chunkIndex + j];
                int len1 = current.length();
                int max = len1 < (len2 = next.length()) ? len1 : len2;
                int start = 0;
                while (current.charAt(start) == next.charAt(start)) {
                    if (max == ++start) break;
                }
                if (start > 255) {
                    start = 255;
                }
                int end = 0;
                while (current.charAt(--len1) == next.charAt(--len2)) {
                    ++end;
                    if (len2 == start) break;
                }
                if (end > 255) {
                    end = 255;
                }
                stream.writeByte(start);
                stream.writeByte(end);
                int last = next.length() - end;
                stream.writeUTF(start < last ? next.substring(start, last) : "");
                current = next;
                ++j;
            }
            ++i;
        }
    }

    private void writeCategories(DataOutputStream stream) throws IOException {
        char[][] categoryNames = this.categoryTables.keyTable;
        Object[] tables = this.categoryTables.valueTable;
        int i = 0;
        int l = categoryNames.length;
        while (i < l) {
            if (categoryNames[i] != null) {
                this.writeCategoryTable(categoryNames[i], (HashtableOfObject)tables[i], stream);
            }
            ++i;
        }
        this.categoryTables = null;
    }

    private void writeCategoryTable(char[] categoryName, HashtableOfObject wordsToDocs, DataOutputStream stream) throws IOException {
        Object[] values = wordsToDocs.valueTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            Object o = values[i];
            if (o != null) {
                int[] documentNumbers = o instanceof int[] ? (int[])o : ((IntList)o).asArray();
                int length = documentNumbers.length;
                if (length == 1) {
                    values[i] = new Integer(-documentNumbers[0]);
                } else {
                    values[i] = new Integer(stream.size());
                    this.writeDocumentNumbers(documentNumbers, stream);
                }
            }
            ++i;
        }
        this.categoryOffsets.put(categoryName, stream.size());
        this.categoryTables.put(categoryName, null);
        stream.writeInt(wordsToDocs.elementSize);
        char[][] words = wordsToDocs.keyTable;
        int i2 = 0;
        int l2 = words.length;
        while (i2 < l2) {
            if (words[i2] != null) {
                Util.writeUTF(stream, words[i2]);
                stream.writeInt((Integer)values[i2]);
            }
            ++i2;
        }
    }

    private void writeDocumentNumbers(int[] documentNumbers, DataOutputStream stream) throws IOException {
        int length = documentNumbers.length;
        if (length < Short.MAX_VALUE) {
            if (length == 0) {
                throw new IllegalArgumentException();
            }
            stream.writeShort(length);
        } else {
            stream.writeShort(Short.MAX_VALUE);
            stream.writeInt(length);
        }
        Util.sort(documentNumbers);
        int i = 0;
        while (i < length) {
            switch (this.documentReferenceSize) {
                case 1: {
                    stream.writeByte(documentNumbers[i]);
                    break;
                }
                case 2: {
                    stream.writeShort(documentNumbers[i]);
                    break;
                }
                default: {
                    stream.writeInt(documentNumbers[i]);
                }
            }
            ++i;
        }
    }

    private void writeHeaderInfo(DataOutputStream stream) throws IOException {
        stream.writeInt(this.numberOfChunks);
        stream.writeByte(this.sizeOfLastChunk);
        stream.writeByte(this.documentReferenceSize);
        int i = 0;
        while (i < this.numberOfChunks) {
            stream.writeInt(this.chunkOffsets[i]);
            ++i;
        }
        stream.writeInt(this.categoryOffsets.elementSize);
        char[][] categoryNames = this.categoryOffsets.keyTable;
        int[] offsets = this.categoryOffsets.valueTable;
        int i2 = 0;
        int l = categoryNames.length;
        while (i2 < l) {
            if (categoryNames[i2] != null) {
                Util.writeUTF(stream, categoryNames[i2]);
                stream.writeInt(offsets[i2]);
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeOffsetToHeader(int offsetToHeader) throws IOException {
        if (offsetToHeader <= 0) return;
        RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
        try {
            file.seek(this.headerInfoOffset);
            file.writeInt(offsetToHeader);
            this.headerInfoOffset = offsetToHeader;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            file.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        file.close();
    }

    class IntList {
        int size;
        int[] elements;

        IntList(int[] elements) {
            this.elements = elements;
            this.size = elements.length;
        }

        void add(int newElement) {
            if (this.size == this.elements.length) {
                int newSize = this.size * 3;
                if (newSize < 7) {
                    newSize = 7;
                }
                this.elements = new int[newSize];
                System.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
            this.elements[this.size++] = newElement;
        }

        int[] asArray() {
            int[] result = new int[this.size];
            System.arraycopy(this.elements, 0, result, 0, this.size);
            return result;
        }
    }
}

