/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectCreator {
    public IJavaProject createJavaProjectFromJavacNode(String projectName, Javac javacTask) throws CoreException {
        IJavaProject javaProject = this.createJavaProject(projectName);
        File destDir = javacTask.getDestdir();
        String destDirName = destDir.getName();
        Path sourceDirs = javacTask.getSrcdir();
        this.createSourceDirectories(destDir, destDirName, sourceDirs, javaProject);
        this.addVariableEntry(javaProject, (IPath)new org.eclipse.core.runtime.Path("JRE_LIB"), (IPath)new org.eclipse.core.runtime.Path("JRE_SRC"), (IPath)new org.eclipse.core.runtime.Path("JRE_SRCROOT"));
        this.setClasspath(javacTask, javaProject);
        javaProject.getProject().refreshLocal(2, null);
        return javaProject;
    }

    private void setClasspath(Javac javacTask, IJavaProject javaProject) throws JavaModelException {
        Path classpath = javacTask.getClasspath();
        if (classpath == null) {
            return;
        }
        String[] classpaths = classpath.list();
        int i = 0;
        while (i < classpaths.length) {
            String cp = classpaths[i];
            File classpathEntry = new File(cp);
            this.addLibrary(javaProject, (IPath)new org.eclipse.core.runtime.Path(classpathEntry.getAbsolutePath()));
            ++i;
        }
    }

    private void createSourceDirectories(File destDir, String destDirName, Path sourceDirs, IJavaProject javaProject) throws CoreException {
        String[] sourceDirectories = sourceDirs.list();
        int i = 0;
        while (i < sourceDirectories.length) {
            String srcDir = sourceDirectories[i];
            File srcDirectory = new File(srcDir);
            this.addSourceContainer(javaProject, srcDirectory.getName(), srcDir, destDirName, destDir.getAbsolutePath());
            ++i;
        }
    }

    private IJavaProject createJavaProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            this.addNatureToProject(project, "org.eclipse.jdt.core.javanature");
        }
        IJavaProject jproject = JavaCore.create((IProject)project);
        jproject.setRawClasspath(new IClasspathEntry[0], null);
        return jproject;
    }

    private void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    private IPackageFragmentRoot addSourceContainer(IJavaProject jproject, String srcName, String srcPath, String outputName, String outputPath) throws CoreException {
        IProject project = jproject.getProject();
        IProject container = null;
        if (srcName == null || srcName.length() == 0) {
            container = project;
        } else {
            IFolder folder = project.getFolder(srcName);
            if (!folder.exists()) {
                folder.createLink((IPath)new org.eclipse.core.runtime.Path(srcPath), 16, null);
            }
            container = folder;
        }
        IPackageFragmentRoot root = jproject.getPackageFragmentRoot((IResource)container);
        IFolder output = null;
        if (outputName != null && !(output = project.getFolder(outputName)).exists()) {
            output.createLink((IPath)new org.eclipse.core.runtime.Path(outputPath), 16, null);
        }
        IClasspathEntry cpe = JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])new IPath[0], (IPath)output.getFullPath());
        this.addToClasspath(jproject, cpe);
        return root;
    }

    private void addToClasspath(IJavaProject jproject, IClasspathEntry cpe) throws JavaModelException {
        IClasspathEntry[] oldEntries = jproject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(cpe)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = cpe;
        jproject.setRawClasspath(newEntries, null);
    }

    private void addVariableEntry(IJavaProject jproject, IPath path, IPath sourceAttachPath, IPath sourceAttachRoot) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachPath, (IPath)sourceAttachRoot);
        this.addToClasspath(jproject, cpe);
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        if (resolvedPath != null) {
            jproject.getPackageFragmentRoot(resolvedPath.toString());
        }
    }

    private void addLibrary(IJavaProject jproject, IPath path) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, null, null);
        this.addToClasspath(jproject, cpe);
        jproject.getPackageFragmentRoot(path.toString());
    }
}

