/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.model.AntModelMessages;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.editor.outline.LocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.XMLProblem;
import org.eclipse.ant.internal.ui.model.AntImageDescriptor;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AntElementNode
implements IAdaptable {
    protected int offset = -1;
    protected int length = -1;
    protected int selectionLength;
    protected AntElementNode parent;
    private AntElementNode importNode;
    protected List childNodes = null;
    protected String name;
    private int problemSeverity = -1;
    private String filePath;
    private boolean isExternal = false;
    private String fElementPath;
    private String fElementIdentifier;
    private IProblem fProblem;
    private int fLine;
    private int fColumn;

    public AntElementNode(String aName) {
        this.name = aName;
    }

    public AntElementNode() {
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.getName();
    }

    public List getChildNodes() {
        return this.childNodes;
    }

    public List getDescendents() {
        if (this.childNodes == null) {
            return null;
        }
        ArrayList descendents = new ArrayList();
        this.determineDescendents(descendents, this.childNodes);
        return descendents;
    }

    private void determineDescendents(List descendents, List childrenNodes) {
        Iterator itr = childrenNodes.iterator();
        while (itr.hasNext()) {
            AntElementNode element = (AntElementNode)itr.next();
            if (element.hasChildren()) {
                this.determineDescendents(descendents, element.getChildNodes());
            }
            descendents.add(element);
        }
    }

    public AntElementNode getParentNode() {
        return this.parent;
    }

    public AntProjectNode getProjectNode() {
        AntElementNode projectParent = this.getParentNode();
        while (projectParent != null && !(projectParent instanceof AntProjectNode)) {
            projectParent = projectParent.getParentNode();
        }
        return (AntProjectNode)projectParent;
    }

    public void addChildNode(AntElementNode childElement) {
        childElement.setParent(this);
        if (this.childNodes == null) {
            this.childNodes = new ArrayList();
        }
        this.childNodes.add(childElement);
    }

    protected void setParent(AntElementNode node) {
        this.parent = node;
    }

    public void setFilePath(String path) {
        if (path == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            this.filePath = path;
            return;
        }
        this.filePath = new Path(new File(url.getPath()).getAbsolutePath()).toString();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int anOffset) {
        this.offset = anOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int aLength) {
        this.length = aLength;
        if (this.fProblem != null && this.fProblem instanceof XMLProblem) {
            ((XMLProblem)this.fProblem).setLength(aLength);
            this.fProblem = null;
        }
    }

    public String toString() {
        return "Ant Element Node: " + this.getLabel() + " Offset: " + this.getOffset() + " Length: " + this.getLength();
    }

    public boolean isErrorNode() {
        return this.problemSeverity == 1 || this.problemSeverity == 2;
    }

    public boolean isWarningNode() {
        return this.problemSeverity == 0;
    }

    public void setProblemSeverity(int severity) {
        this.problemSeverity = severity;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    private String getElementPath() {
        if (this.fElementPath == null) {
            StringBuffer buffer = new StringBuffer(this.getParentNode() != null ? this.getParentNode().getElementPath() : "");
            buffer.append('/');
            buffer.append(this.getElementIdentifier());
            buffer.append('[');
            buffer.append(this.getParentNode() != null ? this.getParentNode().getElementIndexOf(this) : 0);
            buffer.append(']');
            this.fElementPath = buffer.toString();
        }
        return this.fElementPath;
    }

    private String getElementIdentifier() {
        if (this.fElementIdentifier == null) {
            StringBuffer buffer = this.escape(new StringBuffer(this.getName() != null ? this.getName() : ""), '\\', "$/[]\\");
            buffer.append('$');
            buffer.append(this.escape(new StringBuffer(this.getLabel() != null ? this.getLabel() : ""), '\\', "$/[]\\").toString());
            this.fElementIdentifier = buffer.toString();
        }
        return this.fElementIdentifier;
    }

    private StringBuffer escape(StringBuffer sb, char esc, String special) {
        int i = 0;
        while (i < sb.length()) {
            if (special.indexOf(sb.charAt(i)) >= 0) {
                sb.insert(i++, esc);
            }
            ++i;
        }
        return sb;
    }

    private int getElementIndexOf(AntElementNode child) {
        if (this.getChildNodes() == null) {
            return -1;
        }
        int result = -1;
        Iterator iter = this.getChildNodes().iterator();
        AntElementNode current = null;
        while (current != child && iter.hasNext()) {
            current = (AntElementNode)iter.next();
            if (!child.getElementIdentifier().equals(current.getElementIdentifier())) continue;
            ++result;
        }
        if (current != child) {
            return -1;
        }
        return result;
    }

    public boolean equals(Object o2) {
        AntElementNode o1 = this;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!(o1 instanceof AntElementNode) && !(o2 instanceof AntElementNode)) {
            return o2.equals(o1);
        }
        if (!(o1 instanceof AntElementNode) || !(o2 instanceof AntElementNode)) {
            return false;
        }
        AntElementNode e1 = o1;
        AntElementNode e2 = (AntElementNode)o2;
        return e1.getElementPath().equals(e2.getElementPath());
    }

    public int hashCode() {
        return this.getElementPath().hashCode();
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.selectionLength = selectionLength;
    }

    public AntElementNode getNode(int sourceOffset) {
        if (this.childNodes != null) {
            Iterator iter = this.childNodes.iterator();
            while (iter.hasNext()) {
                AntElementNode node = (AntElementNode)iter.next();
                AntElementNode containingNode = node.getNode(sourceOffset);
                if (containingNode == null) continue;
                return containingNode;
            }
        }
        if (this.length == -1 && this.offset <= sourceOffset && !this.isExternal()) {
            return this;
        }
        if (this.offset <= sourceOffset && sourceOffset <= this.offset + this.length - 2) {
            return this;
        }
        return null;
    }

    public Image getImage() {
        int flags = 0;
        if (this.isErrorNode()) {
            flags |= 1;
        } else if (this.isWarningNode()) {
            flags |= 4;
        }
        if (this.importNode != null || this.isExternal()) {
            flags |= 2;
        }
        ImageDescriptor base = this.getBaseImageDescriptor();
        return AntUIImages.getImage(new AntImageDescriptor(base, flags));
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.html_tab_obj");
    }

    protected AntModel getAntModel() {
        AntElementNode parentNode = this.getParentNode();
        while (!(parentNode instanceof AntProjectNode)) {
            parentNode = parentNode.getParentNode();
        }
        return parentNode.getAntModel();
    }

    public void associatedProblem(IProblem problem) {
        this.fProblem = problem;
    }

    protected void appendEntityName(StringBuffer displayName) {
        String path = this.getFilePath();
        if (this.getImportNode() != null) {
            displayName.append(MessageFormat.format(AntModelMessages.getString("AntElementNode.9"), this.getImportNode().getLabel()));
        } else {
            String entityName = this.getAntModel().getEntityName(path);
            displayName.append(MessageFormat.format(AntModelMessages.getString("AntElementNode.9"), entityName));
        }
    }

    public AntElementNode getImportNode() {
        return this.importNode;
    }

    public void setImportNode(AntElementNode importNode) {
        this.importNode = importNode;
    }

    public boolean hasChildren() {
        if (this.childNodes == null) {
            return false;
        }
        return !this.childNodes.isEmpty();
    }

    public void reset() {
        this.childNodes = null;
    }

    public void setExternalInfo(int line, int column) {
        this.fLine = line;
        this.fColumn = column;
    }

    public int[] getExternalInfo() {
        return new int[]{this.fLine, this.fColumn};
    }

    public IFile getIFile() {
        if (this.isExternal()) {
            return AntUtil.getFileForLocation(this.filePath, null);
        }
        return this.getBuildFileResource();
    }

    public IFile getBuildFileResource() {
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        return locationProvider.getFile();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

