/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.launchConfigurations.MessageIds;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class RemoteAntBuildListener
implements ILaunchesListener {
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private int fPort = -1;
    private BufferedReader fBufferedReader;
    private boolean fDebug = false;
    private IProcess fProcess;
    private String fProcessId;
    private File fBuildFileParent = null;
    private List fMessageQueue;
    private ILaunch fLaunch;

    public RemoteAntBuildListener(ILaunch launch) {
        this.fLaunch = launch;
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public synchronized void startListening(int port) {
        this.fPort = port;
        ServerConnection connection = new ServerConnection(port);
        connection.start();
    }

    private synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        this.fLaunch = null;
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    private void receiveMessage(String message) {
        if (this.fDebug) {
            System.out.println(message);
        }
        if (message.startsWith(MessageIds.TASK)) {
            message = message.substring(MessageIds.TASK.length());
            int index = message.indexOf(44);
            int priority = Integer.parseInt(message.substring(0, index));
            int index2 = message.indexOf(44, index + 1);
            String taskName = message.substring(index + 1, index2);
            int index3 = message.indexOf(44, index2 + 1);
            int lineLength = Integer.parseInt(message.substring(index2 + 1, index3));
            int finalIndex = index3 + 1 + lineLength;
            String line = message.substring(index3 + 1, finalIndex);
            String location = message.substring(finalIndex + 1);
            int size = 15 - (taskName.length() + 3);
            int offset = Math.max(size - 2, 1);
            int length = 15 - size - 3;
            FileLink taskLink = AntUtil.getTaskLink(location, this.fBuildFileParent);
            if (taskLink != null) {
                TaskLinkManager.addTaskHyperlink(this.getProcess(), (IConsoleHyperlink)taskLink, (IRegion)new Region(offset, length), line);
            }
            StringBuffer fullMessage = new StringBuffer();
            this.adornMessage(taskName, line, fullMessage);
            this.writeMessage(fullMessage.append(System.getProperty("line.separator")).toString(), priority);
        } else if (message.startsWith(MessageIds.PROCESS_ID)) {
            this.fProcessId = message = message.substring(MessageIds.PROCESS_ID.length());
        } else {
            int index = message.indexOf(44);
            if (index > 0) {
                int priority = Integer.parseInt(message.substring(0, index));
                message = message.substring(index + 1);
                this.writeMessage(String.valueOf(message) + System.getProperty("line.separator"), priority);
            }
        }
    }

    private IProcess getProcess() {
        if (this.fProcess == null && this.fProcessId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int i = 0;
            while (i < all.length) {
                IProcess process = all[i];
                if (this.fProcessId.equals(process.getAttribute("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"))) {
                    this.fProcess = process;
                    break;
                }
                ++i;
            }
        }
        return this.fProcess;
    }

    private AntStreamMonitor getMonitor(int priority) {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (proxy == null) {
            return null;
        }
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
            }
        }
        return monitor;
    }

    private void adornMessage(String taskName, String line, StringBuffer fullMessage) {
        if (taskName == null) {
            taskName = "null";
        }
        int size = 15 - (taskName.length() + 6);
        int i = 0;
        while (i < size) {
            fullMessage.append(' ');
            ++i;
        }
        fullMessage.append(line);
    }

    private void writeMessage(String message, int priority) {
        AntStreamMonitor monitor = this.getMonitor(priority);
        if (monitor == null) {
            if (this.fMessageQueue == null) {
                this.fMessageQueue = new ArrayList();
            }
            this.fMessageQueue.add(message);
            return;
        }
        if (this.fMessageQueue != null) {
            Iterator iter = this.fMessageQueue.iterator();
            while (iter.hasNext()) {
                String oldMessage = (String)iter.next();
                monitor.append(oldMessage);
            }
            this.fMessageQueue = null;
        }
        monitor.append(message);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.equals(this.fLaunch)) {
                this.shutDown();
                return;
            }
            ++i;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            AntUIPlugin.log(exception);
        }
    }

    private class ServerConnection
    extends Thread {
        private int fServerPort;

        public ServerConnection(int port) {
            super("Ant Build Server Connection");
            this.fServerPort = port;
        }

        public void run() {
            try {
                String message;
                if (RemoteAntBuildListener.this.fDebug) {
                    System.out.println("Creating server socket " + this.fServerPort);
                }
                RemoteAntBuildListener.this.fServerSocket = new ServerSocket(this.fServerPort);
                RemoteAntBuildListener.this.fSocket = RemoteAntBuildListener.this.fServerSocket.accept();
                if (RemoteAntBuildListener.this.fDebug) {
                    System.out.println("Connection");
                }
                RemoteAntBuildListener.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteAntBuildListener.this.fSocket.getInputStream()));
                while (RemoteAntBuildListener.this.fBufferedReader != null && (message = RemoteAntBuildListener.this.fBufferedReader.readLine()) != null) {
                    RemoteAntBuildListener.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {}
            RemoteAntBuildListener.this.shutDown();
        }
    }
}

