/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.ProvidingBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;
    protected Vector removalPending;
    protected KeyedHashSet exportedPackages;
    protected KeyedHashSet exportedBundles;
    private long cumulativeTime;
    private static boolean checkServiceClassSource = true;
    private static boolean restrictServiceClasses = false;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    protected void initialize() {
        checkServiceClassSource = Boolean.valueOf(System.getProperty("osgi.checkServiceClassSource", "true"));
        restrictServiceClasses = Boolean.valueOf(System.getProperty("osgi.restrictServiceClasses", "false"));
        this.removalPending = new Vector(10, 10);
        State state = this.framework.adaptor.getState();
        if (!state.isResolved()) {
            state.resolve(false);
        }
        this.exportedPackages = new KeyedHashSet(false);
        this.exportedBundles = new KeyedHashSet(false);
    }

    /*
     * Exception decompiling
     */
    private KeyedHashSet getExportedPackages(KeyedHashSet packageSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KeyedHashSet getExportedBundles(KeyedHashSet bundleSet) {
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescripts = state.getResolvedBundles();
        int i = 0;
        while (i < bundleDescripts.length) {
            BundleDescription bundledes = bundleDescripts[i];
            AbstractBundle bundle = this.framework.getBundle(bundledes.getBundleId());
            if (bundle != null && bundle.isResolved() && bundle.getSymbolicName() != null && bundle instanceof BundleHost && bundle.checkProvideBundlePermission(bundle.getSymbolicName())) {
                BundleLoaderProxy loaderProxy = ((BundleHost)bundle).getLoaderProxy();
                bundleSet.add(loaderProxy);
            }
            ++i;
        }
        return bundleSet;
    }

    protected void cleanup() {
        this.removalPending = null;
        this.exportedPackages = null;
        this.exportedBundles = null;
    }

    protected void addRemovalPending(BundleLoaderProxy loaderProxy) {
        this.removalPending.addElement(loaderProxy);
    }

    protected void deleteRemovalPending(BundleLoaderProxy loaderProxy) throws BundleException {
        boolean exporting = loaderProxy.inUse();
        if (exporting) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("BundleLoader.unexportPackager returned true! " + loaderProxy);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new BundleException(Msg.formatter.getString("OSGI_INTERNAL_ERROR"));
        }
        this.unexportResources(loaderProxy);
        BundleLoader loader = loaderProxy.getBundleLoader();
        loader.clear();
        loader.close();
        this.removalPending.remove(loaderProxy);
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            this.framework.bundles.markDependancies();
            KeyedElement[] elements = this.exportedPackages.elements();
            if (bundle != null) {
                Vector<ExportedPackageImpl> result = new Vector<ExportedPackageImpl>();
                int i = 0;
                while (i < elements.length) {
                    ExportedPackageImpl pkgElement = (ExportedPackageImpl)elements[i];
                    if (pkgElement.supplier.getBundleHost() == bundle) {
                        result.add(pkgElement);
                    }
                    ++i;
                }
                if (result.size() == 0) {
                    return null;
                }
                ExportedPackageImpl[] pkgElements = new ExportedPackageImpl[result.size()];
                return result.toArray(pkgElements);
            }
            if (elements.length == 0) {
                return null;
            }
            ExportedPackage[] pkgElements = new ExportedPackageImpl[elements.length];
            System.arraycopy(elements, 0, pkgElements, 0, pkgElements.length);
            return pkgElements;
        }
    }

    public ExportedPackage getExportedPackage(String packageName) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            this.framework.bundles.markDependancies();
            return (ExportedPackageImpl)this.exportedPackages.getByKey(packageName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission();
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            int size = input.length;
            copy = new AbstractBundle[size];
            System.arraycopy(input, 0, copy, 0, size);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = SecureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.refreshPackages(bundles);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshPackages(AbstractBundle[] refresh) {
        try {
            Vector graph = null;
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Initialize graph");
                }
                this.framework.bundles.markDependancies();
                graph = this.computeAffectedBundles(refresh);
                State state = this.framework.adaptor.getState();
                state.resolve(false);
                this.processDelta(graph);
            }
            this.resumeBundles(graph);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            return;
        }
    }

    private void resumeBundles(Vector graph) {
        Object[] refresh = new AbstractBundle[graph.size()];
        boolean[] cfr_ignored_0 = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: restart the bundles");
        }
        int i = 0;
        while (i < refresh.length) {
            Object bundle = refresh[i];
            if (((AbstractBundle)bundle).isResolved()) {
                this.framework.resumeBundle((AbstractBundle)bundle);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDelta(Vector graph) {
        refresh = new AbstractBundle[graph.size()];
        previouslyResolved = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        notify = new Vector<AbstractBundle>();
        try {
            block39: {
                try {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                    }
                    i = refresh.length - 1;
                    while (true) {
                        if (i < 0) {
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: refresh the bundles");
                            }
                            break;
                        }
                        changedBundle = refresh[i];
                        previouslyResolved[i] = changedBundle.isResolved();
                        if (changedBundle.isActive() && !changedBundle.isFragment()) {
                            suspended = this.framework.suspendBundle((AbstractBundle)changedBundle, true);
                            if (!suspended) {
                                throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                            }
                        } else {
                            changedBundle.beginStateChange();
                        }
                        if (Debug.DEBUG_PACKAGEADMIN && changedBundle.stateChanging == null) {
                            Debug.println("Bundle state change lock is clear! " + changedBundle);
                            Debug.printStackTrace(new Exception("Stack trace"));
                        }
                        --i;
                    }
                    i = this.removalPending.size() - 1;
                    while (true) {
                        if (i < 0) break;
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        if (graph.contains(loaderProxy.getBundleHost())) {
                            this.framework.bundles.unMarkDependancies(loaderProxy);
                        }
                        --i;
                    }
                    i = 0;
                    while (true) {
                        if (i >= refresh.length) {
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: unexport the removal pending packages");
                            }
                            break;
                        }
                        changedBundle = refresh[i];
                        changedBundle.refresh();
                        if (previouslyResolved[i]) {
                            this.framework.publishBundleEvent(64, (Bundle)changedBundle);
                        }
                        ++i;
                    }
                    i = this.removalPending.size() - 1;
                    while (true) {
                        if (i < 0) break;
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        removedBundle = loaderProxy.getBundleHost();
                        if (graph.contains(removedBundle)) {
                            this.deleteRemovalPending(loaderProxy);
                        }
                        --i;
                    }
                    allBundles = this.framework.bundles.getBundles();
                    size = allBundles.size();
                    i = 0;
                    while (true) {
                        block40: {
                            if (i < size) break block40;
                            this.exportedPackages = this.getExportedPackages(this.exportedPackages);
                            this.exportedBundles = this.getExportedBundles(this.exportedBundles);
                            ** GOTO lbl-1000
                        }
                        bundle = (AbstractBundle)allBundles.get(i);
                        if (!bundle.isResolved() && (bundleDes = bundle.getBundleDescription()) != null && bundleDes.isResolved()) {
                            if (bundle.isFragment()) {
                                host = (BundleHost)this.framework.getBundle(bundleDes.getHost().getSupplier().getBundleId());
                                if (((BundleFragment)bundle).setHost(host)) {
                                    bundle.resolve(bundleDes.isSingleton());
                                }
                            } else {
                                bundle.resolve(bundleDes.isSingleton());
                            }
                            if (bundle.isResolved()) {
                                notify.addElement(bundle);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable var12_18) {
                    var11_19 = null;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    i = 0;
                }
                while (true) {
                    if (i >= refresh.length) {
                        throw var12_18;
                    }
                    changedBundle = refresh[i];
                    changedBundle.completeStateChange();
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    var11_20 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block39;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            i = 0;
            while (true) {
                if (i >= refresh.length) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: clean up adaptor storage");
                    }
                    ** try [egrp 3[TRYBLOCK] [2 : 643->658)] { 
lbl104:
                    // 1 sources

                    break;
                }
                changedBundle = refresh[i];
                changedBundle.completeStateChange();
                ++i;
            }
            {
                this.framework.adaptor.compactStorage();
            }
lbl111:
            // 1 sources

            catch (IOException e) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages exception: " + e.getMessage());
                    Debug.printStackTrace(e);
                }
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
        }
        i = 0;
        while (true) {
            if (i >= notify.size()) {
                return;
            }
            changedBundle = (AbstractBundle)notify.elementAt(i);
            this.framework.publishBundleEvent(changedBundle.isResolved() != false ? 32 : 64, changedBundle);
            ++i;
        }
    }

    private void unresolvePermissions(Vector bundles, Hashtable packages) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: unresolve permissions");
        }
        int size = bundles.size();
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = (AbstractBundle)bundles.elementAt(i);
            bundle.unresolvePermissions(packages);
            ++i;
        }
    }

    private Vector computeAffectedBundles(AbstractBundle[] refresh) {
        boolean changed;
        AbstractBundle bundle;
        Vector<Bundle> graph = new Vector<Bundle>();
        if (refresh == null) {
            int size = this.removalPending.size();
            int i = 0;
            while (i < size) {
                BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                bundle = loaderProxy.getBundleHost();
                if (!graph.contains(bundle)) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println(" refresh: " + bundle);
                    }
                    graph.addElement(bundle);
                    AbstractBundle[] dependents = loaderProxy.getDependentBundles();
                    int j = 0;
                    while (j < dependents.length) {
                        if (!graph.contains(dependents[j])) {
                            graph.addElement(dependents[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < refresh.length) {
                AbstractBundle bundle2 = refresh[i];
                if (bundle2 != this.framework.systemBundle) {
                    BundleHost host;
                    if (bundle2.isFragment() && (host = (BundleHost)bundle2.getHost()) != null && !graph.contains(host)) {
                        graph.addElement(host);
                    }
                    if (!graph.contains(bundle2)) {
                        if (Debug.DEBUG_PACKAGEADMIN) {
                            Debug.println(" refresh: " + bundle2);
                        }
                        graph.addElement(bundle2);
                    }
                }
                ++i;
            }
        }
        if (graph.size() == 0) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages: Empty graph");
            }
            return graph;
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: Complete graph");
        }
        do {
            changed = false;
            int size = graph.size();
            int i = size - 1;
            while (i >= 0) {
                AbstractBundle[] sameNames;
                bundle = (AbstractBundle)graph.elementAt(i);
                if (!bundle.isFragment()) {
                    Bundle[] frags;
                    int j;
                    BundleLoaderProxy loaderProxy = ((BundleHost)bundle).getLoaderProxy();
                    if (loaderProxy != null) {
                        AbstractBundle[] dependents = loaderProxy.getDependentBundles();
                        j = 0;
                        while (j < dependents.length) {
                            if (!graph.contains(dependents[j])) {
                                graph.addElement(dependents[j]);
                                changed = true;
                            }
                            ++j;
                        }
                    }
                    if ((frags = bundle.getFragments()) != null) {
                        j = 0;
                        while (j < frags.length) {
                            if (!graph.contains(frags[j])) {
                                graph.addElement(frags[j]);
                                changed = true;
                            }
                            ++j;
                        }
                    }
                } else {
                    AbstractBundle host = (AbstractBundle)bundle.getHost();
                    if (host != null && !graph.contains(host)) {
                        graph.addElement(host);
                        changed = true;
                    }
                }
                if ((sameNames = this.framework.bundles.getBundles(bundle.getSymbolicName())) != null && sameNames.length > 1) {
                    int j = 0;
                    while (j < sameNames.length) {
                        if (sameNames[j] != bundle && sameNames[j].isSingleton() && !graph.contains(sameNames[j])) {
                            graph.addElement(sameNames[j]);
                            changed = true;
                        }
                        ++j;
                    }
                }
                --i;
            }
            i = this.removalPending.size() - 1;
            while (i >= 0) {
                BundleLoaderProxy removedLoaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                AbstractBundle removedBundle = removedLoaderProxy.getBundleHost();
                if (!graph.contains(removedBundle)) {
                    graph.addElement(removedBundle);
                    changed = true;
                    AbstractBundle[] dependents = removedLoaderProxy.getDependentBundles();
                    int k = 0;
                    while (k < dependents.length) {
                        if (!graph.contains(dependents[k])) {
                            graph.addElement(dependents[k]);
                        }
                        ++k;
                    }
                }
                --i;
            }
        } while (changed);
        return graph;
    }

    protected void setResolvedBundles() {
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        int i = 0;
        while (i < descriptions.length) {
            long bundleId = descriptions[i].getBundleId();
            AbstractBundle bundle = this.framework.getBundle(bundleId);
            if (bundle == null) {
                BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_FRAMEWORK", descriptions[i]));
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            }
            if (bundle != this.framework.systemBundle && descriptions[i].isResolved()) {
                if (bundle.isFragment()) {
                    BundleHost host = (BundleHost)this.framework.getBundle(descriptions[i].getHost().getSupplier().getBundleId());
                    if (((BundleFragment)bundle).setHost(host)) {
                        bundle.resolve(descriptions[i].isSingleton());
                    }
                } else {
                    bundle.resolve(descriptions[i].isSingleton());
                }
            }
            ++i;
        }
        this.exportedPackages = this.getExportedPackages(this.exportedPackages);
        this.exportedBundles = this.getExportedBundles(this.exportedBundles);
    }

    public boolean resolveBundles(Bundle[] bundles) {
        this.resolveBundles();
        if (bundles == null) {
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                List bundleList = this.framework.bundles.getBundles();
                bundles = bundleList.toArray(new AbstractBundle[bundleList.size()]);
            }
        }
        int i = 0;
        while (i < bundles.length) {
            if (!((AbstractBundle)bundles[i]).isResolved()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void resolveBundles() {
        long start = 0L;
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            start = System.currentTimeMillis();
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshBundles: resolve bundles");
        }
        Vector<AbstractBundle> notify = new Vector<AbstractBundle>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            boolean resolveNeeded = false;
            List allBundles = this.framework.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                if (!((AbstractBundle)allBundles.get(i)).isResolved()) {
                    resolveNeeded = true;
                }
                ++i;
            }
            if (!resolveNeeded) {
                return;
            }
            this.framework.adaptor.getState().resolve(false);
            i = 0;
            while (i < size) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                if (!bundle.isResolved() && bundle != this.framework.systemBundle) {
                    BundleDescription changedBundleDes = bundle.getBundleDescription();
                    if (changedBundleDes == null) {
                        this.framework.publishFrameworkEvent(2, bundle, new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_STATE", bundle.getLocation())));
                    }
                    if (changedBundleDes.isResolved()) {
                        if (bundle.isFragment()) {
                            BundleHost host = (BundleHost)this.framework.getBundle(changedBundleDes.getHost().getSupplier().getBundleId());
                            if (((BundleFragment)bundle).setHost(host)) {
                                bundle.resolve(changedBundleDes.isSingleton());
                            }
                        } else {
                            bundle.resolve(changedBundleDes.isSingleton());
                        }
                        if (bundle.isResolved()) {
                            notify.add(bundle);
                        }
                    }
                }
                ++i;
            }
            this.exportedPackages = this.getExportedPackages(this.exportedPackages);
            this.exportedBundles = this.getExportedBundles(this.exportedBundles);
        }
        int i = 0;
        while (i < notify.size()) {
            AbstractBundle bundle = (AbstractBundle)notify.elementAt(i);
            if (bundle != null) {
                this.framework.publishBundleEvent(bundle.isResolved() ? 32 : 64, bundle);
            }
            ++i;
        }
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            this.cumulativeTime = this.cumulativeTime + System.currentTimeMillis() - start;
            DebugOptions.getDefault().setOption("org.eclipse.osgi/debug/packageadmin/timing/value", Long.toString(this.cumulativeTime));
        }
    }

    protected void unexportResources(BundleLoaderProxy proxy) {
        KeyedElement[] bundles = this.exportedBundles.elements();
        int i = 0;
        while (i < bundles.length) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)bundles[i];
            if (loaderProxy == proxy) {
                this.exportedBundles.remove(proxy);
            }
            ++i;
        }
        KeyedElement[] packages = this.exportedPackages.elements();
        int i2 = 0;
        while (i2 < packages.length) {
            PackageSource source = (PackageSource)packages[i2];
            BundleLoaderProxy sourceProxy = source.getSupplier();
            if (sourceProxy == proxy) {
                this.exportedPackages.remove(source);
            }
            ++i2;
        }
        proxy.setStale();
    }

    protected BundleDescription[] getBundleDescriptions(Vector graph) {
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>();
        int size = graph.size();
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = (AbstractBundle)graph.elementAt(i);
            BundleDescription bundleDes = bundle.getBundleDescription();
            if (bundleDes != null) {
                result.add(bundleDes);
            }
            ++i;
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    public ProvidingBundle[] getProvidingBundles(String symbolicName) {
        if (this.exportedBundles == null || this.exportedBundles.size() == 0) {
            return null;
        }
        this.framework.bundles.markDependancies();
        KeyedElement[] allSymbolicBundles = this.exportedBundles.elements();
        if (symbolicName == null) {
            if (allSymbolicBundles.length == 0) {
                return null;
            }
            ProvidingBundle[] result = new ProvidingBundle[allSymbolicBundles.length];
            System.arraycopy(allSymbolicBundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<ProvidingBundle> result = new ArrayList<ProvidingBundle>();
        int i = 0;
        while (i < allSymbolicBundles.length) {
            ProvidingBundle symBundle = (ProvidingBundle)allSymbolicBundles[i];
            if (symBundle.getSymbolicName().equals(symbolicName)) {
                result.add(symBundle);
            }
            ++i;
        }
        return result.toArray(new ProvidingBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        int i = 0;
        while (i < bundles.length) {
            if (range.isIncluded(bundles[i].getVersion())) {
                result.add(bundles[i]);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        Bundle host = ((AbstractBundle)bundle).getHost();
        if (host == null) {
            return null;
        }
        return new Bundle[]{host};
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected Class loadServiceClass(String className, AbstractBundle bundle) {
        try {
            return this.framework.adaptor.getBundleClassLoaderParent().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class serviceClass;
            PackageSource exporter;
            String pkgname = BundleLoader.getPackageName(className);
            if (pkgname != null && (exporter = (PackageSource)this.exportedPackages.getByKey(pkgname)) != null && (serviceClass = exporter.getSupplier().getBundleLoader().findLocalClass(className)) != null) {
                return serviceClass;
            }
            if (bundle == null) {
                return null;
            }
            BundleLoader loader = bundle.getBundleLoader();
            if (!checkServiceClassSource) {
                try {
                    return loader.findClass(className);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    return null;
                }
            }
            if (restrictServiceClasses) {
                if (pkgname == null) {
                    pkgname = BundleLoader.DEFAULT_PACKAGE;
                }
                if (loader.getProvidedPackage(pkgname) != null) {
                    return null;
                }
            }
            if ((serviceClass = loader.findLocalClass(className)) == null || bundle.getBundleId() == 0L) {
                return serviceClass;
            }
            return serviceClass.getClassLoader() == loader.createClassLoader() ? serviceClass : null;
        }
    }
}

