/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;

public class TypedSource {
    private final String fSource;
    private final int fType;

    private TypedSource(String source, int type) {
        Assert.isNotNull(source);
        Assert.isTrue(TypedSource.canCreateForType(type));
        this.fSource = source;
        this.fType = type;
    }

    public static TypedSource create(String source, int type) {
        if (source == null || !TypedSource.canCreateForType(type)) {
            return null;
        }
        return new TypedSource(source, type);
    }

    public String getSource() {
        return this.fSource;
    }

    public int getType() {
        return this.fType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypedSource)) {
            return false;
        }
        TypedSource ts = (TypedSource)other;
        return ts.getSource().equals(this.getSource()) && ts.getType() == this.getType();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ 97 * this.getType();
    }

    private static boolean canCreateForType(int type) {
        return type == 8 || type == 7 || type == 12 || type == 13 || type == 10 || type == 9 || type == 11;
    }

    public static void sortByType(TypedSource[] typedSources) {
        Arrays.sort(typedSources, TypedSource.createTypeComparator());
    }

    public static Comparator createTypeComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((TypedSource)arg0).getType() - ((TypedSource)arg1).getType();
            }
        };
    }

    public static TypedSource[] createTypedSources(IJavaElement[] javaElements) throws CoreException {
        Map grouped = ReorgUtils.groupByCompilationUnit(Arrays.asList(javaElements));
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(javaElements.length);
        Iterator iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter.next();
            ASTParser p = ASTParser.newParser((int)2);
            p.setSource(cu);
            CompilationUnit cuNode = (CompilationUnit)p.createAST(null);
            Iterator iterator = ((List)grouped.get(cu)).iterator();
            while (iterator.hasNext()) {
                TypedSource[] ts = TypedSource.createTypedSources((IJavaElement)iterator.next(), cu, cuNode);
                if (ts == null) continue;
                result.addAll(Arrays.asList(ts));
            }
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static TypedSource[] createTypedSources(IJavaElement elem, ICompilationUnit cu, CompilationUnit cuNode) throws CoreException {
        if (!ReorgUtils.isInsideCompilationUnit(elem)) {
            return null;
        }
        if (elem.getElementType() == 12) {
            return TypedSource.createTypedSourcesForImportContainer(cu, cuNode, (IImportContainer)elem);
        }
        if (elem.getElementType() == 8) {
            return new TypedSource[]{TypedSource.create(TypedSource.getFieldSource((IField)elem, cu, cuNode), elem.getElementType())};
        }
        return new TypedSource[]{TypedSource.create(TypedSource.getSourceOfDeclararationNode(elem, cu, cuNode), elem.getElementType())};
    }

    private static TypedSource[] createTypedSourcesForImportContainer(ICompilationUnit cu, CompilationUnit cuNode, IImportContainer container) throws JavaModelException, CoreException {
        IJavaElement[] imports = container.getChildren();
        ArrayList<TypedSource> result = new ArrayList<TypedSource>(imports.length);
        int i = 0;
        while (i < imports.length) {
            result.addAll(Arrays.asList(TypedSource.createTypedSources(imports[i], cu, cuNode)));
            ++i;
        }
        return result.toArray(new TypedSource[result.size()]);
    }

    private static String getFieldSource(IField field, ICompilationUnit cu, CompilationUnit cuNode) throws CoreException {
        VariableDeclarationFragment declarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, cuNode);
        FieldDeclaration declaration = ASTNodeSearchUtil.getFieldDeclarationNode(field, cuNode);
        if (declaration.fragments().size() == 1) {
            return TypedSource.getSourceOfDeclararationNode((IJavaElement)field, cu, cuNode);
        }
        StringBuffer buff = new StringBuffer();
        IBuffer buffer = cu.getBuffer();
        int firstFragmentOffset = ((ASTNode)declaration.fragments().get(0)).getStartPosition();
        buff.append(buffer.getText(declaration.getStartPosition(), firstFragmentOffset - declaration.getStartPosition()));
        buff.append(buffer.getText(declarationFragment.getStartPosition(), declarationFragment.getLength()));
        buff.append(";");
        return buff.toString();
    }

    private static String getSourceOfDeclararationNode(IJavaElement elem, ICompilationUnit cu, CompilationUnit cuNode) throws JavaModelException, CoreException {
        Assert.isTrue(elem.getElementType() != 12);
        ASTNode[] nodes = ASTNodeSearchUtil.getDeclarationNodes(elem, cuNode);
        if (nodes != null && nodes.length == 1) {
            int length;
            ASTNode node = nodes[0];
            int start = cuNode.getExtendedStartPosition(node);
            if (start == -1) {
                start = node.getStartPosition();
            }
            if ((length = cuNode.getExtendedLength(node)) == 0) {
                length = node.getLength();
            }
            return TypedSource.trimIndent(cu.getBuffer().getText(start, length));
        }
        return "";
    }

    private static String trimIndent(String source) {
        return Strings.trimIndentation(source, CodeFormatterUtil.getTabWidth(), false);
    }
}

