/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.ltk.core.refactoring.Change;

abstract class ResourceReorgChange
extends JDTChange {
    private final IPath fResourcePath;
    private final boolean fIsFile;
    private final IPath fDestinationPath;
    private final boolean fIsDestinationProject;
    private final INewNameQuery fNewNameQuery;

    ResourceReorgChange(IResource res, IContainer dest, INewNameQuery nameQuery) {
        Assert.isTrue(res instanceof IFile || res instanceof IFolder);
        this.fIsFile = res instanceof IFile;
        this.fResourcePath = Utils.getResourcePath(res);
        Assert.isTrue(dest instanceof IProject || dest instanceof IFolder);
        this.fIsDestinationProject = dest instanceof IProject;
        this.fDestinationPath = Utils.getResourcePath((IResource)dest);
        this.fNewNameQuery = nameQuery;
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws CoreException;

    public final Change perform(IProgressMonitor pm) throws CoreException {
        String newName;
        block3: {
            Change change;
            try {
                pm.beginTask(this.getName(), 2);
                newName = this.getNewResourceName();
                boolean performReorg = this.deleteIfAlreadyExists((IProgressMonitor)new SubProgressMonitor(pm, 1), newName);
                if (performReorg) break block3;
                change = null;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return change;
        }
        Change change = this.doPerformReorg(this.getDestinationPath(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        Object var4_7 = null;
        pm.done();
        return change;
    }

    protected IPath getDestinationPath(String newName) {
        return this.getDestination().getFullPath().append(newName);
    }

    private boolean deleteIfAlreadyExists(IProgressMonitor pm, String newName) throws CoreException {
        pm.beginTask("", 1);
        IResource current = this.getDestination().findMember(newName);
        if (current == null) {
            return true;
        }
        if (!current.exists()) {
            return true;
        }
        IResource resource = this.getResource();
        Assert.isNotNull(resource);
        if (ReorgUtils.equalInWorkspaceOrOnDisk(resource, current)) {
            return false;
        }
        if (current instanceof IFile) {
            ((IFile)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else if (current instanceof IFolder) {
            ((IFolder)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            Assert.isTrue(false);
        }
        return true;
    }

    private String getNewResourceName() {
        if (this.fNewNameQuery == null) {
            return this.getResource().getName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getResource().getName();
        }
        return name;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    private IFile getFile() {
        return Utils.getFile(this.fResourcePath);
    }

    private IFolder getFolder() {
        return Utils.getFolder(this.fResourcePath);
    }

    protected IResource getResource() {
        if (this.fIsFile) {
            return this.getFile();
        }
        return this.getFolder();
    }

    IContainer getDestination() {
        if (this.fIsDestinationProject) {
            return Utils.getProject(this.fDestinationPath);
        }
        return Utils.getFolder(this.fDestinationPath);
    }

    protected int getReorgFlags() {
        return 34;
    }
}

