/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.JavaElementMapper;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineConstantRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private final CodeGenerationSettings fSettings;
    private boolean fReplaceAllReferences = true;
    private boolean fRemoveDeclaration = false;
    private CompilationUnit fCompilationUnitNode;
    private boolean fInitializerFound = false;
    private Expression fInitializer;
    private boolean fInitializerChecked = false;
    private boolean fInitializerAllStaticFinal;
    private InlineTargetCompilationUnit[] fTargetCompilationUnits;
    private boolean fDeclarationSelectedChecked = false;
    private boolean fDeclarationSelected;
    static /* synthetic */ Class class$0;

    private static SimpleName getLeftmost(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        return InlineConstantRefactoring.getLeftmost(((QualifiedName)name).getQualifier());
    }

    private InlineConstantRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(settings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fSettings = settings;
    }

    public static boolean isAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field);
    }

    public static InlineConstantRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        InlineConstantRefactoring ref = new InlineConstantRefactoring(cu, selectionStart, selectionLength, settings);
        if (ref.checkStaticFinalConstantNameSelected().hasFatalError()) {
            return null;
        }
        return ref;
    }

    public void setReplaceAllReferences(boolean replaceAllReferences) {
        this.fReplaceAllReferences = replaceAllReferences;
        this.checkInvariant();
    }

    public boolean getReplaceAllReferences() {
        this.checkInvariant();
        return this.fReplaceAllReferences;
    }

    public void setRemoveDeclaration(boolean removeDeclaration) {
        this.fRemoveDeclaration = removeDeclaration;
        this.checkInvariant();
    }

    public boolean getRemoveDeclaration() {
        this.checkInvariant();
        return this.fRemoveDeclaration;
    }

    private void checkInvariant() {
        if (this.isDeclarationSelected()) {
            Assert.isTrue(this.fReplaceAllReferences);
        }
        if (this.fRemoveDeclaration) {
            Assert.isTrue(this.fReplaceAllReferences);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 4);
                if (this.fCu.isStructureKnown()) break block3;
                refactoringStatus = RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InlineConstantRefactoring.syntax_errors"), null, (String)Corext.getPluginId(), (int)129, null);
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        pm.worked(1);
        RefactoringStatus refactoringStatus = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 2));
        Object var2_5 = null;
        pm.done();
        return refactoringStatus;
    }

    private void initializeAST() {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true);
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block9: {
            block8: {
                block7: {
                    block6: {
                        RefactoringStatus refactoringStatus;
                        try {
                            result = this.checkStaticFinalConstantNameSelected();
                            if (!result.hasFatalError()) break block6;
                            refactoringStatus = result;
                            Object var3_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_13 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    pm.worked(1);
                    if (this.getField() != null) break block7;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InlineConstantRefactoring.local_anonymous_unsupported"), null, (String)Corext.getPluginId(), (int)132, null);
                    Object var3_9 = null;
                    pm.done();
                    return refactoringStatus;
                }
                this.checkDeclarationSelected();
                result.merge(this.findInitializer());
                if (!result.hasFatalError()) break block8;
                RefactoringStatus refactoringStatus = result;
                Object var3_10 = null;
                pm.done();
                return refactoringStatus;
            }
            result.merge(this.checkInitializer());
            if (!result.hasFatalError()) break block9;
            RefactoringStatus refactoringStatus = result;
            Object var3_11 = null;
            pm.done();
            return refactoringStatus;
        }
        pm.worked(1);
        RefactoringStatus refactoringStatus = result;
        Object var3_12 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkStaticFinalConstantNameSelected() {
        this.initializeAST();
        if (this.getConstantNameNode() == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InlineConstantRefactoring.static_final_field"), null, (String)Corext.getPluginId(), (int)128, null);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkInitializer() {
        Expression initializer = this.getInitializer();
        if (initializer == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InlineConstantRefactoring.blank_finals"), null, (String)Corext.getPluginId(), (int)131, null);
        }
        this.fInitializerAllStaticFinal = ConstantChecks.isStaticFinalConstant((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)initializer));
        this.fInitializerChecked = true;
        return new RefactoringStatus();
    }

    private Name getConstantNameNode() {
        ASTNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        if (node instanceof FieldAccess) {
            node = ((FieldAccess)node).getName();
        }
        if (!(node instanceof Name)) {
            return null;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return null;
        }
        if (!((IVariableBinding)binding).isField()) {
            return null;
        }
        int modifiers = binding.getModifiers();
        if (!Modifier.isStatic((int)modifiers) || !Modifier.isFinal((int)modifiers)) {
            return null;
        }
        return name;
    }

    private ASTNode getSelectedNode() {
        return NodeFinder.perform((ASTNode)this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
    }

    private IField getField() throws JavaModelException {
        Assert.isNotNull(this.getConstantNameNode());
        IField result = Bindings.findField((IVariableBinding)this.getConstantNameNode().resolveBinding(), this.fCu.getJavaProject());
        if (result != null && !result.exists()) {
            return null;
        }
        return result;
    }

    private RefactoringStatus findInitializer() throws JavaModelException {
        VariableDeclarationFragment declaration = this.getDeclaration();
        if (declaration == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("InlineConstantRefactoring.binary_file"), null, (String)Corext.getPluginId(), (int)130, null);
        }
        this.fInitializer = declaration.getInitializer();
        this.fInitializerFound = true;
        return new RefactoringStatus();
    }

    private Expression getInitializer() {
        Assert.isTrue(this.fInitializerFound);
        return this.fInitializer;
    }

    private VariableDeclarationFragment getDeclaration() throws JavaModelException {
        Assert.isNotNull(this.getConstantNameNode());
        if (this.isDeclarationSelected()) {
            VariableDeclarationFragment result = this.getParentDeclaration();
            Assert.isNotNull(result);
            return result;
        }
        VariableDeclarationFragment result = (VariableDeclarationFragment)this.fCompilationUnitNode.findDeclaringNode(this.getConstantNameNode().resolveBinding());
        if (result != null) {
            return result;
        }
        if (this.getDeclaringCompilationUnit() == null) {
            return null;
        }
        IField field = this.getField();
        Assert.isNotNull(field);
        Assert.isTrue(field.exists());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result = (VariableDeclarationFragment)JavaElementMapper.perform((IMember)field, clazz);
        Assert.isNotNull(result);
        return result;
    }

    private ICompilationUnit getDeclaringCompilationUnit() throws JavaModelException {
        IField field = this.getField();
        Assert.isNotNull(field);
        Assert.isTrue(field.exists());
        return field.getCompilationUnit();
    }

    private void checkDeclarationSelected() {
        Assert.isNotNull(this.getConstantNameNode());
        this.fDeclarationSelected = false;
        VariableDeclarationFragment parentDeclaration = this.getParentDeclaration();
        if (parentDeclaration != null && parentDeclaration.getName() == this.getConstantNameNode()) {
            this.fDeclarationSelected = true;
        }
        this.fDeclarationSelectedChecked = true;
    }

    public boolean isDeclarationSelected() {
        Assert.isTrue(this.fDeclarationSelectedChecked);
        return this.fDeclarationSelected;
    }

    private VariableDeclarationFragment getParentDeclaration() {
        Assert.isNotNull(this.getConstantNameNode());
        ASTNode parent = this.getConstantNameNode().getParent();
        if (parent instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)parent;
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fTargetCompilationUnits = InlineTargetCompilationUnit.prepareTargets(this, pm, result);
        int i = 0;
        while (i < this.fTargetCompilationUnits.length) {
            this.fTargetCompilationUnits[i].checkReferences(result);
            ++i;
        }
        if (result.hasFatalError()) {
            return result;
        }
        ICompilationUnit[] cus = new ICompilationUnit[this.fTargetCompilationUnits.length + 1];
        int i2 = 0;
        while (i2 < this.fTargetCompilationUnits.length) {
            cus[i2] = this.fTargetCompilationUnits[i2].fUnit;
            ++i2;
        }
        cus[cus.length - 1] = this.fCu;
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(cus), this.getValidationContext()));
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("InlineConstantRefactoring.preview"), 2);
            CompilationUnitChange[] cuChanges = this.createCompilationUnitChanges(pm);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("InlineConstantRefactoring.inline"));
            result.addAll((Change[])cuChanges);
            dynamicValidationStateChange = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    private CompilationUnitChange[] createCompilationUnitChanges(IProgressMonitor pm) throws JavaModelException, CoreException {
        ArrayList changes = new ArrayList();
        this.addReplaceReferencesWithExpression(changes);
        pm.worked(1);
        this.addRemoveConstantDeclarationIfNecessary(changes);
        pm.worked(1);
        return changes.toArray(new CompilationUnitChange[changes.size()]);
    }

    private void addRemoveConstantDeclarationIfNecessary(List changes) throws CoreException {
        TextEdit edit = this.getRemoveConstantDeclarationEdit();
        if (edit == null) {
            return;
        }
        TextChange change = this.findOrAddDeclaringCUChange(changes);
        TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("InlineConstantRefactoring.remove_declaration"), edit);
    }

    private TextChange findOrAddDeclaringCUChange(List changes) throws JavaModelException, CoreException {
        ICompilationUnit declaringCU = this.getDeclaringCompilationUnit();
        Assert.isNotNull(declaringCU);
        Assert.isTrue(declaringCU.exists());
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            CompilationUnitChange change = (CompilationUnitChange)((Object)it.next());
            if (!change.getCompilationUnit().equals(declaringCU)) continue;
            return change;
        }
        CompilationUnitChange newChange = new CompilationUnitChange(declaringCU.getElementName(), declaringCU);
        changes.add(newChange);
        return newChange;
    }

    private TextEdit getRemoveConstantDeclarationEdit() throws JavaModelException {
        if (!this.getRemoveDeclaration()) {
            return null;
        }
        ASTNode toRemove = this.getNodeToRemoveForConstantDeclarationRemoval();
        Assert.isNotNull(toRemove);
        OldASTRewrite rewrite = new OldASTRewrite(toRemove.getRoot());
        rewrite.remove(toRemove, null);
        MultiTextEdit edit = new MultiTextEdit();
        TextBuffer textBuffer = TextBuffer.create(this.getDeclaringCompilationUnit().getBuffer().getContents());
        rewrite.rewriteNode(textBuffer, (TextEdit)edit);
        rewrite.removeModifications();
        return edit;
    }

    private ASTNode getNodeToRemoveForConstantDeclarationRemoval() throws JavaModelException {
        VariableDeclarationFragment declaration = this.getDeclaration();
        Assert.isNotNull(declaration);
        ASTNode parent = declaration.getParent();
        Assert.isTrue(parent instanceof FieldDeclaration);
        FieldDeclaration parentDeclaration = (FieldDeclaration)parent;
        if (parentDeclaration.fragments().size() == 1) {
            return parentDeclaration;
        }
        return declaration;
    }

    private void addReplaceReferencesWithExpression(List changes) throws JavaModelException, CoreException {
        int i = 0;
        while (i < this.fTargetCompilationUnits.length) {
            changes.add(this.fTargetCompilationUnits[i].getChange());
            ++i;
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("InlineConstantRefactoring.name");
    }

    public boolean isInitializerAllStaticFinal() {
        Assert.isTrue(this.fInitializerChecked);
        return this.fInitializerAllStaticFinal;
    }

    private ICompilationUnit getSelectionCompilationUnit() {
        return this.fCu;
    }

    private CodeGenerationSettings getCodeGenSettings() {
        return this.fSettings;
    }

    private static class InlineTargetCompilationUnit {
        private final ICompilationUnit fUnit;
        private final Expression[] fReferences;
        private final Expression fInitializer;
        private final ICompilationUnit fInitializerUnit;
        private List fInlineEdits;
        private ImportRewrite fImportRewrite;
        private RefactoringStatus fEditProblems;
        private boolean fSomeReferencesCannotBeInlined;

        public static InlineTargetCompilationUnit[] prepareTargets(InlineConstantRefactoring refactoring, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException, CoreException {
            Assert.isNotNull((Object)refactoring);
            Assert.isNotNull(pm);
            InlineTargetCompilationUnit[] results = InlineTargetCompilationUnit.prepareTargetsUnchecked(refactoring, pm, status);
            return results;
        }

        private static InlineTargetCompilationUnit[] prepareTargetsUnchecked(InlineConstantRefactoring refactoring, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            if (refactoring.getReplaceAllReferences()) {
                return InlineTargetCompilationUnit.findTargetsForAllReferences(refactoring, pm, status);
            }
            return new InlineTargetCompilationUnit[]{InlineTargetCompilationUnit.getTargetForOnlySelectedReference(refactoring)};
        }

        private static InlineTargetCompilationUnit[] findTargetsForAllReferences(InlineConstantRefactoring refactoring, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            IField field = refactoring.getField();
            Assert.isNotNull(field);
            SearchResultGroup[] searchResultGroups = InlineTargetCompilationUnit.search(field, pm, status);
            InlineTargetCompilationUnit[] result = new InlineTargetCompilationUnit[searchResultGroups.length];
            int i = 0;
            while (i < searchResultGroups.length) {
                result[i] = new InlineTargetCompilationUnit(searchResultGroups[i], refactoring.getInitializer(), refactoring.getDeclaringCompilationUnit(), refactoring.getCodeGenSettings());
                ++i;
            }
            return result;
        }

        private static InlineTargetCompilationUnit getTargetForOnlySelectedReference(InlineConstantRefactoring refactoring) throws JavaModelException {
            Assert.isTrue(!refactoring.isDeclarationSelected());
            return new InlineTargetCompilationUnit(refactoring.getSelectionCompilationUnit(), refactoring.getConstantNameNode(), refactoring.getInitializer(), refactoring.getDeclaringCompilationUnit(), refactoring.getCodeGenSettings());
        }

        private static SearchResultGroup[] search(IField field, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            Assert.isNotNull(pm);
            Assert.isNotNull(field);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)field);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)field, (int)2);
            return RefactoringSearchEngine.search(pattern, scope, pm, status);
        }

        InlineTargetCompilationUnit(SearchResultGroup group, Expression initializer, ICompilationUnit initializerUnit, CodeGenerationSettings codeGenSettings) {
            this(group.getCompilationUnit(), group.getSearchResults(), initializer, initializerUnit, codeGenSettings);
        }

        InlineTargetCompilationUnit(ICompilationUnit cu, Name singleReference, Expression initializer, ICompilationUnit initializerUnit, CodeGenerationSettings codeGenSettings) {
            Assert.isNotNull(initializer);
            Assert.isNotNull(singleReference);
            Assert.isNotNull(cu);
            Assert.isTrue(cu.exists());
            Assert.isNotNull(initializerUnit);
            Assert.isTrue(initializerUnit.exists());
            Assert.isNotNull(codeGenSettings);
            this.fReferences = new Expression[]{InlineTargetCompilationUnit.getQualifiedReference(singleReference)};
            this.fUnit = cu;
            this.fInitializer = initializer;
            this.fInitializerUnit = initializerUnit;
        }

        InlineTargetCompilationUnit(ICompilationUnit cu, SearchMatch[] references, Expression initializer, ICompilationUnit initializerUnit, CodeGenerationSettings codeGenSettings) {
            Assert.isNotNull(initializer);
            Assert.isNotNull(references);
            Assert.isTrue(references.length > 0);
            Assert.isNotNull(cu);
            Assert.isTrue(cu.exists());
            Assert.isNotNull(codeGenSettings);
            this.fUnit = cu;
            this.fInitializer = initializer;
            this.fInitializerUnit = initializerUnit;
            this.fReferences = new Expression[references.length];
            CompilationUnit cuNode = new RefactoringASTParser(2).parse(cu, true);
            int i = 0;
            while (i < references.length) {
                ASTNode node = NodeFinder.perform((ASTNode)cuNode, references[i].getOffset(), references[i].getLength());
                Assert.isTrue(node instanceof Name);
                this.fReferences[i] = InlineTargetCompilationUnit.getQualifiedReference((Name)node);
                ++i;
            }
        }

        private static Expression getQualifiedReference(Name fieldName) {
            if (InlineTargetCompilationUnit.doesParentQualify(fieldName)) {
                return (Expression)fieldName.getParent();
            }
            return fieldName;
        }

        private static boolean doesParentQualify(Name fieldName) {
            ASTNode parent = fieldName.getParent();
            Assert.isNotNull(parent);
            if (parent instanceof FieldAccess && ((FieldAccess)parent).getName() == fieldName) {
                return true;
            }
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName() == fieldName) {
                return true;
            }
            return parent instanceof MethodInvocation && ((MethodInvocation)parent).getName() == fieldName;
        }

        public TextEdit[] getEdits(RefactoringStatus status) throws CoreException {
            if (this.fInlineEdits != null) {
                Assert.isNotNull(this.fImportRewrite);
                Assert.isNotNull(this.fEditProblems);
                status.merge(this.fEditProblems);
                return this.getAllEditsAsArray();
            }
            this.fInlineEdits = new ArrayList();
            this.fImportRewrite = new ImportRewrite(this.fUnit);
            this.fEditProblems = new RefactoringStatus();
            if (this.fUnit.getSource() == null) {
                String[] keys = new String[]{this.fUnit.getElementName()};
                String msg = RefactoringCoreMessages.getFormattedString("InlineConstantRefactoring.source_code_unavailable", keys);
                this.fEditProblems.merge(RefactoringStatus.createStatus((int)1, (String)msg, null, (String)Corext.getPluginId(), (int)133, null));
            } else {
                int i = 0;
                while (i < this.fReferences.length) {
                    this.addEditsToInline(this.fReferences[i]);
                    ++i;
                }
            }
            status.merge(this.fEditProblems);
            return this.getAllEditsAsArray();
        }

        private TextEdit[] getAllEditsAsArray() throws CoreException {
            List allEdits = this.getAllEdits();
            return allEdits.toArray(new TextEdit[allEdits.size()]);
        }

        private List getAllEdits() throws CoreException {
            ArrayList<TextEdit> allEdits = new ArrayList<TextEdit>(this.fInlineEdits);
            if (!this.fImportRewrite.isEmpty()) {
                allEdits.add(this.fImportRewrite.createEdit((IDocument)new Document(this.fImportRewrite.getCompilationUnit().getBuffer().getContents())));
            }
            return allEdits;
        }

        public TextEdit[] getEdits() throws CoreException {
            return this.getEdits(new RefactoringStatus());
        }

        public TextChange getChange() throws CoreException {
            return this.getChange(new RefactoringStatus());
        }

        public TextChange getChange(RefactoringStatus status) throws CoreException {
            CompilationUnitChange change = new CompilationUnitChange(this.fUnit.getElementName(), this.fUnit);
            TextEdit[] edits = this.getEdits(status);
            int i = 0;
            while (i < edits.length) {
                TextChangeCompatibility.addTextEdit((TextChange)change, RefactoringCoreMessages.getString("InlineConstantRefactoring.Inline"), edits[i]);
                ++i;
            }
            return change;
        }

        private void addEditsToInline(Expression reference) throws JavaModelException {
            HashSet newTypes = new HashSet();
            String modifiedInitializer = this.prepareInitializerFor(reference, newTypes, this.fEditProblems);
            if (modifiedInitializer == null) {
                return;
            }
            this.fInlineEdits.add(this.createSubstituteStringForExpressionEdit(modifiedInitializer, reference));
            this.addImportsForTypesInOriginalInitializer();
            this.addImportsForNewTypes(newTypes);
        }

        private void addImportsForTypesInOriginalInitializer() {
            ITypeBinding[] types = TypeReferenceFinder.getReferencedTopLevelTypes((ASTNode)this.fInitializer);
            int i = 0;
            while (i < types.length) {
                this.addImportForType(types[i]);
                ++i;
            }
        }

        private void addImportsForNewTypes(Set newTypes) {
            Iterator it = newTypes.iterator();
            while (it.hasNext()) {
                this.addImportForType((ITypeBinding)it.next());
            }
        }

        private void addImportForType(ITypeBinding type) {
            this.fImportRewrite.addImport(type.getQualifiedName());
        }

        private String prepareInitializerFor(Expression reference, Set newTypes, RefactoringStatus status) throws JavaModelException {
            return InitializerExpressionRelocationPreparer.prepareInitializerForLocation(this.fInitializer, this.fInitializerUnit, reference, this.fUnit, newTypes, status);
        }

        private TextEdit createSubstituteStringForExpressionEdit(String string, Expression expression) throws JavaModelException {
            OldASTRewrite rewrite = new OldASTRewrite(expression.getRoot());
            rewrite.replace((ASTNode)expression, rewrite.createStringPlaceholder(string, expression.getNodeType()), null);
            MultiTextEdit edit = new MultiTextEdit();
            TextBuffer textBuffer = TextBuffer.create(this.fUnit.getBuffer().getContents());
            rewrite.rewriteNode(textBuffer, (TextEdit)edit);
            rewrite.removeModifications();
            return edit;
        }

        public boolean checkReferences(RefactoringStatus result) throws CoreException {
            Assert.isNotNull(result);
            this.getEdits(result);
            return this.fSomeReferencesCannotBeInlined;
        }

        private static abstract class StringEdit {
            StringEdit() {
            }

            public abstract String applyTo(String var1);
        }

        private static class StringInsertion
        extends StringEdit
        implements Comparable {
            private final int fOffset;
            private final String fToInsert;

            public StringInsertion(int offset, String toInsert) {
                this.fOffset = offset;
                this.fToInsert = toInsert;
            }

            public String applyTo(String target) {
                return String.valueOf(target.substring(0, this.fOffset)) + this.fToInsert + target.substring(this.fOffset);
            }

            public int compareTo(Object other) {
                Assert.isTrue(other instanceof StringInsertion);
                StringInsertion otherInsertion = (StringInsertion)other;
                if (this.fOffset < otherInsertion.fOffset) {
                    return -1;
                }
                if (this.fOffset == otherInsertion.fOffset) {
                    return 0;
                }
                Assert.isTrue(this.fOffset > otherInsertion.fOffset);
                return 1;
            }
        }

        private static class MultiInsertionStringEdit
        extends StringEdit {
            private final StringInsertion[] fOrderedInsertions;

            public MultiInsertionStringEdit(StringInsertion[] insertions) {
                this.orderInsertions(insertions);
                this.checkInsertions(insertions);
                this.fOrderedInsertions = insertions;
            }

            private StringInsertion[] orderInsertions(StringInsertion[] insertions) {
                Arrays.sort(insertions);
                return insertions;
            }

            private void checkInsertions(StringInsertion[] insertions) {
                int i = 1;
                while (i < insertions.length) {
                    StringInsertion one = insertions[i - 1];
                    StringInsertion other = insertions[i];
                    Assert.isTrue(one.compareTo(other) != 0);
                    ++i;
                }
            }

            public String applyTo(String target) {
                String result = target;
                int i = this.fOrderedInsertions.length - 1;
                while (i >= 0) {
                    result = this.fOrderedInsertions[i].applyTo(result);
                    --i;
                }
                return result;
            }
        }

        private static interface IntegerMapping {
            public int map(int var1);
        }

        private static class ClassQualification
        extends StringInsertion {
            private final ITypeBinding fQualifyingClass;

            public static ClassQualification create(SimpleName toQualify, IntegerMapping nodeToTargetPositionMap) throws ClassQualificationCannotBePerformed {
                ITypeBinding declaringClass = ClassQualification.getDeclaringClassBinding(toQualify);
                String declaringClassName = ClassQualification.getDeclaringClassName(toQualify);
                if (declaringClassName == null) {
                    return null;
                }
                return new ClassQualification(declaringClassName, nodeToTargetPositionMap.map(toQualify.getStartPosition()), declaringClass);
            }

            private static String getDeclaringClassName(SimpleName memberName) throws ClassQualificationCannotBePerformed {
                ITypeBinding declaring = ClassQualification.getDeclaringClassBinding(memberName);
                if (declaring == null) {
                    return null;
                }
                return ClassQualification.getClassNameQualifiedToTopLevel(declaring);
            }

            private static ITypeBinding getDeclaringClassBinding(SimpleName memberName) {
                IBinding binding = memberName.resolveBinding();
                if (binding instanceof IMethodBinding) {
                    return ((IMethodBinding)binding).getDeclaringClass();
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).getDeclaringClass();
                }
                if (binding instanceof ITypeBinding) {
                    return ((ITypeBinding)binding).getDeclaringClass();
                }
                Assert.isTrue(false);
                return null;
            }

            private static String getClassNameQualifiedToTopLevel(ITypeBinding clazz) throws ClassQualificationCannotBePerformed {
                if (clazz.isAnonymous()) {
                    throw new ClassQualificationCannotBePerformed(RefactoringCoreMessages.getString("InlineConstantRefactoring.members_declared_in_anonymous"));
                }
                ITypeBinding declaring = clazz.getDeclaringClass();
                String qualifier = declaring == null ? "" : String.valueOf(ClassQualification.getClassNameQualifiedToTopLevel(declaring)) + ".";
                return String.valueOf(qualifier) + clazz.getName();
            }

            ClassQualification(String qualifier, int insertionPosition, ITypeBinding qualifyingClass) {
                super(insertionPosition, String.valueOf(qualifier) + ".");
                this.fQualifyingClass = qualifyingClass;
            }

            public ITypeBinding getQualifyingClass() {
                return this.fQualifyingClass;
            }

            public static class ClassQualificationCannotBePerformed
            extends Exception {
                public ClassQualificationCannotBePerformed(String message) {
                    super(message);
                }

                public void fillInStatus(RefactoringStatus status, RefactoringStatusContext context) {
                    status.addInfo(this.getMessage(), context);
                }
            }
        }

        private static class InitializerExpressionRelocationPreparer {
            private final Expression fInitializer2;
            private final ICompilationUnit fInitializerCU;
            private final Expression fLocation;
            private final ICompilationUnit fLocationCU;
            private final Set fNewTypes;
            private final RefactoringStatus fStatus;

            public static String prepareInitializerForLocation(Expression initializer, ICompilationUnit initializerCU, Expression location, ICompilationUnit locationCU, Set newTypes, RefactoringStatus status) throws JavaModelException {
                return new InitializerExpressionRelocationPreparer(initializer, initializerCU, location, locationCU, newTypes, status).prepareInitializer();
            }

            InitializerExpressionRelocationPreparer(Expression initializer, ICompilationUnit initializerCU, Expression location, ICompilationUnit locationCU, Set newTypes, RefactoringStatus status) {
                this.fInitializer2 = initializer;
                this.fInitializerCU = initializerCU;
                this.fLocation = location;
                this.fLocationCU = locationCU;
                this.fNewTypes = newTypes;
                this.fStatus = status;
            }

            private String prepareInitializer() throws JavaModelException {
                InitializerTraversal traversal = new InitializerTraversal(this.fInitializer2, this.fLocation, this.fLocationCU, this.fStatus);
                if (!traversal.canInitializerBePrepared()) {
                    return null;
                }
                StringInsertion[] qualifications = traversal.getQualifications();
                int i = 0;
                while (i < qualifications.length) {
                    this.fNewTypes.add(((ClassQualification)qualifications[i]).getQualifyingClass());
                    ++i;
                }
                String result = new MultiInsertionStringEdit(qualifications).applyTo(this.getOriginalInitializerString());
                if (this.shouldParenthesize()) {
                    result = InitializerExpressionRelocationPreparer.parenthesize(result);
                }
                return result;
            }

            private boolean shouldParenthesize() {
                return InitializerExpressionRelocationPreparer.shouldParenthesizeSubstitute(this.fInitializer2, this.fLocation);
            }

            private static boolean shouldParenthesizeSubstitute(Expression substitute, Expression location) {
                if (substitute instanceof Assignment) {
                    return true;
                }
                return ASTNodes.substituteMustBeParenthesized(substitute, location);
            }

            private static String parenthesize(String string) {
                return "(" + string + ")";
            }

            private String getOriginalInitializerString() throws JavaModelException {
                return this.fInitializerCU.getBuffer().getText(this.fInitializer2.getStartPosition(), this.fInitializer2.getLength());
            }

            private static class InitializerTraversal
            extends HierarchicalASTVisitor {
                private final RefactoringStatus fStatus2;
                private final Expression fNewLocation;
                private final ICompilationUnit fNewLocationCU;
                private final Expression fInitializer3;
                private List fQualifications = new ArrayList();
                private boolean fCanBePrepared = true;
                private Set fNamesDeclaredLocallyAtNewLocation;
                static /* synthetic */ Class class$0;

                public InitializerTraversal(Expression initializer, Expression newLocation, ICompilationUnit newLocationCU, RefactoringStatus status) {
                    this.fStatus2 = status;
                    this.fInitializer3 = initializer;
                    this.fNewLocation = newLocation;
                    this.fNewLocationCU = newLocationCU;
                    this.perform(initializer);
                }

                private void perform(Expression initializer) {
                    initializer.accept((ASTVisitor)this);
                }

                public ClassQualification[] getQualifications() {
                    return this.fQualifications.toArray(new ClassQualification[this.fQualifications.size()]);
                }

                public boolean canInitializerBePrepared() {
                    return this.fCanBePrepared;
                }

                private static void checkMemberAcceptable(SimpleName memberName) {
                    IBinding binding = memberName.resolveBinding();
                    Assert.isTrue(binding instanceof IVariableBinding || binding instanceof IMethodBinding || binding instanceof ITypeBinding);
                    if (binding instanceof ITypeBinding) {
                        return;
                    }
                    if (binding instanceof IVariableBinding) {
                        Assert.isTrue(((IVariableBinding)binding).isField());
                    }
                    int modifiers = binding.getModifiers();
                    Assert.isTrue(Modifier.isStatic((int)modifiers), "Relocation of non-static initializer expressions is not currently supported");
                }

                private void qualifyMemberName(SimpleName memberName) {
                    InitializerTraversal.checkMemberAcceptable(memberName);
                    this.qualifyToTopLevelClass(memberName);
                }

                private void qualifyUnqualifiedMemberNameIfNecessary(SimpleName memberName) {
                    if (this.shouldQualify(memberName)) {
                        this.qualifyMemberName(memberName);
                    }
                }

                private boolean shouldQualify(SimpleName memberName) {
                    if (!InitializerTraversal.areInSameClassOrInterface((ASTNode)this.fInitializer3, (ASTNode)this.fNewLocation)) {
                        return true;
                    }
                    return this.mayBeShadowedByLocalDeclaration(memberName);
                }

                private static boolean areInSameClassOrInterface(ASTNode one, ASTNode other) {
                    ASTNode onesContainer = InitializerTraversal.getContainingClassOrInterfaceDeclaration(one);
                    ASTNode othersContainer = InitializerTraversal.getContainingClassOrInterfaceDeclaration(other);
                    if (onesContainer == null || othersContainer == null) {
                        return false;
                    }
                    ITypeBinding onesContainerBinding = InitializerTraversal.getTypeBindingForClassOrInterfaceDeclaration(onesContainer);
                    ITypeBinding othersContainerBinding = InitializerTraversal.getTypeBindingForClassOrInterfaceDeclaration(othersContainer);
                    Assert.isNotNull(onesContainerBinding);
                    Assert.isNotNull(othersContainerBinding);
                    String onesKey = onesContainerBinding.getKey();
                    String othersKey = othersContainerBinding.getKey();
                    if (onesKey == null || othersKey == null) {
                        return false;
                    }
                    return onesKey.equals(othersKey);
                }

                private static ITypeBinding getTypeBindingForClassOrInterfaceDeclaration(ASTNode declaration) {
                    if (declaration instanceof AnonymousClassDeclaration) {
                        return ((AnonymousClassDeclaration)declaration).resolveBinding();
                    }
                    if (declaration instanceof TypeDeclaration) {
                        return ((TypeDeclaration)declaration).resolveBinding();
                    }
                    Assert.isTrue(false);
                    return null;
                }

                private static ASTNode getContainingClassOrInterfaceDeclaration(ASTNode node) {
                    while (node != null && !(node instanceof TypeDeclaration) && !(node instanceof AnonymousClassDeclaration)) {
                        node = node.getParent();
                    }
                    return node;
                }

                private boolean mayBeShadowedByLocalDeclaration(SimpleName memberName) {
                    return this.getNamesDeclaredLocallyAtNewLocation().contains(memberName.getIdentifier());
                }

                private Set getNamesDeclaredLocallyAtNewLocation() {
                    BodyDeclaration enclosingBodyDecl;
                    if (this.fNamesDeclaredLocallyAtNewLocation != null) {
                        return this.fNamesDeclaredLocallyAtNewLocation;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Assert.isTrue(!((enclosingBodyDecl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fNewLocation, clazz)) instanceof TypeDeclaration));
                    this.fNamesDeclaredLocallyAtNewLocation = this.getLocallyDeclaredNames(enclosingBodyDecl);
                    return this.fNamesDeclaredLocallyAtNewLocation;
                }

                private Set getLocallyDeclaredNames(BodyDeclaration scope) {
                    Assert.isTrue(!(scope instanceof TypeDeclaration));
                    HashSet result = new HashSet();
                    if (scope instanceof FieldDeclaration) {
                        return result;
                    }
                    scope.accept((ASTVisitor)new HierarchicalASTVisitor(this, result){
                        final /* synthetic */ InitializerTraversal this$3;
                        private final /* synthetic */ Set val$result;
                        {
                            this.this$3 = initializerTraversal;
                            this.val$result = set;
                        }

                        public boolean visit(VariableDeclaration varDecl) {
                            this.val$result.add(varDecl.getName().getIdentifier());
                            return false;
                        }

                        public boolean visit(TypeDeclaration typeDecl) {
                            Assert.isTrue(typeDecl.getParent() instanceof TypeDeclarationStatement);
                            this.val$result.add(typeDecl.getName().getIdentifier());
                            return false;
                        }

                        public boolean visit(AnonymousClassDeclaration anonDecl) {
                            return false;
                        }
                    });
                    return result;
                }

                private void qualifyToTopLevelClass(SimpleName name) {
                    try {
                        ClassQualification qualification = ClassQualification.create(name, new IntegerMapping(this){
                            final /* synthetic */ InitializerTraversal this$3;
                            {
                                this.this$3 = initializerTraversal;
                            }

                            public int map(int position) {
                                return position - InitializerTraversal.access$0(this.this$3).getStartPosition();
                            }
                        });
                        if (qualification != null) {
                            this.fQualifications.add(qualification);
                        }
                    }
                    catch (ClassQualification.ClassQualificationCannotBePerformed e) {
                        e.fillInStatus(this.fStatus2, JavaStatusContext.create(this.fNewLocationCU, (ASTNode)this.fNewLocation));
                        this.fCanBePrepared = false;
                    }
                }

                public boolean visit(ASTNode node) {
                    return this.fCanBePrepared;
                }

                public boolean visit(FieldAccess fieldAccess) {
                    fieldAccess.getExpression().accept((ASTVisitor)this);
                    return false;
                }

                public boolean visit(MethodInvocation invocation) {
                    if (invocation.getExpression() == null) {
                        this.qualifyUnqualifiedMemberNameIfNecessary(invocation.getName());
                    } else {
                        invocation.getExpression().accept((ASTVisitor)this);
                    }
                    Iterator it = invocation.arguments().iterator();
                    while (it.hasNext()) {
                        ((Expression)it.next()).accept((ASTVisitor)this);
                    }
                    return false;
                }

                public boolean visit(Name name) {
                    SimpleName leftmost = InlineConstantRefactoring.getLeftmost(name);
                    IBinding leftmostBinding = leftmost.resolveBinding();
                    if (leftmostBinding instanceof IVariableBinding || leftmostBinding instanceof IMethodBinding || leftmostBinding instanceof ITypeBinding) {
                        this.qualifyUnqualifiedMemberNameIfNecessary(leftmost);
                    }
                    return false;
                }

                static /* synthetic */ Expression access$0(InitializerTraversal initializerTraversal) {
                    return initializerTraversal.fInitializer3;
                }
            }
        }

        private static class TypeReferenceFinder
        extends HierarchicalASTVisitor {
            private List fTypes;

            TypeReferenceFinder() {
            }

            public static ITypeBinding[] getReferencedTopLevelTypes(ASTNode tree) {
                return new TypeReferenceFinder().getTopLevelTypesReferenced(tree);
            }

            private ITypeBinding[] getTopLevelTypesReferenced(ASTNode tree) {
                this.reset();
                tree.accept((ASTVisitor)this);
                return this.fTypes.toArray(new ITypeBinding[this.fTypes.size()]);
            }

            private void reset() {
                this.fTypes = new ArrayList();
            }

            public boolean visit(Name name) {
                SimpleName leftmost = InlineConstantRefactoring.getLeftmost(name);
                IBinding binding = leftmost.resolveBinding();
                if (binding instanceof ITypeBinding) {
                    this.fTypes.add(binding);
                }
                return false;
            }
        }
    }
}

