/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class IntroduceFactoryRefactoring
extends Refactoring {
    private ICompilationUnit fCUHandle;
    private CompilationUnit fCU;
    private ICompilationUnit fFactoryUnitHandle;
    private int fSelectionStart;
    private int fSelectionLength;
    private ASTNode fSelectedNode;
    private IMethodBinding fCtorBinding;
    private TypeDeclaration fCtorOwningClass;
    private String fNewMethodName = null;
    private SearchResultGroup[] fAllCallsTo;
    private TypeDeclaration fFactoryOwningClass;
    private MethodDeclaration fFactoryMethod = null;
    private String[] fFormalArgNames = null;
    private ITypeBinding[] fArgTypes;
    private boolean fProtectConstructor = true;
    private ImportRewrite fImportRewriter;
    private boolean fCallSitesInBinaryUnits;
    private CompilationUnit fFactoryCU;
    private int fConstructorVisibility = 2;
    static final int VISIBILITY_MASK = 7;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static boolean isAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && method.isConstructor();
    }

    public static IntroduceFactoryRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        return new IntroduceFactoryRefactoring(cu, selectionStart, selectionLength, settings);
    }

    private IntroduceFactoryRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(settings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCUHandle = cu;
        this.fCU = ASTCreator.createAST(this.fCUHandle, null);
    }

    private ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)this.fCU, offset, length);
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        if (node.getNodeType() == 40) {
            node = node.getParent();
        }
        if (node.getNodeType() == 14 || node.getNodeType() == 31 && ((MethodDeclaration)node).isConstructor()) {
            return node;
        }
        return null;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        IType ctorOwningType;
        block16: {
            block15: {
                block14: {
                    block13: {
                        RefactoringStatus refactoringStatus;
                        try {
                            pm.beginTask(RefactoringCoreMessages.getString("IntroduceFactory.examiningSelection"), 2);
                            this.fSelectedNode = this.getTargetNode(this.fCUHandle, this.fSelectionStart, this.fSelectionLength);
                            if (this.fSelectedNode != null) break block13;
                            refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.notAConstructorInvocation"));
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_12 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    if (this.fSelectedNode instanceof ClassInstanceCreation) {
                        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.fSelectedNode;
                        this.fCtorBinding = classInstanceCreation.resolveConstructorBinding();
                    } else if (this.fSelectedNode instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)this.fSelectedNode;
                        this.fCtorBinding = methodDeclaration.resolveBinding();
                    }
                    if (this.fCtorBinding != null) break block14;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.unableToResolveConstructorBinding"));
                    Object var5_8 = null;
                    pm.done();
                    return refactoringStatus;
                }
                if (this.fNewMethodName == null) {
                    this.fNewMethodName = "create" + this.fCtorBinding.getName();
                }
                pm.worked(1);
                if (!this.fCtorBinding.getDeclaringClass().isNested()) break block15;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.unsupportedNestedTypes"));
                Object var5_9 = null;
                pm.done();
                return refactoringStatus;
            }
            ITypeBinding ctorType = this.fCtorBinding.getDeclaringClass();
            ctorOwningType = Bindings.findType(ctorType, this.fCUHandle.getJavaProject());
            if (!ctorOwningType.isBinary()) break block16;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.constructorInBinaryClass"));
            Object var5_10 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fFactoryUnitHandle = ctorOwningType.getCompilationUnit();
        this.fFactoryCU = this.getASTFor(this.fFactoryUnitHandle);
        Name ctorOwnerName = (Name)NodeFinder.perform((ASTNode)this.fFactoryCU, ctorOwningType.getNameRange());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFactoryOwningClass = this.fCtorOwningClass = (TypeDeclaration)ASTNodes.getParent((ASTNode)ctorOwnerName, clazz);
        pm.worked(1);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var5_11 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.getString("IntroduceFactory.checkingActivation"), 1);
                if (this.fCUHandle.isStructureKnown()) break block3;
                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.syntaxError"));
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
        Object var2_5 = null;
        pm.done();
        return refactoringStatus;
    }

    private ICompilationUnit[] collectAffectedUnits(SearchResultGroup[] searchHits) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        boolean hitInFactoryClass = false;
        int i = 0;
        while (i < searchHits.length) {
            SearchResultGroup rg = searchHits[i];
            ICompilationUnit icu = rg.getCompilationUnit();
            result.add(icu);
            if (icu.equals(this.fFactoryUnitHandle)) {
                hitInFactoryClass = true;
            }
            ++i;
        }
        if (!hitInFactoryClass) {
            result.add(this.fFactoryUnitHandle);
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private SearchPattern createSearchPattern(IMethod ctor, IMethodBinding methodBinding) {
        Assert.isNotNull(methodBinding, RefactoringCoreMessages.getString("IntroduceFactory.noBindingForSelectedConstructor"));
        if (ctor != null) {
            return SearchPattern.createPattern((IJavaElement)ctor, (int)2);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(methodBinding.getDeclaringClass().getQualifiedName()).append("(");
        int i = 0;
        while (i < this.fArgTypes.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.fArgTypes[i].getQualifiedName());
            ++i;
        }
        buf.append(")");
        return SearchPattern.createPattern((String)buf.toString(), (int)3, (int)2, (int)8);
    }

    private IJavaSearchScope createSearchScope(IMethod ctor, IMethodBinding binding, IJavaProject resolvingScope) throws JavaModelException {
        if (ctor != null) {
            return RefactoringScopeFactory.create((IJavaElement)ctor);
        }
        ITypeBinding type = Bindings.getTopLevelType(binding.getDeclaringClass());
        return RefactoringScopeFactory.create((IJavaElement)Bindings.findType(type, resolvingScope));
    }

    private SearchResultGroup[] excludeBinaryUnits(SearchResultGroup[] groups) {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup rg = groups[i];
            ICompilationUnit unit = rg.getCompilationUnit();
            if (unit != null) {
                result.add(rg);
            } else {
                this.fCallSitesInBinaryUnits = true;
            }
            ++i;
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private SearchResultGroup[] searchForCallsTo(IMethodBinding methodBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        ICompilationUnit unit = ASTCreator.getCu(this.fSelectedNode);
        IJavaProject javaProject = (IJavaProject)unit.getAncestor(2);
        IMethod method = Bindings.findMethod(methodBinding, javaProject);
        SearchPattern pattern = this.createSearchPattern(method, methodBinding);
        IJavaSearchScope scope = this.createSearchScope(method, methodBinding, javaProject);
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, scope, pm, status);
        return groups;
    }

    private SearchResultGroup[] findAllCallsTo(IMethodBinding ctorBinding, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] groups = this.excludeBinaryUnits(this.searchForCallsTo(ctorBinding, pm, status));
        return groups;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("IntroduceFactory.checking_preconditions"), 1);
            RefactoringStatus result = new RefactoringStatus();
            this.fArgTypes = this.fCtorBinding.getParameterTypes();
            this.fAllCallsTo = this.findAllCallsTo(this.fCtorBinding, pm, result);
            this.fFormalArgNames = this.findCtorArgNames();
            ICompilationUnit[] affectedFiles = this.collectAffectedUnits(this.fAllCallsTo);
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(affectedFiles), this.getValidationContext()));
            if (this.fCallSitesInBinaryUnits) {
                result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.callSitesInBinaryClass")));
            }
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String[] findCtorArgNames() {
        CompilationUnit ctorUnit;
        MethodDeclaration ctorDecl;
        int numArgs = this.fCtorBinding.getParameterTypes().length;
        String[] names = new String[numArgs];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ctorDecl = (MethodDeclaration)(ctorUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)this.fCtorOwningClass, clazz)).findDeclaringNode(this.fCtorBinding.getKey())) != null) {
            List formalArgs = ctorDecl.parameters();
            int i = 0;
            Iterator iter = formalArgs.iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)iter.next();
                names[i] = svd.getName().getIdentifier();
                ++i;
            }
            return names;
        }
        int i = 0;
        while (i < numArgs) {
            names[i] = "arg" + (i + 1);
            ++i;
        }
        return names;
    }

    private MethodDeclaration createFactoryMethod(AST ast, IMethodBinding ctorBinding, OldASTRewrite unitRewriter) {
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        SimpleName newMethodName = ast.newSimpleName(this.fNewMethodName);
        ClassInstanceCreation newCtorCall = ast.newClassInstanceCreation();
        ReturnStatement ret = ast.newReturnStatement();
        Block body = ast.newBlock();
        List stmts = body.statements();
        String retTypeName = ctorBinding.getName();
        this.createFactoryMethodSignature(ast, newMethod);
        newMethod.setName(newMethodName);
        newMethod.setBody(body);
        newMethod.setReturnType((Type)ast.newSimpleType((Name)ast.newSimpleName(retTypeName)));
        newMethod.setModifiers(9);
        newCtorCall.setName((Name)ast.newSimpleName(retTypeName));
        this.createFactoryMethodConstructorArgs(ast, newCtorCall);
        ret.setExpression((Expression)newCtorCall);
        stmts.add(ret);
        unitRewriter.markAsInserted((ASTNode)ret);
        return newMethod;
    }

    private void createFactoryMethodSignature(AST ast, MethodDeclaration newMethod) {
        List argTypes = newMethod.parameters();
        int i = 0;
        while (i < this.fArgTypes.length) {
            SingleVariableDeclaration argDecl = ast.newSingleVariableDeclaration();
            argDecl.setName(ast.newSimpleName(this.fFormalArgNames[i]));
            argDecl.setType(this.typeForArgType(this.fArgTypes[i], ast));
            argTypes.add(argDecl);
            ++i;
        }
        ITypeBinding[] ctorExcepts = this.fCtorBinding.getExceptionTypes();
        List exceptions = newMethod.thrownExceptions();
        int i2 = 0;
        while (i2 < ctorExcepts.length) {
            String excName = this.fImportRewriter.addImport(ctorExcepts[i2]);
            exceptions.add(ASTNodeFactory.newName(ast, excName));
            ++i2;
        }
    }

    private Type typeForArgType(ITypeBinding argType, AST ast) {
        if (argType.isPrimitive()) {
            return ASTNodeFactory.newType(ast, argType, false);
        }
        if (argType.isArray()) {
            Type elementType = this.typeForArgType(argType.getElementType(), ast);
            return ast.newArrayType(elementType, argType.getDimensions());
        }
        String typeName = this.fImportRewriter.addImport(argType);
        return ast.newSimpleType(ASTNodeFactory.newName(ast, typeName));
    }

    private void createFactoryMethodConstructorArgs(AST ast, ClassInstanceCreation newCtorCall) {
        List argList = newCtorCall.arguments();
        int i = 0;
        while (i < this.fArgTypes.length) {
            SimpleName ctorArg = ast.newSimpleName(this.fFormalArgNames[i]);
            argList.add(ctorArg);
            ++i;
        }
    }

    private MethodInvocation createFactoryMethodCall(AST ast, ClassInstanceCreation ctorCall, OldASTRewrite unitRewriter, TextEditGroup gd) {
        String methodName;
        TypeDeclaration callOwner;
        ITypeBinding callOwnerBinding;
        MethodInvocation factoryMethodCall = ast.newMethodInvocation();
        List actualFactoryArgs = factoryMethodCall.arguments();
        List actualCtorArgs = ctorCall.arguments();
        String rawMethodName = this.fNewMethodName;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((callOwnerBinding = (callOwner = (TypeDeclaration)ASTNodes.getParent((ASTNode)ctorCall, clazz)).resolveBinding()) == null || !Bindings.equals((IBinding)callOwner.resolveBinding(), (IBinding)this.fFactoryOwningClass.resolveBinding())) {
            String qualifier = this.fImportRewriter.addImport(this.fFactoryOwningClass.resolveBinding());
            methodName = String.valueOf(qualifier) + "." + rawMethodName;
        } else {
            methodName = rawMethodName;
        }
        factoryMethodCall.setName(ast.newSimpleName(methodName));
        int i = 0;
        while (i < this.fArgTypes.length) {
            Expression actualCtorArg = (Expression)actualCtorArgs.get(i);
            ASTNode movedArg = unitRewriter.createMoveTarget((ASTNode)actualCtorArg);
            actualFactoryArgs.add(movedArg);
            ++i;
        }
        unitRewriter.replace((ASTNode)ctorCall, (ASTNode)factoryMethodCall, gd);
        return factoryMethodCall;
    }

    private boolean isConstructorUnit(ICompilationUnit unit) {
        return unit.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
    }

    private boolean shouldProtectConstructor() {
        return this.fProtectConstructor && this.fCtorOwningClass != null;
    }

    private boolean protectConstructor(CompilationUnit unitAST, OldASTRewrite unitRewriter, TextEditGroup declGD) {
        MethodDeclaration constructor = (MethodDeclaration)unitAST.findDeclaringNode(this.fCtorBinding.getKey());
        if (constructor == null || (constructor.getModifiers() & 7) == this.fConstructorVisibility) {
            return false;
        }
        unitRewriter.set((ASTNode)constructor, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, new Integer(ASTNodes.changeVisibility(constructor.getModifiers(), this.fConstructorVisibility)), declGD);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addAllChangesFor(SearchResultGroup rg, ICompilationUnit unitHandle, CompilationUnitChange unitChange) throws CoreException {
        Assert.isTrue(rg == null || rg.getCompilationUnit() == unitHandle);
        CompilationUnit unit = this.getASTFor(unitHandle);
        OldASTRewrite unitRewriter = new OldASTRewrite((ASTNode)unit);
        TextBuffer buffer = null;
        MultiTextEdit root = new MultiTextEdit();
        boolean someChange = false;
        try {
            TextEditGroup declGD;
            unitChange.setEdit((TextEdit)root);
            buffer = TextBuffer.acquire((IFile)unitHandle.getResource());
            this.fImportRewriter = new ImportRewrite(unitHandle);
            if (unitHandle.equals(this.fFactoryUnitHandle)) {
                TextEditGroup factoryGD = new TextEditGroup(RefactoringCoreMessages.getString("IntroduceFactory.addFactoryMethod"));
                this.createFactoryChange(unitRewriter, unit, factoryGD);
                unitChange.addTextEditGroup(factoryGD);
                someChange = true;
            }
            if (rg != null && this.replaceConstructorCalls(rg, unit, unitRewriter, unitChange)) {
                someChange = true;
            }
            if (this.shouldProtectConstructor() && this.isConstructorUnit(unitHandle) && this.protectConstructor(unit, unitRewriter, declGD = new TextEditGroup(RefactoringCoreMessages.getString("IntroduceFactory.protectConstructor")))) {
                unitChange.addTextEditGroup(declGD);
                someChange = true;
            }
            if (someChange) {
                unitRewriter.rewriteNode(buffer, (TextEdit)root);
                root.addChild(this.fImportRewriter.createEdit(buffer.getDocument()));
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (unitRewriter != null) {
                unitRewriter.removeModifications();
            }
            if (buffer == null) throw throwable;
            TextBuffer.release(buffer);
            throw throwable;
        }
        {
            Object var10_12 = null;
            if (unitRewriter != null) {
                unitRewriter.removeModifications();
            }
            if (buffer == null) return someChange;
        }
        TextBuffer.release(buffer);
        return someChange;
    }

    private CompilationUnit getASTFor(ICompilationUnit unitHandle) {
        if (unitHandle.equals(this.fCUHandle)) {
            if (this.fCU == null) {
                this.fCU = ASTCreator.createAST(unitHandle, null);
                if (this.fCU.equals((Object)this.fFactoryUnitHandle)) {
                    this.fFactoryCU = this.fCU;
                }
            }
            return this.fCU;
        }
        if (unitHandle.equals(this.fFactoryUnitHandle)) {
            if (this.fFactoryCU == null) {
                this.fFactoryCU = ASTCreator.createAST(unitHandle, null);
            }
            return this.fFactoryCU;
        }
        return ASTCreator.createAST(unitHandle, null);
    }

    private boolean replaceConstructorCalls(SearchResultGroup rg, CompilationUnit unit, OldASTRewrite unitRewriter, CompilationUnitChange unitChange) throws JavaModelException {
        Assert.isTrue(ASTCreator.getCu((ASTNode)unit).equals(rg.getCompilationUnit()));
        SearchMatch[] hits = rg.getSearchResults();
        AST ctorCallAST = unit.getAST();
        boolean someCallPatched = false;
        int i = 0;
        while (i < hits.length) {
            ClassInstanceCreation creation = this.getCtorCallAt(hits[i].getOffset(), SearchUtils.getEnd(hits[i]), unit);
            if (creation != null) {
                TextEditGroup gd = new TextEditGroup(RefactoringCoreMessages.getString("IntroduceFactory.replaceCalls"));
                this.createFactoryMethodCall(ctorCallAST, creation, unitRewriter, gd);
                unitChange.addTextEditGroup(gd);
                someCallPatched = true;
            }
            ++i;
        }
        return someCallPatched;
    }

    private ClassInstanceCreation getCtorCallAt(int start, int end, CompilationUnit unitAST) throws JavaModelException {
        ICompilationUnit unitHandle = ASTCreator.getCu((ASTNode)unitAST);
        int length = end - start;
        ASTNode node = NodeFinder.perform((ASTNode)unitAST, start, length);
        if (node == null) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(4, RefactoringCoreMessages.getFormattedString("IntroduceFactory.noASTNodeForConstructorSearchHit", new Object[]{Integer.toString(start), Integer.toString(end), unitHandle.getSource().substring(start, end), unitHandle.getElementName()})));
        }
        if (node instanceof ClassInstanceCreation) {
            return (ClassInstanceCreation)node;
        }
        if (node instanceof VariableDeclaration) {
            Expression init = ((VariableDeclaration)node).getInitializer();
            if (init instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)init;
            }
            if (init != null) {
                throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(4, RefactoringCoreMessages.getFormattedString("IntroduceFactory.unexpectedInitializerNodeType", new Object[]{init.toString(), unitHandle.getElementName()})));
            }
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(4, RefactoringCoreMessages.getFormattedString("IntroduceFactory.noConstructorCallNodeInsideFoundVarbleDecl", new Object[]{node.toString()})));
        }
        if (node instanceof ConstructorInvocation) {
            return null;
        }
        if (node instanceof SuperConstructorInvocation) {
            this.fConstructorVisibility = 4;
            return null;
        }
        if (node instanceof ExpressionStatement) {
            Expression expr = ((ExpressionStatement)node).getExpression();
            if (expr instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)expr;
            }
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(4, RefactoringCoreMessages.getFormattedString("IntroduceFactory.unexpectedASTNodeTypeForConstructorSearchHit", new Object[]{expr.toString(), unitHandle.getElementName()})));
        }
        if (node instanceof SimpleName && (node.getParent() instanceof MethodDeclaration || node.getParent() instanceof TypeDeclaration)) {
            this.fConstructorVisibility = 4;
            return null;
        }
        throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(4, RefactoringCoreMessages.getFormattedString("IntroduceFactory.unexpectedASTNodeTypeForConstructorSearchHit", new Object[]{String.valueOf(node.getClass().getName()) + "('" + node.toString() + "')", unitHandle.getElementName()})));
    }

    private void createFactoryChange(OldASTRewrite unitRewriter, CompilationUnit unit, TextEditGroup gd) {
        TypeDeclaration factoryOwner;
        AST ast = unit.getAST();
        this.fFactoryMethod = this.createFactoryMethod(ast, this.fCtorBinding, unitRewriter);
        TypeDeclaration methodOwner = factoryOwner = (TypeDeclaration)unit.findDeclaringNode(this.fFactoryOwningClass.resolveBinding().getKey());
        this.fImportRewriter.addImport(this.fCtorOwningClass.resolveBinding());
        List methodDeclList = methodOwner.bodyDeclarations();
        int idx = ASTNodes.getInsertionIndex((BodyDeclaration)this.fFactoryMethod, methodDeclList);
        if (idx < 0) {
            idx = 0;
        }
        methodDeclList.add(idx, this.fFactoryMethod);
        unitRewriter.markAsInserted((ASTNode)this.fFactoryMethod, gd);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask(RefactoringCoreMessages.getString("IntroduceFactory.createChanges"), this.fAllCallsTo.length);
        DynamicValidationStateChange result = new DynamicValidationStateChange(String.valueOf(RefactoringCoreMessages.getString("IntroduceFactory.topLevelChangeLabel")) + this.fCtorBinding.getName());
        try {
            boolean hitInFactoryClass = false;
            boolean hitInCtorClass = false;
            int i = 0;
            while (i < this.fAllCallsTo.length) {
                CompilationUnitChange cuChange;
                SearchResultGroup rg = this.fAllCallsTo[i];
                ICompilationUnit unitHandle = rg.getCompilationUnit();
                if (this.addAllChangesFor(rg, unitHandle, cuChange = new CompilationUnitChange(this.getName(), unitHandle))) {
                    result.add((Change)cuChange);
                }
                if (unitHandle.equals(this.fFactoryUnitHandle)) {
                    hitInFactoryClass = true;
                }
                if (unitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                    hitInCtorClass = true;
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            if (!hitInFactoryClass) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), this.fFactoryUnitHandle);
                this.addAllChangesFor(null, this.fFactoryUnitHandle, cuChange);
                result.add((Change)cuChange);
            }
            if (!hitInCtorClass && !this.fFactoryUnitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
                this.addAllChangesFor(null, ASTCreator.getCu((ASTNode)this.fCtorOwningClass), cuChange);
                result.add((Change)cuChange);
            }
            dynamicValidationStateChange = result;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("IntroduceFactory.name");
    }

    public String getNewMethodName() {
        return this.fNewMethodName;
    }

    public RefactoringStatus setNewMethodName(String newMethodName) {
        Assert.isNotNull(newMethodName);
        this.fNewMethodName = newMethodName;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName);
        stat.merge(this.isUniqueMethodName(newMethodName));
        return stat;
    }

    private RefactoringStatus isUniqueMethodName(String methodName) {
        boolean conflict = this.hasMethod(this.fFactoryOwningClass, methodName);
        return conflict ? RefactoringStatus.createErrorStatus((String)(String.valueOf(RefactoringCoreMessages.getString("IntroduceFactory.duplicateMethodName")) + methodName)) : new RefactoringStatus();
    }

    private boolean hasMethod(TypeDeclaration type, String name) {
        List decls = type.bodyDeclarations();
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            BodyDeclaration decl = (BodyDeclaration)iter.next();
            if (!(decl instanceof MethodDeclaration) || !((MethodDeclaration)decl).getName().getIdentifier().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean canProtectConstructor() {
        return !this.fCtorBinding.isSynthetic() && this.fFactoryCU.findDeclaringNode(this.fCtorBinding.getKey()) != null;
    }

    public void setProtectConstructor(boolean protectConstructor) {
        this.fProtectConstructor = protectConstructor;
    }

    public IJavaProject getProject() {
        return this.fCUHandle.getJavaProject();
    }

    public RefactoringStatus setFactoryClass(String fullyQualifiedTypeName) {
        IType factoryType;
        try {
            factoryType = this.getProject().findType(fullyQualifiedTypeName);
            if (factoryType == null) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.getFormattedString("IntroduceFactory.noSuchClass", fullyQualifiedTypeName));
            }
            if (factoryType.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.cantPutFactoryMethodOnInterface"));
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.cantCheckForInterface"));
        }
        ICompilationUnit factoryUnitHandle = factoryType.getCompilationUnit();
        if (factoryType.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.getString("IntroduceFactory.cantPutFactoryInBinaryClass"));
        }
        try {
            String ctorPkg;
            if (!this.fFactoryUnitHandle.equals(factoryUnitHandle)) {
                this.fFactoryCU = this.getASTFor(factoryUnitHandle);
                this.fFactoryUnitHandle = factoryUnitHandle;
            }
            this.fFactoryOwningClass = ASTNodeSearchUtil.getTypeDeclarationNode(factoryType, this.fFactoryCU);
            String factoryPkg = factoryType.getPackageFragment().getElementName();
            if (!factoryPkg.equals(ctorPkg = this.fCtorOwningClass.resolveBinding().getPackage().getName())) {
                this.fConstructorVisibility = 1;
            } else if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
            if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
        }
        catch (JavaModelException e) {
            return RefactoringStatus.createErrorStatus((String)e.getMessage());
        }
        return new RefactoringStatus();
    }

    public String getFactoryClassName() {
        return this.fFactoryOwningClass.resolveBinding().getQualifiedName();
    }
}

