/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CreateFileChange
extends JDTChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;

    public CreateFileChange(IPath path, String source, String encoding) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
    }

    private CreateFileChange(IPath path, String source, String encoding, boolean explicit) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        Assert.isNotNull(encoding, "encoding");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull(encoding, "encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) {
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        DeleteFileChange deleteFileChange;
        InputStream is;
        block11: {
            Change change;
            block10: {
                is = null;
                try {
                    pm.beginTask(NLSChangesMessages.getString("createFile.creating_resource"), 2);
                    this.initializeEncoding();
                    IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (file.exists()) {
                        CompositeChange composite = new CompositeChange(this.getName());
                        composite.add((Change)new DeleteFileChange(file));
                        composite.add((Change)new CreateFileChange(this.fPath, this.fSource, this.fEncoding, this.fExplicitEncoding));
                        change = composite.perform(pm);
                        Object var5_8 = null;
                        break block10;
                    }
                    try {
                        is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                        file.create(is, false, pm);
                        if (this.fExplicitEncoding) {
                            file.setCharset(this.fEncoding);
                        }
                        deleteFileChange = new DeleteFileChange(file);
                        break block11;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JavaModelException((Throwable)e, 985);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    pm.done();
                    try {
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException((Throwable)ioe, 985);
                    }
                }
            }
            pm.done();
            try {}
            catch (IOException ioe) {
                throw new JavaModelException((Throwable)ioe, 985);
            }
            if (is == null) return change;
            is.close();
            return change;
        }
        Object var5_9 = null;
        pm.done();
        try {}
        catch (IOException ioe) {
            throw new JavaModelException((Throwable)ioe, 985);
        }
        if (is == null) return deleteFileChange;
        is.close();
        return deleteFileChange;
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        IFile iFile;
        pm.beginTask("", 1);
        try {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iFile;
    }

    private void initializeEncoding() {
        block8: {
            if (this.fEncoding == null) {
                this.fExplicitEncoding = false;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                if (file != null) {
                    try {
                        if (file.exists()) {
                            this.fEncoding = file.getCharset(false);
                            if (this.fEncoding == null) {
                                this.fEncoding = file.getCharset(true);
                            } else {
                                this.fExplicitEncoding = true;
                            }
                            break block8;
                        }
                        this.fEncoding = file.getCharset(true);
                    }
                    catch (CoreException coreException) {
                        this.fEncoding = ResourcesPlugin.getEncoding();
                        this.fExplicitEncoding = true;
                    }
                } else {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            }
        }
        Assert.isNotNull(this.fEncoding);
    }

    public String getName() {
        if (this.fChangeName == null) {
            return String.valueOf(NLSChangesMessages.getString("createFile.Create_file")) + this.fPath.toString();
        }
        return this.fChangeName;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    protected String getSource() {
        return this.fSource;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }
}

