/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class PullUpRefactoring
extends Refactoring {
    private IMember[] fMembersToPullUp;
    private IMethod[] fMethodsToDeclareAbstract;
    private IMethod[] fMethodsToDelete;
    private TextChangeManager fChangeManager;
    private IType fTargetType;
    private boolean fCreateMethodStubs;
    private final ImportRewriteManager fImportManager;
    private final CodeGenerationSettings fPreferenceSettings;
    private IType fCachedDeclaringType;
    private IType[] fCachedTypesReferencedInPulledUpMembers;
    private ITypeHierarchy fCachedTargetClassHierarchy;
    private Set fCachedSkippedSuperclasses;
    private final Map fCachedMembersReferences;

    private PullUpRefactoring(IMember[] elements, CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(elements);
        Assert.isNotNull(preferenceSettings);
        this.fMembersToPullUp = elements;
        this.fMethodsToDelete = new IMethod[0];
        this.fMethodsToDeclareAbstract = new IMethod[0];
        this.fPreferenceSettings = preferenceSettings;
        this.fImportManager = new ImportRewriteManager(preferenceSettings);
        this.fCreateMethodStubs = true;
        this.fCachedMembersReferences = new HashMap(2);
    }

    public static PullUpRefactoring create(IMember[] members, CodeGenerationSettings preferenceSettings) throws JavaModelException {
        if (!PullUpRefactoring.isAvailable(members)) {
            return null;
        }
        if (PullUpRefactoring.isOneTypeWithPullableMembers(members)) {
            PullUpRefactoring result = new PullUpRefactoring(new IMember[0], preferenceSettings);
            result.fCachedDeclaringType = PullUpRefactoring.getSingleTopLevelType(members);
            return result;
        }
        return new PullUpRefactoring(members, preferenceSettings);
    }

    public static boolean isAvailable(IMember[] members) throws JavaModelException {
        if (PullUpRefactoring.isOneTypeWithPullableMembers(members)) {
            return true;
        }
        return members != null && members.length != 0 && PullUpRefactoring.areAllPullable(members) && PullUpRefactoring.haveCommonDeclaringType(members);
    }

    private static boolean isOneTypeWithPullableMembers(IMember[] members) throws JavaModelException {
        IType singleTopLevelType = PullUpRefactoring.getSingleTopLevelType(members);
        return singleTopLevelType != null && PullUpRefactoring.getPullableMembers(singleTopLevelType).length != 0;
    }

    private static IType getSingleTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType(members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("PullUpRefactoring.Pull_Up");
    }

    public void setMethodsToDelete(IMethod[] methodsToDelete) {
        Assert.isNotNull(methodsToDelete);
        this.fMethodsToDelete = PullUpRefactoring.getOriginals(methodsToDelete);
    }

    public void setMethodsToDeclareAbstract(IMethod[] methods) {
        Assert.isNotNull(methods);
        this.fMethodsToDeclareAbstract = PullUpRefactoring.getOriginals(methods);
    }

    public void setMembersToPullUp(IMember[] elements) {
        Assert.isNotNull(elements);
        this.fMembersToPullUp = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])elements);
        this.fMembersToPullUp = WorkingCopyUtil.getOriginals(this.fMembersToPullUp);
    }

    private IMember[] getMembersToDelete(IProgressMonitor pm) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            IMember[] typesToDelete = WorkingCopyUtil.getOriginals(PullUpRefactoring.getMembersOfType(this.fMembersToPullUp, 7));
            IMember[] matchingElements = this.getMatchingElements(pm, false);
            IMember[] matchingFields = WorkingCopyUtil.getOriginals(PullUpRefactoring.getMembersOfType(matchingElements, 8));
            iMemberArray = PullUpRefactoring.merge(matchingFields, typesToDelete, (IMember[])this.fMethodsToDelete);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    public void setCreateMethodStubs(boolean create) {
        this.fCreateMethodStubs = create;
    }

    public boolean getCreateMethodStubs() {
        return this.fCreateMethodStubs;
    }

    public IMember[] getMembersToPullUp() {
        return this.fMembersToPullUp;
    }

    public IType getDeclaringType() {
        if (this.fCachedDeclaringType != null) {
            return this.fCachedDeclaringType;
        }
        Assert.isTrue(this.fMembersToPullUp.length > 0);
        this.fCachedDeclaringType = (IType)WorkingCopyUtil.getOriginal((IMember)this.fMembersToPullUp[0].getDeclaringType());
        return this.fCachedDeclaringType;
    }

    public IMember[] getPullableMembersOfDeclaringType() {
        try {
            return PullUpRefactoring.getPullableMembers(this.getDeclaringType());
        }
        catch (JavaModelException javaModelException) {
            return new IMember[0];
        }
    }

    private static IMember[] getPullableMembers(IType type) throws JavaModelException {
        ArrayList list = new ArrayList(3);
        PullUpRefactoring.addAllPullable((IMember[])type.getFields(), list);
        PullUpRefactoring.addAllPullable((IMember[])type.getMethods(), list);
        PullUpRefactoring.addAllPullable((IMember[])type.getTypes(), list);
        return list.toArray(new IMember[list.size()]);
    }

    private static void addAllPullable(IMember[] members, List list) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            if (PullUpRefactoring.isPullable(members[i])) {
                list.add(members[i]);
            }
            ++i;
        }
    }

    private static boolean isPullable(IMember member) throws JavaModelException {
        if (member.getElementType() != 9 && member.getElementType() != 8 && member.getElementType() != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
        }
        return true;
    }

    public ITypeHierarchy getTypeHierarchyOfTargetClass(IProgressMonitor pm) throws JavaModelException {
        block3: {
            ITypeHierarchy iTypeHierarchy;
            try {
                if (this.fCachedTargetClassHierarchy == null || !this.fCachedTargetClassHierarchy.getType().equals(this.getTargetClass())) break block3;
                iTypeHierarchy = this.fCachedTargetClassHierarchy;
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return iTypeHierarchy;
        }
        ITypeHierarchy iTypeHierarchy = this.fCachedTargetClassHierarchy = this.getTargetClass().newTypeHierarchy(pm);
        Object var2_5 = null;
        pm.done();
        return iTypeHierarchy;
    }

    public IType[] getPossibleTargetClasses(IProgressMonitor pm) throws JavaModelException {
        return this.getPossibleTargetClasses(new RefactoringStatus(), pm);
    }

    private IType[] getPossibleTargetClasses(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        IType[] superClasses = this.getDeclaringType().newSupertypeHierarchy(pm).getAllSuperclasses(this.getDeclaringType());
        ArrayList<IType> superClassList = new ArrayList<IType>(superClasses.length);
        int binary = 0;
        int i = 0;
        while (i < superClasses.length) {
            IType superclass = superClasses[i];
            if (this.isPossibleTargetClass(superclass)) {
                superClassList.add(superclass);
            } else if (superclass != null && superclass.isBinary()) {
                ++binary;
            }
            ++i;
        }
        if (superClasses.length == binary) {
            status.addFatalError(RefactoringCoreMessages.getString("PullUPRefactoring.no_all_binary"));
        }
        Collections.reverse(superClassList);
        return superClassList.toArray(new IType[superClassList.size()]);
    }

    private boolean isPossibleTargetClass(IType clazz) {
        return clazz != null && clazz.exists() && !clazz.isReadOnly() && !clazz.isBinary() && !"java.lang.Object".equals(clazz.getFullyQualifiedName());
    }

    public IType getTargetClass() {
        return this.fTargetType;
    }

    public void setTargetClass(IType targetType) {
        Assert.isNotNull(targetType);
        if (!targetType.equals(this.fTargetType)) {
            this.fCachedTargetClassHierarchy = null;
        }
        this.fTargetType = targetType;
    }

    public IMember[] getMatchingElements(IProgressMonitor pm, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            HashSet result = new HashSet();
            IType targetClass = this.getTargetClass();
            Map matching = this.getMatchingMemberMatching(pm, includeMethodsToDeclareAbstract);
            Iterator iter = matching.keySet().iterator();
            while (iter.hasNext()) {
                IMember key = (IMember)iter.next();
                if (key.getDeclaringType().equals(targetClass)) {
                    iter.remove();
                    continue;
                }
                result.addAll((Set)matching.get(key));
            }
            iMemberArray = result.toArray(new IMember[result.size()]);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    public IMember[] getAdditionalRequiredMembersToPullUp(IProgressMonitor pm) throws JavaModelException {
        IMember current;
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.calculating_required"), members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPullableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private void addAllRequiredPullableMembers(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        this.addAllRequiredPullableMethods(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addAllRequiredPullableFields(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addAllRequiredPullableTypes(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private void addAllRequiredPullableTypes(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        IType[] requiredTypes = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{member}, pm);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredTypes.length) {
            IType requiredType = requiredTypes[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredType)) && this.isRequiredPullableMember(queue, (IMember)requiredType)) {
                queue.add(requiredType);
            }
            ++i;
        }
    }

    private void addAllRequiredPullableFields(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, pm);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredFields.length) {
            IField requiredField = requiredFields[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredField)) && this.isRequiredPullableMember(queue, (IMember)requiredField)) {
                queue.add(requiredField);
            }
            ++i;
        }
    }

    private void addAllRequiredPullableMethods(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        SubProgressMonitor sPm = new SubProgressMonitor(pm, 1);
        sPm.beginTask("", requiredMethods.length);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredMethods.length) {
            IMethod requiredMethod = requiredMethods[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredMethod)) && this.isRequiredPullableMember(queue, (IMember)requiredMethod) && !this.isVirtualAccessibleFromTargetClass(requiredMethod, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sPm, 1))) {
                queue.add(requiredMethod);
            }
            ++i;
        }
        sPm.done();
    }

    private boolean isVirtualAccessibleFromTargetClass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        try {
            bl = MethodChecks.isVirtual(method) && this.isDeclaredInTargetClassOrItsSuperclass(method, pm);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return bl;
    }

    private boolean isDeclaredInTargetClassOrItsSuperclass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy hierarchy;
        IType targetClass;
        String name;
        String[] paramTypes;
        boolean isConstructor;
        block3: {
            try {
                isConstructor = false;
                paramTypes = method.getParameterTypes();
                name = method.getElementName();
                targetClass = this.getTargetClass();
                hierarchy = this.getTypeHierarchyOfTargetClass(pm);
                IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, targetClass);
                if (first == null || !MethodChecks.isVirtual(first)) break block3;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return true;
        }
        IMethod found = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, targetClass, name, paramTypes, isConstructor);
        boolean bl = found != null && MethodChecks.isVirtual(found);
        Object var10_10 = null;
        pm.done();
        return bl;
    }

    private boolean isRequiredPullableMember(List queue, IMember member) throws JavaModelException {
        if (member.getDeclaringType() == null) {
            return false;
        }
        return member.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(member) && PullUpRefactoring.isPullable(member);
    }

    private static void addToMapping(Map mapping, IMember key, IMember matchingMember) {
        Set<IMember> matchingSet;
        if (mapping.containsKey(key)) {
            matchingSet = (Set)mapping.get(key);
        } else {
            matchingSet = new HashSet();
            mapping.put(key, matchingSet);
        }
        Assert.isTrue(!matchingSet.contains(matchingMember));
        matchingSet.add(matchingMember);
    }

    private Map getMatchingMembersMappingFromTypeAndAllSubtypes(ITypeHierarchy hierarchy, IType type, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        HashMap result = new HashMap();
        result.putAll(this.getMatchingMembersMapping(type));
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        int i = 0;
        while (i < subTypes.length) {
            PullUpRefactoring.mergeSets(result, this.getMatchingMembersMapping(subTypes[i]));
            ++i;
        }
        if (includeMethodsToDeclareAbstract) {
            return result;
        }
        i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            if (result.containsKey(this.fMethodsToDeclareAbstract[i])) {
                result.remove(this.fMethodsToDeclareAbstract[i]);
            }
            ++i;
        }
        return result;
    }

    private static void mergeSets(Map result, Map map) {
        PullUpRefactoring.mergeSetsForCommonKeys(result, map);
        PullUpRefactoring.putAllThatDoNotExistInResultYet(result, map);
    }

    private static void mergeSetsForCommonKeys(Map result, Map map) {
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (!map.containsKey(key)) continue;
            Set resultSet = (Set)result.get(key);
            Set mapSet = (Set)map.get(key);
            resultSet.addAll(mapSet);
        }
    }

    private static void putAllThatDoNotExistInResultYet(Map result, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (result.containsKey(key)) continue;
            Set mapSet = (Set)map.get(key);
            HashSet resultSet = new HashSet(mapSet);
            result.put(key, resultSet);
        }
    }

    private Map getMatchingMembersMapping(IType analyzedType) throws JavaModelException {
        HashMap result = new HashMap();
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            IMethod found;
            IMember member = members[i];
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                found = MemberCheckUtil.findMethod(method, analyzedType.getMethods());
                if (found != null) {
                    PullUpRefactoring.addToMapping(result, (IMember)method, (IMember)found);
                }
            } else if (member instanceof IField) {
                IField field = (IField)member;
                found = analyzedType.getField(field.getElementName());
                if (found.exists()) {
                    PullUpRefactoring.addToMapping(result, (IMember)field, (IMember)found);
                }
            } else if (member instanceof IType) {
                IType type = (IType)member;
                found = analyzedType.getType(type.getElementName());
                if (found.exists()) {
                    PullUpRefactoring.addToMapping(result, (IMember)type, (IMember)found);
                }
            } else {
                Assert.isTrue(false);
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block5: {
            block4: {
                RefactoringStatus refactoringStatus;
                try {
                    pm.beginTask("", 3);
                    result = new RefactoringStatus();
                    this.fMembersToPullUp = WorkingCopyUtil.getOriginals(this.fMembersToPullUp);
                    result.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (!result.hasFatalError()) break block4;
                    refactoringStatus = result;
                    Object var3_6 = null;
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return refactoringStatus;
            }
            result.merge(this.checkIfMembersExist());
            if (!result.hasFatalError()) break block5;
            RefactoringStatus refactoringStatus = result;
            Object var3_7 = null;
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = result;
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkIfMembersExist() {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember orig = this.fMembersToPullUp[i];
            if (orig == null || !orig.exists()) {
                String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.does_not_exist", orig.getElementName());
                result.addFatalError(message);
            }
            ++i;
        }
        return result;
    }

    private static IMethod[] getOriginals(IMethod[] methods) {
        IMethod[] result = new IMethod[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = (IMethod)WorkingCopyUtil.getOriginal((IMember)methods[i]);
            ++i;
        }
        return result;
    }

    private static IMember[] merge(IMember[] a1, IMember[] a2, IMember[] a3) {
        return JavaElementUtil.merge(JavaElementUtil.merge(a1, a2), a3);
    }

    private static IMember[] getMembersOfType(IMember[] members, int type) {
        List<IJavaElement> list = Arrays.asList(JavaElementUtil.getElementsOfType((IJavaElement[])members, type));
        return list.toArray(new IMember[list.size()]);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.preview"), 7);
                this.clearCaches();
                result = new RefactoringStatus();
                result.merge(this.checkFinalFields((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkAccesses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkMembersInTypeAndAllSubtypes((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                result.merge(this.checkIfSkippingOverElements((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.shouldMakeTargetClassAbstract()) {
                    result.merge(this.checkCallsToTargetClassConstructors((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                if (!result.hasFatalError()) break block6;
                refactoringStatus = result;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        result.merge(this.validateModifiesFiles());
        RefactoringStatus refactoringStatus = result;
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private void clearCaches() {
        this.fCachedTypesReferencedInPulledUpMembers = null;
        this.fImportManager.clear();
        this.fCachedMembersReferences.clear();
        this.fCachedTargetClassHierarchy = null;
    }

    private RefactoringStatus checkCallsToTargetClassConstructors(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(this.getTargetClass(), pm, result);
        String[] keys = new String[]{PullUpRefactoring.createTypeLabel(this.getTargetClass())};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.gets_instantiated", keys);
        int i = 0;
        while (i < groups.length) {
            ICompilationUnit cu = groups[i].getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = new RefactoringASTParser(2).parse(cu, false);
                ASTNode[] refNodes = ASTNodeSearchUtil.getAstNodes(groups[i].getSearchResults(), cuNode);
                int j = 0;
                while (j < refNodes.length) {
                    ASTNode node = refNodes[j];
                    if (node instanceof ClassInstanceCreation || ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                        RefactoringStatusContext context = JavaStatusContext.create(cu, node);
                        result.addError(msg, context);
                    }
                    ++j;
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkIfSkippingOverElements(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            Set skippedSuperclassSet = this.getSkippedSuperclasses((IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] skippedSuperclasses = skippedSuperclassSet.toArray(new IType[skippedSuperclassSet.size()]);
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < this.fMembersToPullUp.length) {
                IMember element = this.fMembersToPullUp[i];
                int j = 0;
                while (j < skippedSuperclasses.length) {
                    result.merge(this.checkIfDeclaredIn(element, skippedSuperclasses[j]));
                    ++j;
                }
                ++i;
            }
            refactoringStatus = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkIfDeclaredIn(IMember element, IType type) throws JavaModelException {
        if (element instanceof IMethod) {
            return this.checkIfMethodDeclaredIn((IMethod)element, type);
        }
        if (element instanceof IField) {
            return this.checkIfFieldDeclaredIn((IField)element, type);
        }
        if (element instanceof IType) {
            return this.checkIfTypeDeclaredIn((IType)element, type);
        }
        Assert.isTrue(false);
        return null;
    }

    private RefactoringStatus checkIfTypeDeclaredIn(IType iType, IType type) {
        IType typeInType = type.getType(iType.getElementName());
        if (!typeInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createTypeLabel(typeInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.Type_declared_in_class", keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)typeInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfFieldDeclaredIn(IField iField, IType type) {
        IField fieldInType = type.getField(iField.getElementName());
        if (!fieldInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createFieldLabel(fieldInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.Field_declared_in_class", keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)fieldInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfMethodDeclaredIn(IMethod iMethod, IType type) throws JavaModelException {
        IMethod methodInType = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type);
        if (methodInType == null || !methodInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createMethodLabel(methodInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.methodis_declared_in_class", keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)methodInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private static String createTypeLabel(IType type) {
        return JavaModelUtil.getFullyQualifiedName(type);
    }

    private static String createFieldLabel(IField field) {
        return field.getElementName();
    }

    private static String createMethodLabel(IMethod method) {
        return JavaElementUtil.createMethodSignature(method);
    }

    private static boolean areAllPullable(IMember[] members) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            if (!PullUpRefactoring.isPullable(members[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkDeclaringType(IProgressMonitor pm) throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        if (declaringType.isInterface()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PullUpRefactoring.no_interface_members"));
        }
        if (JavaModelUtil.getFullyQualifiedName(declaringType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PullUpRefactoring.no_java.lang.Object"));
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PullUpRefactoring.no_binary_types"));
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PullUpRefactoring.no_read_only_types"));
        }
        return this.checkSuperclassesOfDeclaringClass(pm);
    }

    private RefactoringStatus checkSuperclassesOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.getPossibleTargetClasses(result, pm).length == 0 && !result.hasFatalError()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PullUpRefactoring.not_this_type"));
        }
        return result;
    }

    private static boolean haveCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType declaringType = members[0].getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        int i = 0;
        while (i < members.length) {
            if (!declaringType.equals(members[i].getDeclaringType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkFinalFields(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", this.fMembersToPullUp.length);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember member = this.fMembersToPullUp[i];
            if (member.getElementType() == 8 && !JdtFlags.isStatic(member) && JdtFlags.isFinal(member)) {
                RefactoringStatusContext context = JavaStatusContext.create(member);
                result.addWarning(RefactoringCoreMessages.getString("PullUpRefactoring.final_fields"), context);
            }
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccesses(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.checking_referenced_elements"), 3);
        result.merge(this.checkAccessedTypes((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFields((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypeReferencedInPulledUpMembers(pm);
        IType targetClass = this.getTargetClass();
        ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
        int i = 0;
        while (i < accessedTypes.length) {
            IType iType = accessedTypes[i];
            if (iType.exists() && !this.canBeAccessedFrom((IMember)iType, targetClass, targetSupertypes)) {
                String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.type_not_accessible", new String[]{PullUpRefactoring.createTypeLabel(iType), PullUpRefactoring.createTypeLabel(targetClass)});
                result.addError(message, JavaStatusContext.create((IMember)iType));
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedFields(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToPullUp);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToPullUp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
        int i = 0;
        while (i < accessedFields.length) {
            IField field = accessedFields[i];
            if (field.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(field) || deletedList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.field_not_accessible", new String[]{PullUpRefactoring.createFieldLabel(field), PullUpRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                } else if (this.isDeclaredInSkippedSuperclass((IMember)field, (IProgressMonitor)new NullProgressMonitor())) {
                    String[] keys = new String[]{PullUpRefactoring.createFieldLabel(field), PullUpRefactoring.createTypeLabel(targetClass)};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.field_cannot_be_accessed", keys);
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToPullUp);
        List<IMethod> declaredAbstractList = Arrays.asList(this.fMethodsToDeclareAbstract);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToPullUp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        ITypeHierarchy targetSupertypes = targetClass.newSupertypeHierarchy(null);
        int i = 0;
        while (i < accessedMethods.length) {
            IMethod method = accessedMethods[i];
            if (method.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(method) || deletedList.contains(method) || declaredAbstractList.contains(method) || this.canBeAccessedFrom((IMember)method, targetClass, targetSupertypes);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.method_not_accessible", new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                } else if (this.isDeclaredInSkippedSuperclass((IMember)method, (IProgressMonitor)new NullProgressMonitor())) {
                    String[] keys = new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(targetClass)};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.method_cannot_be_accessed", keys);
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private boolean isDeclaredInSkippedSuperclass(IMember member, IProgressMonitor pm) throws JavaModelException {
        return this.getSkippedSuperclasses(pm).contains(member.getDeclaringType());
    }

    private Set getSkippedSuperclasses(IProgressMonitor pm) throws JavaModelException {
        Set set;
        block4: {
            pm.beginTask("", 1);
            if (this.fCachedSkippedSuperclasses == null || !this.getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1)).getType().equals(this.getTargetClass())) break block4;
            Set set2 = this.fCachedSkippedSuperclasses;
            Object var4_4 = null;
            pm.done();
            return set2;
        }
        try {
            ITypeHierarchy hierarchy = this.getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.fCachedSkippedSuperclasses = new HashSet(2);
            IType current = hierarchy.getSuperclass(this.getDeclaringType());
            while (current != null && !current.equals(this.getTargetClass())) {
                this.fCachedSkippedSuperclasses.add(current);
                current = hierarchy.getSuperclass(current);
            }
            set = this.fCachedSkippedSuperclasses;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return set;
    }

    private boolean canBeAccessedFrom(IMember member, IType newHome, ITypeHierarchy newHomeSupertypes) throws JavaModelException {
        Assert.isTrue(!(member instanceof IInitializer));
        if (!member.exists()) {
            return false;
        }
        if (newHome.equals(member.getDeclaringType())) {
            return true;
        }
        if (newHome.equals(member)) {
            return true;
        }
        if (JdtFlags.isPrivate(member)) {
            return false;
        }
        if (member.getDeclaringType() == null) {
            if (!(member instanceof IType)) {
                return false;
            }
            if (JdtFlags.isPublic(member)) {
                return true;
            }
            if (!JdtFlags.isPackageVisible(member)) {
                return false;
            }
            if (JavaModelUtil.isSamePackage(((IType)member).getPackageFragment(), newHome.getPackageFragment())) {
                return true;
            }
            return newHomeSupertypes.contains(member.getDeclaringType());
        }
        IType enclosingType = member.getDeclaringType();
        if (!this.canBeAccessedFrom((IMember)enclosingType, newHome, newHomeSupertypes)) {
            return false;
        }
        if (enclosingType.equals(this.getDeclaringType())) {
            return false;
        }
        if (JdtFlags.isPublic(member)) {
            return true;
        }
        if (JavaModelUtil.isSamePackage(enclosingType.getPackageFragment(), newHome.getPackageFragment())) {
            return true;
        }
        return JdtFlags.isProtected(member) && newHomeSupertypes.contains(enclosingType);
    }

    private RefactoringStatus checkMembersInTypeAndAllSubtypes(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 3);
        Set notDeletedMembers = this.getNotDeletedMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        HashSet notDeletedMembersInTargetType = new HashSet();
        HashSet notDeletedMembersInSubtypes = new HashSet();
        this.splitNotDeletedMembers(notDeletedMembers, notDeletedMembersInTargetType, notDeletedMembersInSubtypes);
        this.checkMembersInDestinationType(result, notDeletedMembersInTargetType);
        this.checkAccessModifiers(result, notDeletedMembersInSubtypes);
        this.checkMethodReturnTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result, notDeletedMembersInSubtypes);
        this.checkFieldTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        pm.done();
        return result;
    }

    private void splitNotDeletedMembers(Set originals, Set inTargetType, Set inSubTypes) {
        Iterator iter = originals.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (this.getTargetClass().equals(member.getDeclaringType())) {
                inTargetType.add(member);
                continue;
            }
            inSubTypes.add(member);
        }
    }

    private void checkMembersInDestinationType(RefactoringStatus result, Set notDeletedMembersInTargetType) throws JavaModelException {
        IMember[] membersToBeCreatedInTargetClass = this.getMembersToBeCreatedInTargetClass();
        ArrayList<IMember> newMembersInDestinationType = new ArrayList<IMember>(membersToBeCreatedInTargetClass.length);
        newMembersInDestinationType.addAll(Arrays.asList(membersToBeCreatedInTargetClass));
        newMembersInDestinationType.addAll(notDeletedMembersInTargetType);
        newMembersInDestinationType.removeAll(Arrays.asList(this.fMethodsToDelete));
        IMember[] members = newMembersInDestinationType.toArray(new IMember[newMembersInDestinationType.size()]);
        result.merge(MemberCheckUtil.checkMembersInDestinationType(members, this.getTargetClass()));
    }

    private void checkMethodReturnTypes(IProgressMonitor pm, RefactoringStatus result, Set notDeletedMembersInSubtypes) throws JavaModelException {
        Map mapping = this.getMatchingMemberMatching(pm, true);
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            if (members[i].getElementType() == 9) {
                IMethod method = (IMethod)members[i];
                String returnType = PullUpRefactoring.getReturnTypeName(method);
                Assert.isTrue(mapping.containsKey(method));
                Iterator iter = ((Set)mapping.get(method)).iterator();
                while (iter.hasNext()) {
                    IMethod matchingMethod = (IMethod)iter.next();
                    if (method.equals(matchingMethod) || !notDeletedMembersInSubtypes.contains(matchingMethod) || returnType.equals(PullUpRefactoring.getReturnTypeName(matchingMethod))) continue;
                    String[] keys = new String[]{PullUpRefactoring.createMethodLabel(matchingMethod), PullUpRefactoring.createTypeLabel(matchingMethod.getDeclaringType())};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.different_method_return_type", keys);
                    RefactoringStatusContext context = JavaStatusContext.create(matchingMethod.getCompilationUnit(), matchingMethod.getNameRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    private void checkFieldTypes(IProgressMonitor pm, RefactoringStatus result) throws JavaModelException {
        Map mapping = this.getMatchingMemberMatching(pm, true);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            if (this.fMembersToPullUp[i].getElementType() == 8) {
                IField field = (IField)this.fMembersToPullUp[i];
                String type = PullUpRefactoring.getTypeName(field);
                Assert.isTrue(mapping.containsKey(field));
                Iterator iter = ((Set)mapping.get(field)).iterator();
                while (iter.hasNext()) {
                    IField matchingField = (IField)iter.next();
                    if (field.equals(matchingField) || type.equals(PullUpRefactoring.getTypeName(matchingField))) continue;
                    String[] keys = new String[]{PullUpRefactoring.createFieldLabel(matchingField), PullUpRefactoring.createTypeLabel(matchingField.getDeclaringType())};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.different_field_type", keys);
                    RefactoringStatusContext context = JavaStatusContext.create(matchingField.getCompilationUnit(), matchingField.getSourceRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    private Map getMatchingMemberMatching(IProgressMonitor pm, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        return this.getMatchingMembersMappingFromTypeAndAllSubtypes(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass(), includeMethodsToDeclareAbstract);
    }

    private void checkAccessModifiers(RefactoringStatus result, Set notDeletedMembersInSubtypes) throws JavaModelException {
        List<IMethod> toDeclareAbstract = Arrays.asList(this.fMethodsToDeclareAbstract);
        Iterator iter = notDeletedMembersInSubtypes.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (member.getElementType() != 9 || toDeclareAbstract.contains(member)) continue;
            this.checkMethodAccessModifiers(result, (IMethod)member);
        }
    }

    private void checkMethodAccessModifiers(RefactoringStatus result, IMethod method) throws JavaModelException {
        if (PullUpRefactoring.isVisibilityLowerThanProtected((IMember)method)) {
            String[] keys = new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(method.getDeclaringType())};
            String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.lower_visibility", keys);
            RefactoringStatusContext errorContext = JavaStatusContext.create((IMember)method);
            result.addError(message, errorContext);
        }
    }

    private static String getReturnTypeName(IMethod method) throws JavaModelException {
        return Signature.toString((String)Signature.getReturnType((String)method.getSignature()).toString());
    }

    private static String getTypeName(IField field) throws JavaModelException {
        return Signature.toString((String)field.getTypeSignature());
    }

    private Set getNotDeletedMembers(IProgressMonitor pm) throws JavaModelException {
        HashSet<IMember> matchingSet = new HashSet<IMember>();
        pm.beginTask("", 2);
        matchingSet.addAll(Arrays.asList(this.getMatchingElements((IProgressMonitor)new SubProgressMonitor(pm, 1), true)));
        matchingSet.removeAll(Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1))));
        pm.done();
        return matchingSet;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    private static boolean isVisibilityLowerThanProtected(IMember member) throws JavaModelException {
        return !JdtFlags.isPublic(member) && !JdtFlags.isProtected(member);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("PullUpRefactoring.Pull_Up"), (Change[])this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearCaches();
            throw throwable;
        }
        pm.done();
        this.clearCaches();
        return dynamicValidationStateChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.preview"), 4);
            ICompilationUnit declaringCu = this.getDeclaringCU();
            CompilationUnit declaringCuNode = new RefactoringASTParser(2).parse(declaringCu, true);
            this.addImportsToTargetCu((IProgressMonitor)new SubProgressMonitor(pm, 1), declaringCuNode);
            TextChangeManager manager = new TextChangeManager();
            Map membersToDeleteMap = this.createMembersToDeleteMap((IProgressMonitor)new SubProgressMonitor(pm, 1));
            Map nonAbstractSubclassesMap = this.createNonAbstractSubclassesMapping((IProgressMonitor)new SubProgressMonitor(pm, 1));
            ICompilationUnit[] cus = this.getCompilationUnitsOfSubclassesOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 1);
            subPm.beginTask("", cus.length * 6);
            ICompilationUnit targetCu = this.getTargetCU();
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                if (!this.needsRewriting(cu, membersToDeleteMap, nonAbstractSubclassesMap)) {
                    subPm.worked(6);
                } else {
                    CompilationUnit cuNode = cu.equals(declaringCu) ? declaringCuNode : new RefactoringASTParser(2).parse(cu, true);
                    OldASTRewrite rewrite = new OldASTRewrite((ASTNode)cuNode);
                    if (membersToDeleteMap.containsKey(cu)) {
                        List members = (List)membersToDeleteMap.get(cu);
                        PullUpRefactoring.deleteDeclarationNodes(cuNode, rewrite, members);
                    }
                    if (cu.equals(targetCu)) {
                        if (this.shouldMakeTargetClassAbstract()) {
                            this.makeTargetClassAbstract(rewrite, cuNode);
                        }
                        this.copyMembersToTargetClass(declaringCuNode, cuNode, rewrite, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), status);
                        this.createAbstractMethodsInTargetClass(cuNode, declaringCuNode, rewrite, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), status);
                    } else {
                        subPm.worked(2);
                    }
                    if (cu.equals(declaringCu)) {
                        this.increaseVisibilityOfMethodsDeclaredAbstract(rewrite, cuNode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 2), status);
                    } else {
                        subPm.worked(2);
                    }
                    if (nonAbstractSubclassesMap.containsKey(cu)) {
                        List subclasses = (List)nonAbstractSubclassesMap.get(cu);
                        this.addMethodStubsToNonAbstractSubclassesOfTargetClass(subclasses, cuNode, declaringCuNode, rewrite, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 2), status);
                    }
                    this.addTextEditFromRewrite(manager, cu, rewrite);
                    if (subPm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                ++i;
            }
            subPm.done();
            textChangeManager = manager;
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private static void deleteDeclarationNodes(CompilationUnit cuNode, OldASTRewrite rewrite, List members) throws JavaModelException {
        List declarationNodes = PullUpRefactoring.getDeclarationNodes(cuNode, members);
        Iterator iter = declarationNodes.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            if (node instanceof VariableDeclarationFragment) {
                if (!(node.getParent() instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)node.getParent();
                if (PullUpRefactoring.areAllFragmentsDeleted(fd, declarationNodes)) {
                    rewrite.remove((ASTNode)fd, null);
                    continue;
                }
                rewrite.remove(node, null);
                continue;
            }
            rewrite.remove(node, null);
        }
    }

    private static boolean areAllFragmentsDeleted(FieldDeclaration fd, List declarationNodes) {
        Iterator iter = fd.fragments().iterator();
        while (iter.hasNext()) {
            if (declarationNodes.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static List getDeclarationNodes(CompilationUnit cuNode, List members) throws JavaModelException {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(members.size());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            VariableDeclarationFragment declarationNode = null;
            if (member instanceof IField) {
                declarationNode = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, cuNode);
            } else if (member instanceof IType) {
                declarationNode = ASTNodeSearchUtil.getTypeDeclarationNode((IType)member, cuNode);
            } else if (member instanceof IMethod) {
                declarationNode = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, cuNode);
            }
            if (declarationNode == null) continue;
            result.add(declarationNode);
        }
        return result;
    }

    private Map createMembersToDeleteMap(IProgressMonitor pm) throws JavaModelException {
        IMember[] membersToDelete = this.getMembersToDelete(pm);
        HashMap result = new HashMap();
        int i = 0;
        while (i < membersToDelete.length) {
            IMember member = membersToDelete[i];
            ICompilationUnit cu = member.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(member);
            ++i;
        }
        return result;
    }

    private boolean needsRewriting(ICompilationUnit unit, Map membersToDeleteMap, Map nonAbstractSubclassesMap) {
        return this.getDeclaringCU().equals(unit) || this.getTargetCU().equals(unit) || membersToDeleteMap.containsKey(unit) || nonAbstractSubclassesMap.containsKey(unit);
    }

    private void addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, OldASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChange textChange = manager.get(cu);
        if (this.fImportManager.hasImportEditFor(cu)) {
            resultingEdits.addChild(this.fImportManager.getImportRewrite(cu).createEdit(textBuffer.getDocument()));
        }
        TextChangeCompatibility.addTextEdit(textChange, RefactoringCoreMessages.getString("PullUpRefactoring.42"), (TextEdit)resultingEdits);
        rewrite.removeModifications();
    }

    private ICompilationUnit[] getCompilationUnitsOfSubclassesOfTargetClass(IProgressMonitor pm) throws JavaModelException {
        IType[] allSubtypes = this.getTypeHierarchyOfTargetClass(pm).getAllSubtypes(this.getTargetClass());
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(allSubtypes.length);
        int i = 0;
        while (i < allSubtypes.length) {
            result.add(allSubtypes[i].getCompilationUnit());
            ++i;
        }
        result.add(this.getTargetCU());
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void increaseVisibilityOfMethodsDeclaredAbstract(OldASTRewrite rewrite, CompilationUnit cuNode, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        int i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            IMethod method = this.fMethodsToDeclareAbstract[i];
            if (this.needsToChangeVisibility((IMember)method, false, pm, status)) {
                MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, cuNode);
                int newModifiers = this.getModifiersWithUpdatedVisibility((IMember)method, methodDeclaration.getModifiers(), pm, false, status);
                rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS_PROPERTY, new Integer(newModifiers), null);
            }
            ++i;
        }
    }

    private void createAbstractMethodsInTargetClass(CompilationUnit targetCuNode, CompilationUnit declaringCuNode, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        TypeDeclaration targetClass = ASTNodeSearchUtil.getTypeDeclarationNode(this.getTargetClass(), targetCuNode);
        pm.beginTask("", this.fMethodsToDeclareAbstract.length);
        int i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            this.createAbstractMethodInTargetClass(this.fMethodsToDeclareAbstract[i], declaringCuNode, rewrite, targetClass, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            ++i;
        }
        pm.done();
    }

    private void createAbstractMethodInTargetClass(IMethod sourceMethod, CompilationUnit declaringCuNode, OldASTRewrite rewrite, TypeDeclaration targetClass, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = PullUpRefactoring.getAST(rewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(null);
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodDeclaration.getExtraDimensions());
        newMethod.setJavadoc(null);
        newMethod.setModifiers(this.createModifiersForAbstractDeclaration(sourceMethod, pm, status));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(methodDeclaration.getName(), ast));
        PullUpRefactoring.copyReturnType(rewrite, this.getDeclaringCU(), methodDeclaration, newMethod);
        PullUpRefactoring.copyParameters(rewrite, this.getDeclaringCU(), methodDeclaration, newMethod);
        PullUpRefactoring.copyThrownExceptions(methodDeclaration, newMethod);
        targetClass.bodyDeclarations().add(newMethod);
        rewrite.markAsInserted((ASTNode)newMethod);
    }

    private int createModifiersForAbstractDeclaration(IMethod method, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        int modifiers = 0x400 | JdtFlags.clearFlag(272, method.getFlags());
        return this.getModifiersWithUpdatedVisibility((IMember)method, modifiers, pm, false, status);
    }

    private int getModifiersWithUpdatedVisibility(IMember member, int modifiers, IProgressMonitor pm, boolean considerReferences, RefactoringStatus status) throws JavaModelException {
        if (this.needsToChangeVisibility(member, considerReferences, pm, status)) {
            return JdtFlags.clearAccessModifiers(modifiers) | 4;
        }
        return modifiers;
    }

    private void addMethodStubsToNonAbstractSubclassesOfTargetClass(List concreteSubclasses, CompilationUnit cuNode, CompilationUnit declaringCuNode, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        IType declaringType = this.getDeclaringType();
        IMethod[] methods = this.getAbstractMethodsAddedToTargetClass();
        IType[] typesToImport = this.getTypesReferencedInDeclarations(methods, declaringCuNode);
        pm.beginTask("", concreteSubclasses.size());
        Iterator iter = concreteSubclasses.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            if (clazz.equals(declaringType)) continue;
            boolean anyStubAdded = false;
            TypeDeclaration classToCreateStubIn = ASTNodeSearchUtil.getTypeDeclarationNode(clazz, cuNode);
            ICompilationUnit cuToCreateStubIn = clazz.getCompilationUnit();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 1);
            subPm.beginTask("", methods.length);
            int j = 0;
            while (j < methods.length) {
                IMethod method = methods[j];
                if (JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), clazz) == null) {
                    this.addStub(method, declaringCuNode, classToCreateStubIn, cuToCreateStubIn, rewrite, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), status);
                    anyStubAdded = true;
                }
                ++j;
            }
            subPm.done();
            if (!anyStubAdded) continue;
            this.addImports(typesToImport, clazz.getCompilationUnit());
        }
        pm.done();
    }

    private void addStub(IMethod sourceMethod, CompilationUnit declaringCuNode, TypeDeclaration typeToCreateStubIn, ICompilationUnit newCu, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        MethodDeclaration methodToCreateStubFor = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = PullUpRefactoring.getAST(rewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(PullUpRefactoring.getMethodStubBody(methodToCreateStubFor, ast));
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodToCreateStubFor.getExtraDimensions());
        newMethod.setModifiers(this.createModifiersForMethodStubs(sourceMethod, methodToCreateStubFor, pm, status));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(methodToCreateStubFor.getName(), ast));
        PullUpRefactoring.copyReturnType(rewrite, this.getDeclaringCU(), methodToCreateStubFor, newMethod);
        PullUpRefactoring.copyParameters(rewrite, this.getDeclaringCU(), methodToCreateStubFor, newMethod);
        PullUpRefactoring.copyThrownExceptions(methodToCreateStubFor, newMethod);
        newMethod.setJavadoc(this.createJavadocForStub(typeToCreateStubIn.getName().getIdentifier(), methodToCreateStubFor, newMethod, newCu, rewrite));
        typeToCreateStubIn.bodyDeclarations().add(newMethod);
        rewrite.markAsInserted((ASTNode)newMethod);
    }

    private static Block getMethodStubBody(MethodDeclaration method, AST ast) {
        Block body = ast.newBlock();
        Type returnType = method.getReturnType();
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, returnType, method.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        return body;
    }

    private Javadoc createJavadocForStub(String enclosingTypeName, MethodDeclaration oldMethod, MethodDeclaration newMethodNode, ICompilationUnit cu, OldASTRewrite rewrite) throws CoreException {
        if (!this.fPreferenceSettings.createComments) {
            return null;
        }
        IMethodBinding binding = oldMethod.resolveBinding();
        if (binding == null) {
            return null;
        }
        ITypeBinding[] params = binding.getParameterTypes();
        String fullTypeName = JavaModelUtil.getFullyQualifiedName(this.getTargetClass());
        String[] fullParamNames = new String[params.length];
        int i = 0;
        while (i < fullParamNames.length) {
            fullParamNames[i] = Bindings.getFullyQualifiedName(params[i]);
            ++i;
        }
        String comment = StubUtility.getMethodComment(cu, enclosingTypeName, newMethodNode, true, false, fullTypeName, fullParamNames, String.valueOf('\n'));
        return (Javadoc)rewrite.createStringPlaceholder(comment, 29);
    }

    private int createModifiersForMethodStubs(IMethod method, MethodDeclaration methodDeclaration, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        int modifiers = JdtFlags.clearFlag(1280, methodDeclaration.getModifiers());
        return this.getModifiersWithUpdatedVisibility((IMember)method, modifiers, pm, false, status);
    }

    private Map createNonAbstractSubclassesMapping(IProgressMonitor pm) throws JavaModelException {
        if (!this.shouldAddMethodStubsToConcreteSubclassesOfTargetClass()) {
            return new HashMap(0);
        }
        Set nonAbstractSubclasses = PullUpRefactoring.getNonAbstractSubclasses(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass());
        HashMap result = new HashMap();
        Iterator iter = nonAbstractSubclasses.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            ICompilationUnit cu = type.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(type);
        }
        return result;
    }

    private static Set getNonAbstractSubclasses(ITypeHierarchy hierarchy, IType clazz) throws JavaModelException {
        IType[] subclasses = hierarchy.getSubclasses(clazz);
        HashSet<IType> result = new HashSet<IType>();
        int i = 0;
        while (i < subclasses.length) {
            IType subclass = subclasses[i];
            if (JdtFlags.isAbstract((IMember)subclass)) {
                result.addAll(PullUpRefactoring.getNonAbstractSubclasses(hierarchy, subclass));
            } else {
                result.add(subclass);
            }
            ++i;
        }
        return result;
    }

    private boolean shouldAddMethodStubsToConcreteSubclassesOfTargetClass() throws JavaModelException {
        return this.fCreateMethodStubs && this.getAbstractMethodsAddedToTargetClass().length > 0;
    }

    private void makeTargetClassAbstract(OldASTRewrite rewrite, CompilationUnit cuNode) throws JavaModelException {
        TypeDeclaration targetClass = ASTNodeSearchUtil.getTypeDeclarationNode(this.getTargetClass(), cuNode);
        int newModifiers = targetClass.getModifiers() | 0x400;
        rewrite.set((ASTNode)targetClass, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, new Integer(newModifiers), null);
    }

    private boolean shouldMakeTargetClassAbstract() throws JavaModelException {
        return !JdtFlags.isAbstract((IMember)this.getTargetClass()) && this.getAbstractMethodsAddedToTargetClass().length > 0;
    }

    private IMember[] getMembersToBeCreatedInTargetClass() {
        ArrayList<Object> result = new ArrayList<Object>(this.fMembersToPullUp.length + this.fMethodsToDeclareAbstract.length);
        result.addAll(Arrays.asList(this.fMembersToPullUp));
        result.addAll(Arrays.asList(this.fMethodsToDeclareAbstract));
        return result.toArray(new IMember[result.size()]);
    }

    private IMethod[] getAbstractMethodsAddedToTargetClass() throws JavaModelException {
        IMethod[] toDeclareAbstract = this.fMethodsToDeclareAbstract;
        IMethod[] abstractPulledUp = this.getAbstractMethodsToPullUp();
        ArrayList<IMethod> result = new ArrayList<IMethod>(toDeclareAbstract.length + abstractPulledUp.length);
        result.addAll(Arrays.asList(toDeclareAbstract));
        result.addAll(Arrays.asList(abstractPulledUp));
        return result.toArray(new IMethod[result.size()]);
    }

    private IMethod[] getAbstractMethodsToPullUp() throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMembersToPullUp.length);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember member = this.fMembersToPullUp[i];
            if (member instanceof IMethod && JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private IType getSuperclassOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        return declaringType.newSupertypeHierarchy(pm).getSuperclass(declaringType);
    }

    private void copyMembersToTargetClass(CompilationUnit declaringCuNode, CompilationUnit targetCuNode, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        TypeDeclaration targetClass = ASTNodeSearchUtil.getTypeDeclarationNode(this.getTargetClass(), targetCuNode);
        this.fMembersToPullUp = JavaElementUtil.sortByOffset(this.fMembersToPullUp);
        pm.beginTask("", this.fMembersToPullUp.length);
        int i = this.fMembersToPullUp.length - 1;
        while (i >= 0) {
            IMember member = this.fMembersToPullUp[i];
            if (member instanceof IField) {
                this.copyFieldToTargetClass((IField)member, declaringCuNode, targetClass, rewrite, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            } else if (member instanceof IMethod) {
                this.copyMethodToTargetClass((IMethod)member, declaringCuNode, targetClass, rewrite, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            } else if (member instanceof IType) {
                this.copyTypeToTargetClass((IType)member, declaringCuNode, targetClass, rewrite);
            } else {
                Assert.isTrue(false);
            }
            pm.worked(1);
            --i;
        }
        pm.done();
    }

    private void copyTypeToTargetClass(IType type, CompilationUnit declaringCuNode, TypeDeclaration targetClass, OldASTRewrite rewrite) throws JavaModelException {
        BodyDeclaration newType = this.createNewTypeDeclarationNode(type, declaringCuNode, rewrite);
        rewrite.markAsInserted((ASTNode)newType);
        targetClass.bodyDeclarations().add(newType);
    }

    private BodyDeclaration createNewTypeDeclarationNode(IType type, CompilationUnit declaringCuNode, OldASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration oldType = ASTNodeSearchUtil.getTypeDeclarationNode(type, declaringCuNode);
        return PullUpRefactoring.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, this.getDeclaringCU(), rewrite, true);
    }

    private void copyMethodToTargetClass(IMethod method, CompilationUnit declaringCuNode, TypeDeclaration targetClass, OldASTRewrite targetRewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        MethodDeclaration newMethod = this.createNewMethodDeclarationNode(method, declaringCuNode, targetRewrite, pm, status);
        targetRewrite.markAsInserted((ASTNode)newMethod);
        targetClass.bodyDeclarations().add(newMethod);
    }

    private MethodDeclaration createNewMethodDeclarationNode(IMethod sourceMethod, CompilationUnit declaringCuNode, OldASTRewrite targetRewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        MethodDeclaration sourceMethodNode = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = PullUpRefactoring.getAST(targetRewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        this.copyBodyOfPulledUpMethod(targetRewrite, sourceMethod, sourceMethodNode, newMethod, pm);
        newMethod.setConstructor(sourceMethodNode.isConstructor());
        newMethod.setExtraDimensions(sourceMethodNode.getExtraDimensions());
        PullUpRefactoring.copyJavadocNode(targetRewrite, (IMember)sourceMethod, (BodyDeclaration)sourceMethodNode, (BodyDeclaration)newMethod);
        newMethod.setModifiers(this.getNewModifiers((IMember)sourceMethod, true, pm, status));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(sourceMethodNode.getName(), ast));
        PullUpRefactoring.copyReturnType(targetRewrite, this.getDeclaringCU(), sourceMethodNode, newMethod);
        PullUpRefactoring.copyParameters(targetRewrite, this.getDeclaringCU(), sourceMethodNode, newMethod);
        PullUpRefactoring.copyThrownExceptions(sourceMethodNode, newMethod);
        return newMethod;
    }

    private void copyBodyOfPulledUpMethod(OldASTRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, IProgressMonitor pm) throws JavaModelException {
        if (oldMethod.getBody() == null) {
            newMethod.setBody(null);
            return;
        }
        Block oldBody = oldMethod.getBody();
        ISourceRange[] superRefOffsert = SourceRange.reverseSortByOffset(PullUpRefactoring.findSuperReferenceRanges(method, this.getSuperclassOfDeclaringClass(pm)));
        String oldBodySource = PullUpRefactoring.getBufferText((ASTNode)oldBody, this.getDeclaringCU());
        StringBuffer newBodyCodeBuff = new StringBuffer(oldBodySource);
        int i = 0;
        while (i < superRefOffsert.length) {
            ISourceRange range = superRefOffsert[i];
            int start = range.getOffset() - oldBody.getStartPosition();
            int end = start + range.getLength();
            newBodyCodeBuff.replace(start, end, "this");
            ++i;
        }
        String newBodySource = newBodyCodeBuff.toString();
        String[] lines = Strings.convertIntoLines(newBodySource);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        newBodySource = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
        Block newBody = (Block)targetRewrite.createStringPlaceholder(newBodySource, 8);
        newMethod.setBody(newBody);
    }

    private static ISourceRange[] findSuperReferenceRanges(IMethod method, IType superType) throws JavaModelException {
        Assert.isNotNull(method);
        if (JdtFlags.isStatic((IMember)method)) {
            return new ISourceRange[0];
        }
        SuperReferenceFinderVisitor visitor = new SuperReferenceFinderVisitor(method, superType);
        new RefactoringASTParser(2).parse(method.getCompilationUnit(), true).accept((ASTVisitor)visitor);
        return visitor.getSuperReferenceRanges();
    }

    private static void copyThrownExceptions(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int i = 0;
        int n = oldMethod.thrownExceptions().size();
        while (i < n) {
            Name oldExceptionName = (Name)oldMethod.thrownExceptions().get(i);
            newMethod.thrownExceptions().add(i, PullUpRefactoring.createCopyOfName(oldExceptionName, ast));
            ++i;
        }
    }

    private static Name createCopyOfName(Name name, AST ast) {
        return (Name)ASTNode.copySubtree((AST)ast, (ASTNode)name);
    }

    private static SimpleName createCopyOfSimpleName(SimpleName simpleName, AST ast) {
        return (SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)simpleName);
    }

    private static void copyParameters(OldASTRewrite targetRewrite, ICompilationUnit cu, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        int i = 0;
        int n = oldMethod.parameters().size();
        while (i < n) {
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)oldMethod.parameters().get(i);
            SingleVariableDeclaration newParam = PullUpRefactoring.createPlaceholderForSingleVariableDeclaration(oldParam, cu, targetRewrite);
            newMethod.parameters().add(i, newParam);
            ++i;
        }
    }

    private static void copyReturnType(OldASTRewrite targetRewrite, ICompilationUnit sourceCu, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        Type newReturnType = PullUpRefactoring.createPlaceholderForType(oldMethod.getReturnType(), sourceCu, targetRewrite);
        newMethod.setReturnType(newReturnType);
    }

    private static void copyJavadocNode(OldASTRewrite rewrite, IMember member, BodyDeclaration oldDeclaration, BodyDeclaration newDeclaration) throws JavaModelException {
        Javadoc oldJavaDoc = oldDeclaration.getJavadoc();
        if (oldJavaDoc == null) {
            return;
        }
        String source = oldJavaDoc.getComment();
        String[] lines = Strings.convertIntoLines(source);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        source = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)member));
        Javadoc newJavaDoc = (Javadoc)rewrite.createStringPlaceholder(source, 29);
        newDeclaration.setJavadoc(newJavaDoc);
    }

    private void copyFieldToTargetClass(IField field, CompilationUnit declaringCuNode, TypeDeclaration targetClass, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        FieldDeclaration newField = this.createNewFieldDeclarationNode(field, declaringCuNode, rewrite, pm, status);
        rewrite.markAsInserted((ASTNode)newField);
        targetClass.bodyDeclarations().add(newField);
    }

    private FieldDeclaration createNewFieldDeclarationNode(IField field, CompilationUnit declaringCuNode, OldASTRewrite rewrite, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        AST ast = PullUpRefactoring.getAST(rewrite);
        VariableDeclarationFragment oldFieldFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, declaringCuNode);
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        if (oldFieldFragment.getInitializer() != null) {
            Expression newInitializer = PullUpRefactoring.createPlaceholderForExpression(oldFieldFragment.getInitializer(), field.getCompilationUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(PullUpRefactoring.createCopyOfSimpleName(oldFieldFragment.getName(), ast));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, declaringCuNode);
        PullUpRefactoring.copyJavadocNode(rewrite, (IMember)field, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        newField.setModifiers(this.getNewModifiers((IMember)field, true, pm, status));
        Type newType = PullUpRefactoring.createPlaceholderForType(oldField.getType(), field.getCompilationUnit(), rewrite);
        newField.setType(newType);
        return newField;
    }

    private boolean needsToChangeVisibility(IMember member, boolean considerReferences, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        if (JdtFlags.isPublic(member) || JdtFlags.isProtected(member)) {
            return false;
        }
        if (!considerReferences) {
            return true;
        }
        return this.isReferencedBySomethingElseThanMembersToPull(member, pm, status);
    }

    private boolean isReferencedBySomethingElseThanMembersToPull(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchResultGroup[] references = this.getReferences(member, pm, status);
        if (references.length == 0) {
            return false;
        }
        if (references.length > 1) {
            return true;
        }
        ICompilationUnit referencingCu = references[0].getCompilationUnit();
        if (!this.getDeclaringCU().equals(referencingCu)) {
            return true;
        }
        SearchMatch[] searchResults = references[0].getSearchResults();
        int i = 0;
        while (i < searchResults.length) {
            if (!this.isWithinMemberToPullUp(searchResults[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SearchResultGroup[] getReferences(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        if (!this.fCachedMembersReferences.containsKey(member)) {
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)member);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)member, (int)2);
            this.fCachedMembersReferences.put(member, RefactoringSearchEngine.search(pattern, scope, pm, status));
        }
        return (SearchResultGroup[])this.fCachedMembersReferences.get(member);
    }

    private boolean isWithinMemberToPullUp(SearchMatch result) throws JavaModelException {
        int referenceStart = result.getOffset();
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            if (PullUpRefactoring.liesWithin(this.fMembersToPullUp[i].getSourceRange(), referenceStart)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean liesWithin(ISourceRange range, int offset) {
        return range.getOffset() <= offset && range.getOffset() + range.getLength() >= offset;
    }

    private int getNewModifiers(IMember member, boolean considerReferences, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        return this.getModifiersWithUpdatedVisibility(member, member.getFlags(), pm, considerReferences, status);
    }

    private void addImportsToTargetCu(IProgressMonitor pm, CompilationUnit declaringCuNode) throws CoreException {
        this.addImports(this.getTypesThatNeedToBeImportedInTargetCu(pm, declaringCuNode), this.getTargetCU());
    }

    private void addImports(IType[] typesToImport, ICompilationUnit cu) throws CoreException {
        int i = 0;
        while (i < typesToImport.length) {
            this.fImportManager.addImportTo(typesToImport[i], cu);
            ++i;
        }
    }

    private ICompilationUnit getDeclaringCU() {
        return this.getDeclaringType().getCompilationUnit();
    }

    private ICompilationUnit getTargetCU() {
        return this.getTargetClass().getCompilationUnit();
    }

    private IType[] getTypesThatNeedToBeImportedInTargetCu(IProgressMonitor pm, CompilationUnit declaringCuNode) throws JavaModelException {
        if (this.getTargetCU().equals(this.getDeclaringCU())) {
            return new IType[0];
        }
        IType[] typesInPulledUpMembers = this.getTypeReferencedInPulledUpMembers(pm);
        IType[] typesInMethodsDeclaredAbstract = this.getTypesReferencedInDeclarations(this.fMethodsToDeclareAbstract, declaringCuNode);
        ArrayList<IType> result = new ArrayList<IType>(typesInMethodsDeclaredAbstract.length + typesInPulledUpMembers.length);
        result.addAll(Arrays.asList(typesInMethodsDeclaredAbstract));
        result.addAll(Arrays.asList(typesInPulledUpMembers));
        return result.toArray(new IType[result.size()]);
    }

    private IType[] getTypeReferencedInPulledUpMembers(IProgressMonitor pm) throws JavaModelException {
        if (this.fCachedTypesReferencedInPulledUpMembers == null) {
            this.fCachedTypesReferencedInPulledUpMembers = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToPullUp, pm);
        }
        return this.fCachedTypesReferencedInPulledUpMembers;
    }

    private IType[] getTypesReferencedInDeclarations(IMethod[] methods, CompilationUnit declaringCuNode) throws JavaModelException {
        MethodDeclaration[] methodDeclarations = PullUpRefactoring.getMethodDeclarations(methods, declaringCuNode);
        ITypeBinding[] referencedTypesBindings = ReferenceFinderUtil.getTypesReferencedInDeclarations(methodDeclarations);
        ArrayList<IType> types = new ArrayList<IType>(referencedTypesBindings.length);
        IJavaProject proj = this.getDeclaringType().getJavaProject();
        int i = 0;
        while (i < referencedTypesBindings.length) {
            ITypeBinding typeBinding = referencedTypesBindings[i];
            if (typeBinding != null) {
                IType type;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if ((type = Bindings.findType(typeBinding, proj)) != null) {
                    types.add(type);
                }
            }
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    private static MethodDeclaration[] getMethodDeclarations(IMethod[] methods, CompilationUnit cuNode) throws JavaModelException {
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(methods.length);
        int i = 0;
        while (i < methods.length) {
            result.add(ASTNodeSearchUtil.getMethodDeclarationNode(methods[i], cuNode));
            ++i;
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private static AST getAST(OldASTRewrite rewrite) {
        return rewrite.getAST();
    }

    private static String getBufferText(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        return cu.getBuffer().getText(node.getStartPosition(), node.getLength());
    }

    private static String getNewText(ASTNode astNode, ICompilationUnit cu, boolean removeIndentation) throws JavaModelException {
        String bufferText = PullUpRefactoring.getBufferText(astNode, cu);
        if (removeIndentation) {
            return PullUpRefactoring.getUnindentedText(bufferText, cu);
        }
        return bufferText;
    }

    private static String getUnindentedText(String bufferText, ICompilationUnit cu) throws JavaModelException {
        String[] lines = Strings.convertIntoLines(bufferText);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)cu));
    }

    private static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit cu, OldASTRewrite rewrite) throws JavaModelException {
        return (Expression)rewrite.createStringPlaceholder(PullUpRefactoring.getBufferText((ASTNode)expression, cu), 32);
    }

    private static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, ICompilationUnit cu, OldASTRewrite rewrite) throws JavaModelException {
        return (SingleVariableDeclaration)rewrite.createStringPlaceholder(PullUpRefactoring.getBufferText((ASTNode)declaration, cu), 44);
    }

    private static Type createPlaceholderForType(Type type, ICompilationUnit cu, OldASTRewrite rewrite) throws JavaModelException {
        return (Type)rewrite.createStringPlaceholder(PullUpRefactoring.getBufferText((ASTNode)type, cu), 43);
    }

    private static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, ICompilationUnit cu, OldASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        String newBufferText = PullUpRefactoring.getNewText((ASTNode)bodyDeclaration, cu, removeIndentation);
        return (BodyDeclaration)rewrite.createStringPlaceholder(newBufferText, 55);
    }

    private static class SuperReferenceFinderVisitor
    extends ASTVisitor {
        private Collection fFoundRanges = new ArrayList(0);
        private int fMethodSourceStart;
        private int fMethodSourceEnd;
        private String fMethodSource;
        private String fSuperTypeName;

        SuperReferenceFinderVisitor(IMethod method, IType superType) throws JavaModelException {
            this.fMethodSourceStart = method.getSourceRange().getOffset();
            this.fMethodSourceEnd = method.getSourceRange().getOffset() + method.getSourceRange().getLength();
            this.fMethodSource = method.getSource();
            this.fSuperTypeName = JavaModelUtil.getFullyQualifiedName(superType);
        }

        ISourceRange[] getSuperReferenceRanges() {
            return this.fFoundRanges.toArray(new ISourceRange[this.fFoundRanges.size()]);
        }

        private boolean withinMethod(ASTNode node) {
            return node.getStartPosition() >= this.fMethodSourceStart && node.getStartPosition() <= this.fMethodSourceEnd;
        }

        private ISourceRange getSuperRange(String scanSource) {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(scanSource.toCharArray());
            try {
                int token = scanner.getNextToken();
                while (token != 158) {
                    switch (token) {
                        case 33: {
                            int start = scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenSource().length;
                            int end = scanner.getCurrentTokenEndPosition() + 1;
                            return new SourceRange(start, end - start);
                        }
                    }
                    token = scanner.getNextToken();
                }
            }
            catch (InvalidInputException invalidInputException) {
                return new SourceRange(0, 0);
            }
            return new SourceRange(0, 0);
        }

        private String getSource(int start, int end) {
            return this.fMethodSource.substring(start - this.fMethodSourceStart, end - this.fMethodSourceStart);
        }

        private String getScanSource(SuperMethodInvocation node) {
            return this.getSource(SuperReferenceFinderVisitor.getScanSourceOffset(node), node.getName().getStartPosition());
        }

        private String getScanSource(SuperFieldAccess node) {
            return this.getSource(SuperReferenceFinderVisitor.getScanSourceOffset(node), node.getName().getStartPosition());
        }

        private static int getScanSourceOffset(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                return node.getStartPosition();
            }
            return node.getQualifier().getStartPosition() + node.getQualifier().getLength();
        }

        private static int getScanSourceOffset(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                return node.getStartPosition();
            }
            return node.getQualifier().getStartPosition() + node.getQualifier().getLength();
        }

        public boolean visit(SuperFieldAccess node) {
            if (!this.withinMethod((ASTNode)node)) {
                return true;
            }
            ISourceRange superRange = this.getSuperRange(this.getScanSource(node));
            this.fFoundRanges.add(new SourceRange(superRange.getOffset() + SuperReferenceFinderVisitor.getScanSourceOffset(node), superRange.getLength()));
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            ITypeBinding declaringType;
            if (!this.withinMethod((ASTNode)node)) {
                return true;
            }
            IBinding nameBinding = node.getName().resolveBinding();
            if (nameBinding != null && nameBinding.getKind() == 4 && (declaringType = ((IMethodBinding)nameBinding).getDeclaringClass()) != null && !this.fSuperTypeName.equals(Bindings.getFullyQualifiedName(declaringType))) {
                return true;
            }
            ISourceRange superRange = this.getSuperRange(this.getScanSource(node));
            this.fFoundRanges.add(new SourceRange(superRange.getOffset() + SuperReferenceFinderVisitor.getScanSourceOffset(node), superRange.getLength()));
            return true;
        }

        public boolean visit(TypeDeclarationStatement node) {
            return !this.withinMethod((ASTNode)node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return !this.withinMethod((ASTNode)node);
        }
    }
}

