/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContextType;
import org.eclipse.jdt.internal.corext.template.java.Templates;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.ui.CompatibilityTemplateStore;
import org.eclipse.jdt.internal.ui.EditorInputAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaElementAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.LogicalPackageAdapterFactory;
import org.eclipse.jdt.internal.ui.MarkerAdapterFactory;
import org.eclipse.jdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CustomBufferFactory;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.preferences.MockupPreferenceStore;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderRegistry;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class JavaPlugin
extends AbstractUIPlugin {
    public static final boolean USE_WORKING_COPY_OWNERS = true;
    private static final String TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_templates";
    private static final String CODE_TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_code_templates";
    private static final String TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.templates_migrated";
    private static final String CODE_TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.code_templates_migrated";
    private static JavaPlugin fgJavaPlugin;
    private ContextTypeRegistry fContextTypeRegistry;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fTemplateStore;
    private TemplateStore fCodeTemplateStore;
    private IWorkingCopyManager fWorkingCopyManager;
    private IBufferFactory fBufferFactory;
    private ICompilationUnitDocumentProvider fCompilationUnitDocumentProvider;
    private ClassFileDocumentProvider fClassFileDocumentProvider;
    private JavaTextTools fJavaTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private JavaElementAdapterFactory fJavaElementAdapterFactory;
    private MarkerAdapterFactory fMarkerAdapterFactory;
    private EditorInputAdapterFactory fEditorInputAdapterFactory;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private LogicalPackageAdapterFactory fLogicalPackageAdapterFactory;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private JavaEditorTextHoverDescriptor[] fJavaEditorTextHoverDescriptors;
    private MockupPreferenceStore fMockupPreferenceStore;
    private ASTProvider fASTProvider;
    private IPreferenceStore fCombinedPreferenceStore;
    private JavaFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static JavaPlugin getDefault() {
        return fgJavaPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return JavaPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JavaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IWorkbenchPage[] pages = windows[windowIndex].getPages();
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IEditorReference[] references = pages[pageIndex].getEditorReferences();
                int refIndex = 0;
                while (refIndex < references.length) {
                    IEditorPart editor = references[refIndex].getEditor(false);
                    if (editor != null) {
                        result.add(editor);
                    }
                    ++refIndex;
                }
                ++pageIndex;
            }
            ++windowIndex;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static String getPluginId() {
        return "org.eclipse.jdt.ui";
    }

    public static void log(IStatus status) {
        JavaPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JavaPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(JavaPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        JavaPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, JavaUIMessages.getString("JavaPlugin.internal_error"), e));
    }

    public static boolean isDebug() {
        return JavaPlugin.getDefault().isDebugging();
    }

    public static boolean useNewSearch() {
        return true;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return JavaPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    public JavaPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgJavaPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapters();
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.installPreferenceStoreBackwardsCompatibility();
        AllTypesCache.initialize();
        this.getASTProvider();
    }

    private void installPreferenceStoreBackwardsCompatibility() {
        String fontPropagatedKey = "fontPropagated";
        if (this.getPreferenceStore().contains("org.eclipse.jface.textfont") && !this.getPreferenceStore().isDefault("org.eclipse.jface.textfont") && !this.getPreferenceStore().getBoolean(fontPropagatedKey)) {
            PreferenceConverter.setValue((IPreferenceStore)PlatformUI.getWorkbench().getPreferenceStore(), (String)"org.eclipse.jdt.ui.editors.textfont", (FontData[])PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont"));
        }
        this.getPreferenceStore().setValue(fontPropagatedKey, true);
        PreferenceConverter.putValue((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
        this.fFontPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.editors.textfont".equals(event.getProperty())) {
                    PreferenceConverter.putValue((IPreferenceStore)JavaPlugin.this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        String tabWidthPropagatedKey = "tabWidthPropagated";
        if (this.getPreferenceStore().contains("org.eclipse.jdt.ui.editor.tab.width") && !this.getPreferenceStore().isDefault("org.eclipse.jdt.ui.editor.tab.width") && !this.getPreferenceStore().getBoolean(tabWidthPropagatedKey)) {
            this.getPreferenceStore().setValue("tabWidth", this.getPreferenceStore().getInt("org.eclipse.jdt.ui.editor.tab.width"));
        }
        this.getPreferenceStore().setValue(tabWidthPropagatedKey, true);
        this.getPreferenceStore().putValue("org.eclipse.jdt.ui.editor.tab.width", this.getPreferenceStore().getString("tabWidth"));
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("tabWidth".equals(event.getProperty())) {
                    JavaPlugin.this.getPreferenceStore().putValue("org.eclipse.jdt.ui.editor.tab.width", JavaPlugin.this.getPreferenceStore().getString("tabWidth"));
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.getPreferenceStore().setValue("Refactoring.ErrorPage.severityThreshold", RefactoringCore.getConditionCheckingFailedSeverity());
    }

    private void uninstallPreferenceStoreBackwardsCompatibility() {
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        this.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected ImageRegistry createImageRegistry() {
        return JavaPluginImages.getImageRegistry();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            AllTypesCache.terminate();
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            this.unregisterAdapters();
            if (this.fASTProvider != null) {
                this.fASTProvider.dispose();
                this.fASTProvider = null;
            }
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fCompilationUnitDocumentProvider != null) {
                this.fCompilationUnitDocumentProvider.shutdown();
                this.fCompilationUnitDocumentProvider = null;
            }
            if (this.fJavaTextTools != null) {
                this.fJavaTextTools.dispose();
                this.fJavaTextTools = null;
            }
            JavaDocLocations.shutdownJavadocLocations();
            this.uninstallPreferenceStoreBackwardsCompatibility();
            RefactoringCore.getUndoManager().shutdown();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public synchronized IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            this.fBufferFactory = new CustomBufferFactory();
        }
        return this.fBufferFactory;
    }

    public synchronized ICompilationUnitDocumentProvider getCompilationUnitDocumentProvider() {
        if (this.fCompilationUnitDocumentProvider == null) {
            this.fCompilationUnitDocumentProvider = new CompilationUnitDocumentProvider();
        }
        return this.fCompilationUnitDocumentProvider;
    }

    public synchronized ClassFileDocumentProvider getClassFileDocumentProvider() {
        if (this.fClassFileDocumentProvider == null) {
            this.fClassFileDocumentProvider = new ClassFileDocumentProvider();
        }
        return this.fClassFileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ICompilationUnitDocumentProvider provider = this.getCompilationUnitDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public MockupPreferenceStore getMockupPreferenceStore() {
        if (this.fMockupPreferenceStore == null) {
            this.fMockupPreferenceStore = new MockupPreferenceStore();
        }
        return this.fMockupPreferenceStore;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized JavaTextTools getJavaTextTools() {
        if (this.fJavaTextTools == null) {
            this.fJavaTextTools = new JavaTextTools(this.getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences());
        }
        return this.fJavaTextTools;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        if (this.fMembersOrderPreferenceCache == null) {
            this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        }
        return this.fMembersOrderPreferenceCache;
    }

    public JavaEditorTextHoverDescriptor[] getJavaEditorTextHoverDescriptors() {
        if (this.fJavaEditorTextHoverDescriptors == null) {
            this.fJavaEditorTextHoverDescriptors = JavaEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((JavaEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fJavaEditorTextHoverDescriptors);
            int length = this.fJavaEditorTextHoverDescriptors.length;
            int first = -1;
            int last = length - 1;
            int problemHoverIndex = -1;
            int annotationHoverIndex = -1;
            int i = 0;
            while (i < length) {
                if (!this.fJavaEditorTextHoverDescriptors[i].getId().startsWith("org.eclipse.jdt.ui")) {
                    if (problemHoverIndex != -1 && annotationHoverIndex != -1) {
                        last = i - 1;
                        break;
                    }
                } else {
                    if (first == -1) {
                        first = i;
                    }
                    if (this.fJavaEditorTextHoverDescriptors[i].getId().equals("org.eclipse.jdt.ui.AnnotationHover")) {
                        annotationHoverIndex = i;
                    } else if (this.fJavaEditorTextHoverDescriptors[i].getId().equals("org.eclipse.jdt.ui.ProblemHover")) {
                        problemHoverIndex = i;
                    }
                }
                ++i;
            }
            JavaEditorTextHoverDescriptor hoverDescriptor = null;
            if (first > -1 && problemHoverIndex > -1 && problemHoverIndex != first) {
                hoverDescriptor = this.fJavaEditorTextHoverDescriptors[first];
                this.fJavaEditorTextHoverDescriptors[first] = this.fJavaEditorTextHoverDescriptors[problemHoverIndex];
                this.fJavaEditorTextHoverDescriptors[problemHoverIndex] = hoverDescriptor;
                if (annotationHoverIndex == first) {
                    annotationHoverIndex = problemHoverIndex;
                }
            }
            if (annotationHoverIndex > -1 && annotationHoverIndex != last) {
                hoverDescriptor = this.fJavaEditorTextHoverDescriptors[last];
                this.fJavaEditorTextHoverDescriptors[last] = this.fJavaEditorTextHoverDescriptors[annotationHoverIndex];
                this.fJavaEditorTextHoverDescriptors[annotationHoverIndex] = hoverDescriptor;
            }
            int i2 = 0;
            while (i2 < this.fJavaEditorTextHoverDescriptors.length - 1) {
                if ("org.eclipse.jdt.ui.BestMatchHover".equals(this.fJavaEditorTextHoverDescriptors[i2].getId())) {
                    hoverDescriptor = this.fJavaEditorTextHoverDescriptors[i2];
                    int j = i2;
                    while (j > 0) {
                        this.fJavaEditorTextHoverDescriptors[j] = this.fJavaEditorTextHoverDescriptors[j - 1];
                        --j;
                    }
                    this.fJavaEditorTextHoverDescriptors[0] = hoverDescriptor;
                    break;
                }
                ++i2;
            }
        }
        return this.fJavaEditorTextHoverDescriptors;
    }

    public void resetJavaEditorTextHoverDescriptors() {
        this.fJavaEditorTextHoverDescriptors = null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JavaContextType());
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JavaDocContextType());
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            boolean alreadyMigrated = this.getPreferenceStore().getBoolean(TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            } else {
                this.fTemplateStore = new CompatibilityTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY, Templates.getInstance());
                this.getPreferenceStore().setValue(TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            boolean alreadyMigrated = this.getPreferenceStore().getBoolean(CODE_TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), this.getPreferenceStore(), CODE_TEMPLATES_KEY);
            } else {
                this.fCodeTemplateStore = new CompatibilityTemplateStore(this.getCodeTemplateContextRegistry(), this.getPreferenceStore(), CODE_TEMPLATES_KEY, CodeTemplates.getInstance());
                this.getPreferenceStore().setValue(CODE_TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
            CompatibilityTemplateStore.pruneDuplicates(this.fCodeTemplateStore, true);
        }
        return this.fCodeTemplateStore;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)store);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)store);
        PreferenceConstants.initializeDefaultValues(store);
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    private void registerAdapters() {
        this.fJavaElementAdapterFactory = new JavaElementAdapterFactory();
        this.fMarkerAdapterFactory = new MarkerAdapterFactory();
        this.fEditorInputAdapterFactory = new EditorInputAdapterFactory();
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fLogicalPackageAdapterFactory = new LogicalPackageAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fJavaElementAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fMarkerAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.IEditorInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fEditorInputAdapterFactory, (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.internal.ui.browsing.LogicalPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory, (Class)clazz5);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fJavaElementAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fMarkerAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fEditorInputAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public synchronized JavaFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new JavaFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }
}

