/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.IOException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class PropertiesStructureCreator
implements IStructureCreator {
    private static final String WHITESPACE = " \t\r\n\f";
    private static final String SEPARATORS = "=:";
    private static final String SEPARATORS2 = "=: \t\r\n\f";

    public String getName() {
        return CompareMessages.getString("PropertyCompareViewer.title");
    }

    public IStructureComparator getStructure(final Object input) {
        String content = null;
        if (input instanceof IStreamContentAccessor) {
            try {
                content = JavaCompareUtilities.readString((IStreamContentAccessor)input);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        Document doc = new Document(content != null ? content : "");
        boolean isEditable = false;
        if (input instanceof IEditableContent) {
            isEditable = ((IEditableContent)input).isEditable();
        }
        PropertyNode root = new PropertyNode((IDocument)doc, isEditable){

            void nodeChanged(PropertyNode node) {
                PropertiesStructureCreator.this.save((IStructureComparator)this, input);
            }
        };
        try {
            this.parsePropertyFile(root, (IDocument)doc);
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
        }
        return root;
    }

    public boolean canSave() {
        return true;
    }

    public void save(IStructureComparator structure, Object input) {
        if (input instanceof IEditableContent && structure instanceof PropertyNode) {
            IDocument doc = ((PropertyNode)structure).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String content = doc.get();
            bca.setContent(content.getBytes());
        }
    }

    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    public boolean canRewriteTree() {
        return false;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return JavaCompareUtilities.readString(sca);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
            }
        }
        return null;
    }

    private String readLine(int[] args, IDocument doc) {
        int n = args[0];
        args[0] = n + 1;
        int line = n;
        try {
            IRegion region = doc.getLineInformation(line);
            int start = region.getOffset();
            int length = region.getLength();
            try {
                region = doc.getLineInformation(line + 1);
                args[1] = region.getOffset();
            }
            catch (BadLocationException badLocationException) {
                args[1] = doc.getLength();
            }
            return doc.get(start, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parsePropertyFile(PropertyNode root, IDocument doc) throws IOException {
        start = -1;
        lineStart = 0;
        args = new int[]{0, 0};
        while (true) {
            lineStart = args[1];
            line = this.readLine(args, doc);
            if (line == null) {
                return;
            }
            if (line.length() <= 0) continue;
            firstChar = line.charAt(0);
            if (firstChar != '#' && firstChar != '!') ** GOTO lbl26
            if (start >= 0) continue;
            start = lineStart;
            continue;
lbl-1000:
            // 1 sources

            {
                nextLine = this.readLine(args, doc);
                if (nextLine == null) {
                    nextLine = "";
                }
                line2 = line.substring(0, line.length() - 1);
                startPos = 0;
                while (startPos < nextLine.length()) {
                    if (" \t\r\n\f".indexOf(nextLine.charAt(startPos)) == -1) break;
                    ++startPos;
                }
                nextLine = nextLine.substring(startPos, nextLine.length());
                line = String.valueOf(line2) + nextLine;
lbl26:
                // 2 sources

                ** while (this.needNextLine((String)line))
            }
lbl27:
            // 1 sources

            len = line.length();
            keyPos = 0;
            while (keyPos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(keyPos)) == -1) break;
                ++keyPos;
            }
            separatorPos = keyPos;
            while (separatorPos < len) {
                c = line.charAt(separatorPos);
                if (c == '\\') {
                    ++separatorPos;
                } else if ("=: \t\r\n\f".indexOf(c) != -1) break;
                ++separatorPos;
            }
            valuePos = separatorPos;
            while (valuePos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(valuePos)) == -1) break;
                ++valuePos;
            }
            if (valuePos < len && "=:".indexOf(line.charAt(valuePos)) != -1) {
                ++valuePos;
            }
            while (valuePos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(valuePos)) == -1) break;
                ++valuePos;
            }
            if ((key = this.convert(line.substring(keyPos, separatorPos))).length() <= 0) continue;
            if (start < 0) {
                start = lineStart;
            }
            value = "";
            if (separatorPos < len) {
                value = this.convert(line.substring(valuePos, len));
            }
            length = args[1] - start;
            try {
                s = doc.get(start, length);
                i = s.length() - 1;
                while (i >= 0) {
                    c = s.charAt(i);
                    if (c == '\r' || c == '\n') {
                        --length;
                        --i;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException v0) {}
            new PropertyNode(root, 0, key, value, doc, start, length);
            start = -1;
        }
    }

    private boolean needNextLine(String line) {
        int slashes = 0;
        int ix = line.length() - 1;
        while (ix >= 0 && line.charAt(ix--) == '\\') {
            ++slashes;
        }
        return slashes % 2 == 1;
    }

    private String convert(String s) {
        int l = s.length();
        StringBuffer buf = new StringBuffer(l);
        int i = 0;
        while (i < l) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                if ((c = s.charAt(i++)) == 'u') {
                    int v = 0;
                    int j = 0;
                    while (j < 4) {
                        c = s.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                v = (v << 4) + (c - 48);
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                v = (v << 4) + 10 + (c - 97);
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                v = (v << 4) + 10 + (c - 65);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(CompareMessages.getString("PropertyCompareViewer.malformedEncoding"));
                            }
                        }
                        ++j;
                    }
                    buf.append((char)v);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static class PropertyNode
    extends DocumentRangeNode
    implements ITypedElement {
        private boolean fIsEditable;
        private PropertyNode fParent;

        public PropertyNode(PropertyNode parent, int type, String id, String value, IDocument doc, int start, int length) {
            super(type, id, doc, start, length);
            this.fParent = parent;
            if (parent != null) {
                parent.addChild(this);
                this.fIsEditable = parent.isEditable();
            }
        }

        public PropertyNode(IDocument doc, boolean editable) {
            super(0, "root", doc, 0, doc.getLength());
            this.fIsEditable = editable;
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "txt";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }

        public boolean isEditable() {
            return this.fIsEditable;
        }

        public void setContent(byte[] content) {
            super.setContent(content);
            this.nodeChanged(this);
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            this.nodeChanged(this);
            return child;
        }

        void nodeChanged(PropertyNode node) {
            if (this.fParent != null) {
                this.fParent.nodeChanged(node);
            }
        }
    }
}

