/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class GotoResourceAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    public GotoResourceAction(PackageExplorerPart explorer) {
        this.setText(PackagesMessages.getString("GotoResource.action.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.goto_resource_action");
        this.fPackageExplorer = explorer;
    }

    public void run() {
        TreeViewer viewer = this.fPackageExplorer.getViewer();
        GotoResourceDialog dialog = new GotoResourceDialog(this.fPackageExplorer.getSite().getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), (StructuredViewer)viewer);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return;
        }
        StructuredSelection selection = null;
        IJavaElement element = JavaCore.create((IResource)((IResource)result[0]));
        selection = element != null && element.exists() ? new StructuredSelection((Object)element) : new StructuredSelection(result[0]);
        viewer.setSelection((ISelection)selection, true);
    }

    private static class GotoResourceDialog
    extends ResourceListSelectionDialog {
        private IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

        public GotoResourceDialog(Shell parentShell, IContainer container, StructuredViewer viewer) {
            super(parentShell, container, 7);
            this.setTitle(PackagesMessages.getString("GotoResource.dialog.title"));
            WorkbenchHelp.setHelp((Control)parentShell, (String)"org.eclipse.jdt.ui.goto_resource_dialog");
        }

        protected boolean select(IResource resource) {
            IProject project = resource.getProject();
            try {
                if (project.getNature("org.eclipse.jdt.core.javanature") != null) {
                    return this.fJavaModel.contains(resource);
                }
            }
            catch (CoreException coreException) {}
            return true;
        }
    }
}

