/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.ColorEditor;
import org.eclipse.jdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

class CodeAssistConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private PreferencePage fMainPreferencePage;
    private List fContentAssistColorList;
    private ColorEditor fContentAssistColorEditor;
    private Control fAutoInsertDelayText;
    private Control fAutoInsertJavaTriggerText;
    private Control fAutoInsertJavaDocTriggerText;
    private Label fAutoInsertDelayLabel;
    private Label fAutoInsertJavaTriggerLabel;
    private Label fAutoInsertJavaDocTriggerLabel;
    private Button fCompletionInsertsRadioButton;
    private Button fCompletionOverwritesRadioButton;
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private final String[][] fContentAssistColorListModel = new String[][]{{PreferencesMessages.getString("JavaEditorPreferencePage.backgroundForCompletionProposals"), "content_assist_proposals_background"}, {PreferencesMessages.getString("JavaEditorPreferencePage.foregroundForCompletionProposals"), "content_assist_proposals_foreground"}, {PreferencesMessages.getString("JavaEditorPreferencePage.backgroundForMethodParameters"), "content_assist_parameters_background"}, {PreferencesMessages.getString("JavaEditorPreferencePage.foregroundForMethodParameters"), "content_assist_parameters_foreground"}, {PreferencesMessages.getString("JavaEditorPreferencePage.backgroundForCompletionReplacement"), "content_assist_completion_replacement_background"}, {PreferencesMessages.getString("JavaEditorPreferencePage.foregroundForCompletionReplacement"), "content_assist_completion_replacement_foreground"}};
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            CodeAssistConfigurationBlock.this.fStore.setValue((String)CodeAssistConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            CodeAssistConfigurationBlock.this.fStore.setValue((String)CodeAssistConfigurationBlock.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CodeAssistConfigurationBlock.this.numberFieldChanged((Text)e.widget);
        }
    };

    public CodeAssistConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fMainPreferencePage = mainPreferencePage;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_javadoc"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_show_visible_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_order_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_case_sensitivity"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_add_import"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_insert_completion"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_fill_method_arguments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_guess_method_arguments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_prefix_completion"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite contentAssistComposite = new Composite(parent, 0);
        contentAssistComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contentAssistComposite.setLayout((Layout)layout);
        this.addCompletionRadioButtons(contentAssistComposite);
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.insertSingleProposalsAutomatically");
        this.addCheckBox(contentAssistComposite, label, "content_assist_autoinsert", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.completePrefixes");
        this.addCheckBox(contentAssistComposite, label, "content_assist_prefix_completion", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showOnlyProposalsVisibleInTheInvocationContext");
        this.addCheckBox(contentAssistComposite, label, "content_assist_show_visible_proposals", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.presentProposalsInAlphabeticalOrder");
        this.addCheckBox(contentAssistComposite, label, "content_assist_order_proposals", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.automaticallyAddImportInsteadOfQualifiedName");
        this.addCheckBox(contentAssistComposite, label, "content_assist_add_import", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.fillArgumentNamesOnMethodCompletion");
        Button master = this.addCheckBox(contentAssistComposite, label, "content_assist_fill_method_arguments", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.guessArgumentNamesOnMethodCompletion");
        Button slave = this.addCheckBox(contentAssistComposite, label, "content_assist_guess_method_arguments", 0);
        this.createDependency(master, "content_assist_fill_method_arguments", (Control)slave);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.enableAutoActivation");
        Button autoactivation = this.addCheckBox(contentAssistComposite, label, "content_assist_autoactivation", 0);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlock.this.updateAutoactivationControls();
            }
        });
        label = PreferencesMessages.getString("JavaEditorPreferencePage.autoActivationDelay");
        Control[] labelledTextField = this.addLabelledTextField(contentAssistComposite, label, "content_assist_autoactivation_delay", 4, 0, true);
        this.fAutoInsertDelayLabel = CodeAssistConfigurationBlock.getLabelControl(labelledTextField);
        this.fAutoInsertDelayText = CodeAssistConfigurationBlock.getTextControl(labelledTextField);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.autoActivationTriggersForJava");
        labelledTextField = this.addLabelledTextField(contentAssistComposite, label, "content_assist_autoactivation_triggers_java", 4, 0, false);
        this.fAutoInsertJavaTriggerLabel = CodeAssistConfigurationBlock.getLabelControl(labelledTextField);
        this.fAutoInsertJavaTriggerText = CodeAssistConfigurationBlock.getTextControl(labelledTextField);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.autoActivationTriggersForJavaDoc");
        labelledTextField = this.addLabelledTextField(contentAssistComposite, label, "content_assist_autoactivation_triggers_javadoc", 4, 0, false);
        this.fAutoInsertJavaDocTriggerLabel = CodeAssistConfigurationBlock.getLabelControl(labelledTextField);
        this.fAutoInsertJavaDocTriggerText = CodeAssistConfigurationBlock.getTextControl(labelledTextField);
        Label l = new Label(contentAssistComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.codeAssist.colorOptions"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(contentAssistComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fContentAssistColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(8);
        this.fContentAssistColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.codeAssist.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fContentAssistColorEditor = new ColorEditor(stylesComposite);
        Button colorButton = this.fContentAssistColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        colorButton.setLayoutData((Object)gd);
        this.fContentAssistColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlock.this.handleContentAssistColorListSelection();
            }
        });
        colorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CodeAssistConfigurationBlock.this.fContentAssistColorList.getSelectionIndex();
                String key = CodeAssistConfigurationBlock.this.fContentAssistColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)CodeAssistConfigurationBlock.this.fStore, (String)key, (RGB)CodeAssistConfigurationBlock.this.fContentAssistColorEditor.getColorValue());
            }
        });
        return contentAssistComposite;
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        CodeAssistConfigurationBlock.indent(slave);
        boolean masterState = this.fStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private static Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    private void addCompletionRadioButtons(Composite contentAssistComposite) {
        Composite completionComposite = new Composite(contentAssistComposite, 0);
        GridData ccgd = new GridData();
        ccgd.horizontalSpan = 2;
        completionComposite.setLayoutData((Object)ccgd);
        GridLayout ccgl = new GridLayout();
        ccgl.marginWidth = 0;
        ccgl.numColumns = 2;
        completionComposite.setLayout((Layout)ccgl);
        SelectionAdapter completionSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean insert = CodeAssistConfigurationBlock.this.fCompletionInsertsRadioButton.getSelection();
                CodeAssistConfigurationBlock.this.fStore.setValue("content_assist_insert_completion", insert);
            }
        };
        this.fCompletionInsertsRadioButton = new Button(completionComposite, 16400);
        this.fCompletionInsertsRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.completionInserts"));
        this.fCompletionInsertsRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionInsertsRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        this.fCompletionOverwritesRadioButton = new Button(completionComposite, 16400);
        this.fCompletionOverwritesRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.completionOverwrites"));
        this.fCompletionOverwritesRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionOverwritesRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
    }

    public void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fContentAssistColorListModel.length) {
            this.fContentAssistColorList.add(this.fContentAssistColorListModel[i][0]);
            ++i;
        }
        this.fContentAssistColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CodeAssistConfigurationBlock.this.fContentAssistColorList != null && !CodeAssistConfigurationBlock.this.fContentAssistColorList.isDisposed()) {
                    CodeAssistConfigurationBlock.this.fContentAssistColorList.select(0);
                    CodeAssistConfigurationBlock.this.handleContentAssistColorListSelection();
                }
            }
        });
    }

    void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fStore.getString(key));
        }
        boolean completionInserts = this.fStore.getBoolean("content_assist_insert_completion");
        this.fCompletionInsertsRadioButton.setSelection(completionInserts);
        this.fCompletionOverwritesRadioButton.setSelection(!completionInserts);
        this.updateAutoactivationControls();
        this.updateStatus(this.validatePositiveNumber("0"));
        Iterator iter = this.fMasterSlaveListeners.iterator();
        while (iter.hasNext()) {
            SelectionListener listener = (SelectionListener)iter.next();
            listener.widgetSelected(null);
        }
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.fStore.getBoolean("content_assist_autoactivation");
        this.fAutoInsertDelayText.setEnabled(autoactivation);
        this.fAutoInsertDelayLabel.setEnabled(autoactivation);
        this.fAutoInsertJavaTriggerText.setEnabled(autoactivation);
        this.fAutoInsertJavaTriggerLabel.setEnabled(autoactivation);
        this.fAutoInsertJavaDocTriggerText.setEnabled(autoactivation);
        this.fAutoInsertJavaDocTriggerLabel.setEnabled(autoactivation);
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.handleContentAssistColorListSelection();
        this.initializeFields();
    }

    private void handleContentAssistColorListSelection() {
        int i = this.fContentAssistColorList.getSelectionIndex();
        String key = this.fContentAssistColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)key);
        this.fContentAssistColorEditor.setColorValue(rgb);
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("JavaEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        this.fMainPreferencePage.setValid(status.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, status);
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    public void dispose() {
    }
}

