/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaBasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String OPEN_TYPE_HIERARCHY = "org.eclipse.jdt.ui.openTypeHierarchy";
    private static final String OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE = "perspective";
    private static final String OPEN_TYPE_HIERARCHY_IN_VIEW_PART = "viewPart";
    private static final String DOUBLE_CLICK = "packageview.doubleclick";
    private static final String DOUBLE_CLICK_GOES_INTO = "packageview.gointo";
    private static final String DOUBLE_CLICK_EXPANDS = "packageview.doubleclick.expands";
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;

    public JavaBasePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("JavaBasePreferencePage.description"));
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.java_base_preference_page_context");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Button addCheckBox(Composite parent, String label, String key) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)key);
        button.setLayoutData((Object)gd);
        button.setSelection(this.getPreferenceStore().getBoolean(key));
        this.fCheckBoxes.add(button);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group doubleClickGroup = new Group(result, 0);
        doubleClickGroup.setLayout((Layout)new GridLayout());
        doubleClickGroup.setLayoutData((Object)new GridData(768));
        doubleClickGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.action"));
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.gointo"), DOUBLE_CLICK, DOUBLE_CLICK_GOES_INTO);
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.getString("JavaBasePreferencePage.doubleclick.expand"), DOUBLE_CLICK, DOUBLE_CLICK_EXPANDS);
        Group typeHierarchyGroup = new Group(result, 0);
        typeHierarchyGroup.setLayout((Layout)new GridLayout());
        typeHierarchyGroup.setLayoutData((Object)new GridData(768));
        typeHierarchyGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.openTypeHierarchy"));
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.getString("JavaBasePreferencePage.inPerspective"), OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE);
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.getString("JavaBasePreferencePage.inView"), OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_VIEW_PART);
        Group refactoringGroup = new Group(result, 0);
        refactoringGroup.setLayout((Layout)new GridLayout());
        refactoringGroup.setLayoutData((Object)new GridData(768));
        refactoringGroup.setText(PreferencesMessages.getString("JavaBasePreferencePage.refactoring.title"));
        this.addCheckBox((Composite)refactoringGroup, PreferencesMessages.getString("JavaBasePreferencePage.refactoring.auto_save"), "Refactoring.savealleditors");
        Group group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("JavaBasePreferencePage.search"));
        this.addCheckBox((Composite)group, PreferencesMessages.getString("JavaBasePreferencePage.search.small_menu"), "Search.usereducemenu");
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

